package dev.tazer.clutternomore.fabric;

//? fabric {
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import dev.tazer.clutternomore.Platform;
import net.fabricmc.api.EnvType;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.loader.api.FabricLoader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.nio.file.Path;

import static dev.tazer.clutternomore.fabric.FabricClientEvents.SHAPE_KEY;

public class FabricPlatformImpl implements Platform {

    @Override
    public boolean isModLoaded(String modid) {
        return FabricLoader.getInstance().isModLoaded(modid);
    }

    @Override
    public String loader() {
        return "fabric";
    }

    @Override
    public Path getResourcePack() {
        return FabricLoader.getInstance().getGameDir().resolve("resourcepacks");
    }

    @Override
    public JsonObject getFileInJar(String namespace, String path) {
        try {
            return JsonParser.parseReader(new FileReader(FabricLoader.getInstance().getModContainer(namespace).get().findPath(path).get().toString())).getAsJsonObject();
        } catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Path configPath() {
        return FabricLoader.getInstance().getConfigDir();
    }

    @Override
    public boolean isClient() {
        return FabricLoader.getInstance().getEnvironmentType().equals(EnvType.CLIENT);
    }

    @Override
    public int shapeKey() {
        return KeyBindingHelper.getBoundKeyOf(SHAPE_KEY).method_1444();
    }

}
//?}