package dev.tazer.clutternomore;

import dev.tazer.clutternomore.client.assets.AssetGenerator;
import dev.tazer.clutternomore.client.assets.StepGenerator;
import dev.tazer.clutternomore.client.assets.VerticalSlabGenerator;
import dev.tazer.clutternomore.common.blocks.StepBlock;
import dev.tazer.clutternomore.common.blocks.VerticalSlabBlock;
import dev.tazer.clutternomore.common.blocks.WeatheringStepBlock;
import dev.tazer.clutternomore.common.blocks.WeatheringVerticalSlabBlock;
import dev.tazer.clutternomore.common.data.CNMPackResources;
import dev.tazer.clutternomore.common.data.DataGenerator;
import dev.tazer.clutternomore.common.registry.CBlocks;
import dev.tazer.clutternomore.common.mixin.access.BlockBehaviorAccessor;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1863;
import net.minecraft.class_2248;
import net.minecraft.class_2482;
import net.minecraft.class_2498;
import net.minecraft.class_2510;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3288;
import net.minecraft.class_4970;
import net.minecraft.class_5321;
import net.minecraft.class_5352;
import net.minecraft.class_5813;
import net.minecraft.class_5814;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_9224;
import net.minecraft.class_9225;
import net.minecraft.world.level.block.*;
//? if forge {
/*import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryManager;
*///?} else if fabric {
import dev.tazer.clutternomore.fabric.FabricEntrypoint;
//?}
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Path;
import java.util.*;
import java.util.function.Supplier;

import static dev.tazer.clutternomore.common.data.DataGenerator.*;

public class ClutterNoMore {
    public static final String MODID = "clutternomore";
    public static final Logger LOGGER = LogManager.getLogger("ClutterNoMore");
    public static final CNMConfig.StartupConfig STARTUP_CONFIG = CNMConfig.StartupConfig.createToml(Platform.INSTANCE.configPath(), MODID, "startup", CNMConfig.StartupConfig.class);
    //? if >1.21 {
    private static final class_9224 PACK_INFO = new class_9224(ClutterNoMore.MODID+"-runtime", class_2561.method_43470("ClutterNoMore"), class_5352.field_25348, Optional.empty());
    //?} else {
    /*private static final String PACK_INFO = ClutterNoMore.MODID+"-runtime";
    *///?}
    public static final CNMPackResources RESOURCES = new CNMPackResources(PACK_INFO);
    public static LinkedHashMap<class_2960, class_2960> COPPER_BLOCKS = new LinkedHashMap<>();
    public static ArrayList<class_2960> WAXED_COPPER_BLOCKS = new ArrayList<>();

    public static void init() {
        LOGGER.info("Initializing {} on {}", MODID, Platform.INSTANCE.loader());
    }

    public static class_3288 createPack(class_3264 type) {
        //? if >1.21 {
        return class_3288.method_45275(
                PACK_INFO,
                new PackResourcesSupplier(),
                type,
                new class_9225(
                        true,
                        class_3288.class_3289.field_14281,
                        true
                )
        );
        //?} else {
        /*return Pack.readMetaAndCreate(
                PACK_INFO,
                Component.literal("ClutterNoMore"),
                true,
                new PackResourcesSupplier(),
                type,
                Pack.Position.BOTTOM,
                PackSource.BUILT_IN
        );
        *///?}

    }

    public static class_2960 location(String path) {
        return location(MODID, path);
    }

    public static class_2960 location(String namespace, String path) {
        //? if >1.21
        return class_2960.method_60655(namespace, path);
        //? if <1.21
        /*return new ResourceLocation(namespace, path);*/
    }


    public static class_2960 parse(String id) {
        //? if >1.21
        return class_2960.method_60654(id);
        //? if <1.21
        /*return new ResourceLocation(id);*/
    }

    public static void modifyRecipes(
            //? if >1.21 {
            class_7225.class_7874
            //?} else {
            /*RegistryAccess
            *///?}
                    registries, class_1863 recipeManager) {
        //? if <1.21.2 {
        /*boolean changed = false;
        var originalRecipes = recipeManager.getRecipes();
        ArrayList<
        //? if >1.21 {
        RecipeHolder<?>
         //?} else {
        /^Recipe<?>
        ^///?}
        > newRecipes = new ArrayList<>();

        for (
                //? if >1.21 {
                RecipeHolder<?> recipeHolder
                //?} else {
                /^Recipe<?> recipe
                ^///?}
                        : originalRecipes) {
            //? if >1.21
            Recipe<?> recipe = recipeHolder.value();

            Item result = recipe.getResultItem(registries).getItem();

            if (ShapeMap.isShape(result)) continue;

            NonNullList<Ingredient> ingredients = recipe.getIngredients();
            for (Ingredient ingredient : new ArrayList<>(ingredients)) {
                ArrayList<ItemStack> stacks = new ArrayList<>();
                for (ItemStack stack : ingredient.getItems()) {
                    Item item = stack.getItem();
                    if (ShapeMap.isShape(item)) {
                        ItemStack originalStack = ShapeMap.getParent(item).getDefaultInstance();
                        originalStack.setCount(stack.getCount());
                        stacks.add(originalStack);
                        changed = true;
                    } else stacks.add(stack);
                }

                Stream<ItemStack> newStacks = stacks.stream();
                if (changed) {
                    try {
                        int index = ingredients.indexOf(ingredient);
                        ingredients.set(index, Ingredient.of(newStacks));
                    } catch (Exception ignored) {}
                }
            }


            //? if >1.21 {
            RecipeHolder<?> newHolder = new RecipeHolder<>(recipeHolder.id(), recipe);
            newRecipes.add(newHolder);
            //?} else {
            /^newRecipes.add(recipe);
            ^///?}
        }

        if (changed) {
            recipeManager.replaceRecipes(newRecipes);
        }
        *///?}
    }

    public static void registerVariants() {
        //? if forge {
        /*RegistryManager.ACTIVE.getRegistry(BuiltInRegistries.BLOCK.key()).unfreeze();
        RegistryManager.ACTIVE.getRegistry(BuiltInRegistries.ITEM.key()).unfreeze();
         *///?}
        if (STARTUP_CONFIG.VERTICAL_SLABS.value() || STARTUP_CONFIG.STEPS.value()) {
            LinkedHashMap<String, Supplier<? extends class_2248>> toRegister = new LinkedHashMap<>();
            ArrayList<class_2960> slabs = new ArrayList<>();
            ArrayList<class_2960> stairs = new ArrayList<>();

            List<class_2498> woodenSoundTypes = List.of(
                    class_2498.field_11547,
                    class_2498.field_40314,
                    class_2498.field_42766,
                    class_2498.field_40315
            );
            List<class_2498> shovelSoundTypes = List.of(
                    class_2498.field_11529,
                    class_2498.field_11535
            );


            for (Map.Entry<class_5321<class_1792>, class_1792> resourceKeyItemEntry : class_7923.field_41178.method_29722()) {
                if (resourceKeyItemEntry.getValue().method_8389() instanceof class_1747 blockItem) {
                    var blockId = resourceKeyItemEntry.getKey().method_29177();
                    var blockNamespace = blockId.method_12836() + "/";
                    if (blockId.method_12836().equals("minecraft")) {
                        blockNamespace = "";
                    }
                    if (blockItem.method_7711() instanceof class_2482 slabBlock && slabBlock.method_9564().method_11656().size() == 2 && STARTUP_CONFIG.VERTICAL_SLABS.value()) {
                        String shortPath = "vertical_" + blockId.method_12832();
                        String path = blockNamespace + shortPath;
                        //? if =1.21.1 {
                        /*addAlias(blockNamespace, shortPath, path);
                        *///?}

                        if (slabBlock instanceof class_5813 weatheringSlabBlock) {
                            Supplier<class_2248> block = ()->new WeatheringVerticalSlabBlock(copy(slabBlock)
                                    //? if >1.21.2
                                    .method_63500(CBlocks.registryKey(path))
                                    , weatheringSlabBlock.method_33633()
                            );
                            toRegister.put(path, block);
                            matchCopperBlock(ClutterNoMore.location(path));
                        } else {
                            toRegister.put(path, ()->new VerticalSlabBlock(copy(slabBlock)
                                    //? if >1.21.2
                                    .method_63500(CBlocks.registryKey(path))
                            ));
                            if (path.contains("waxed")) {
                                WAXED_COPPER_BLOCKS.add(ClutterNoMore.location(path));
                            }
                        }

                        slabs.add(blockId);

                        class_2960 shapeId = ClutterNoMore.location(path);
                        DataGenerator.addLootTable(blockId, shapeId);

                        
                        var soundType = ((BlockBehaviorAccessor) slabBlock).getSoundType();

                        if (woodenSoundTypes.contains(soundType)) {
                            woodenVerticalSlabsArray.add(ClutterNoMore.location(path).toString());
                        } else {
                            DataGenerator.addToTag(path, verticalSlabsArray);
                            if (shovelSoundTypes.contains(soundType)) DataGenerator.addToTag(path, shovelMineableArray);
                            else DataGenerator.addToTag(path, pickaxeMineableArray);
                        }
                    }

                    if (blockItem.method_7711() instanceof class_2510 stairBlock && stairBlock.method_9564().method_11656().size() == 4 && STARTUP_CONFIG.STEPS.value()) {
                        String shortPath = blockId.method_12832().replace("stairs", "step");
                        String path = blockNamespace + shortPath;
                        //? if =1.21.1 {
                        /*addAlias(blockNamespace, shortPath, path);
                        *///?}
                        if (stairBlock instanceof class_5814 weatheringCopperStairBlock) {
                            Supplier<class_2248> block = ()->new WeatheringStepBlock(copy(stairBlock)
                                    //? if >1.21.2
                                    .method_63500(CBlocks.registryKey(path))
                                    , weatheringCopperStairBlock.method_33634()
                            );
                            toRegister.put(path, block);
                            matchCopperBlock(ClutterNoMore.location(path));
                        } else {
                            toRegister.put(path, ()->new StepBlock(copy(stairBlock)
                                    //? if >1.21.2
                                    .method_63500(CBlocks.registryKey(path))
                            ));
                            if (path.contains("waxed")) {
                                WAXED_COPPER_BLOCKS.add(ClutterNoMore.location(path));
                            }
                        }


                        stairs.add(blockId);

                        class_2960 shapeId = ClutterNoMore.location(path);
                        DataGenerator.addLootTable(blockId, shapeId);

                        var soundType = ((BlockBehaviorAccessor) stairBlock).getSoundType();

                        if (woodenSoundTypes.contains(soundType)) {
                            DataGenerator.addToTag(shapeId, woodenStepsArray);
                        } else {
                            DataGenerator.addToTag(shapeId, stepsArray);
                            if (shovelSoundTypes.contains(soundType)) DataGenerator.addToTag(path, shovelMineableArray);
                            else DataGenerator.addToTag(path, pickaxeMineableArray);
                        }
                    }
                }
            }
            toRegister.forEach(CBlocks::register);
            AssetGenerator.keys = toRegister.keySet();
            VerticalSlabGenerator.SLABS = slabs;
            StepGenerator.STAIRS = stairs;
            DataGenerator.generate();
            Platform.INSTANCE.finalizeCopperBlockRegistration();
        }
    }

    private static void matchCopperBlock(class_2960 id) {
        if (id.method_12832().contains("oxidized")) {
            var weatheredPath = ClutterNoMore.location(id.method_12836(), id.method_12832().replace("oxidized", "weathered"));
            COPPER_BLOCKS.put(weatheredPath, id);
        }
        if (id.method_12832().contains("weathered")) {
            var exposed = ClutterNoMore.location(id.method_12836(), id.method_12832().replace("weathered", "exposed"));
            COPPER_BLOCKS.put(exposed, id);
        }
        if (id.method_12832().contains("exposed")) {
            var unaffected = ClutterNoMore.location(id.method_12836(), id.method_12832().replace("exposed_", ""));
            COPPER_BLOCKS.put(unaffected, id);
        }
    }

    //? if =1.21.1 {
    /*public static final ArrayList<ResourceLocation> ALIASES = new ArrayList<>();
    private static void addAlias(String blockNamespace, String shortPath, String path) {
        if (ClutterNoMore.STARTUP_CONFIG.ALIASES.value()) {
            ResourceLocation shortNamespace = ClutterNoMore.location(shortPath);
            if (!blockNamespace.isEmpty() && !ALIASES.contains(shortNamespace)) {
                ResourceLocation id = ClutterNoMore.location(path);
                BuiltInRegistries.BLOCK.addAlias(shortNamespace, id);
                BuiltInRegistries.ITEM.addAlias(shortNamespace, id);
                ALIASES.add(shortNamespace);
            }
        }
    }
    *///?}

    public static final Path pack = Platform.INSTANCE.getResourcePack().resolve("clutternomore");

    public static void writeFile(Path path, Path filePath, String contents) {
        try {
            path.toFile().mkdirs();
            FileWriter langWriter = new FileWriter(filePath.toFile());
            langWriter.write(contents);
            langWriter.close();  // must close manually
            ClutterNoMore.LOGGER.debug("Successfully wrote to {}", filePath);
        } catch (IOException e) {
            ClutterNoMore.LOGGER.error("Failed to write dynamic data. %s".formatted(e));
        }
    }

    public static class_4970.class_2251 copy(class_2248 block) {
        //? if >1.21
        return class_4970.class_2251.method_9630(block);
        //? if <1.21
        /*return BlockBehaviour.Properties.copy(block);*/
    }

    private static class PackResourcesSupplier implements class_3288.class_7680 {
        //? if >1.21 {
        @Override
        public class_3262 method_52424(class_9224 location) {
            return RESOURCES;
        }

        @Override
        public class_3262 method_52425(class_9224 location, class_3288.class_7679 metadata) {
            return RESOURCES;
        }
        //?} else {
        /*@Override
        public PackResources open(String s) {
            return RESOURCES;
        }
        *///?}
    }
}