package dev.tazer.clutternomore.client;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.tazer.clutternomore.CNMConfig;
import dev.tazer.clutternomore.ClutterNoMore;
import dev.tazer.clutternomore.ClutterNoMoreClient;
import dev.tazer.clutternomore.common.shape_map.ShapeMap;
//? if fabric || neoforge {
import dev.tazer.clutternomore.common.networking.ChangeStackPayload;
//? if neoforge {
/*import net.neoforged.neoforge.network.PacketDistributor;
 *///?} else if fabric {
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
//?} else if forge && <1.21.1 {
/*import dev.tazer.clutternomore.forge.networking.ForgeNetworking;
*///?}
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ShapeSwitcherOverlay {

    public final class_310 minecraft;
    public final boolean render;
    public final int selected;
    public int count;
    public final List<class_1792> shapes;
    public int selectedIndex;
    public float currentIndex;

    public ShapeSwitcherOverlay(class_310 minecraft, class_1799 heldStack, boolean render) {
        this.minecraft = minecraft;
        this.render = render;
        selected = minecraft.field_1724.method_31548()
        //? if >1.21.2 {
        .method_67532();
        //?} else {
        /*.selected;
        *///?}

        class_1792 item = ShapeMap.getParent(heldStack.method_7909());
        count = heldStack.method_7947();

        shapes = new ArrayList<>(ShapeMap.getShapes(item));
        shapes.add(0, item);

        selectedIndex = shapes.indexOf(heldStack.method_7909());
        currentIndex = selectedIndex;
    }

    public void render(class_332 guiGraphics, float partialTick) {
        class_2960 background = ClutterNoMore.location("textures/gui/shape_background.png");
        class_2960 selected = ClutterNoMore.location("textures/gui/selected_shape.png");

        int y = guiGraphics.method_51443() / 2 + 20;
        int centreX = guiGraphics.method_51421() / 2 - 8;
        int spacing = 22;
        int startX;

        float smoothing = 1 - (float) Math.exp(-5 * partialTick);
        currentIndex = class_3532.method_16439(smoothing, currentIndex, selectedIndex);

        if (ClutterNoMoreClient.CLIENT_CONFIG.SCROLLING.value()) {
            startX = class_3532.method_15375(centreX - currentIndex * spacing);

            //? if <1.21.2
            /*RenderSystem.enableBlend();*/
            guiGraphics.method_25290(
                    //? if >1.21.6
                    /*RenderPipelines.GUI_TEXTURED,*/
                    //? =1.21.5
                    class_1921::method_62277,
                    selected, centreX - 3, y - 3, 0, 0, 22, 22, 22, 22);

            for (int index = 0; index < shapes.size(); index++) {
                int x = startX + index * spacing;
                //? if <1.21.2
                /*RenderSystem.enableBlend();*/
                guiGraphics.method_25290(
                        //? if >1.21.6
                        /*RenderPipelines.GUI_TEXTURED,*/
                        //? =1.21.5
                        class_1921::method_62277,
                        background, x, y, 0, 0, 16, 16, 16, 16);

                guiGraphics.method_51427(shapes.get(index).method_7854(), x, y);
            }

        } else {
            startX = class_3532.method_15375(centreX - (float) shapes.size() / 2 * spacing) + spacing / 2;

            for (int index = 0; index < shapes.size(); index++) {
                int x = startX + index * spacing;
                //? if <1.21.2
                /*RenderSystem.enableBlend();*/
                guiGraphics.method_25290(
                        //? if >1.21.6
                        /*RenderPipelines.GUI_TEXTURED,*/
                        //? =1.21.5
                        class_1921::method_62277,
                        background, x, y, 0, 0, 16, 16, 16, 16);

                guiGraphics.method_51427(shapes.get(index).method_7854(), x, y);
            }
            //? if <1.21.2
            /*RenderSystem.enableBlend();*/
            guiGraphics.method_25290(
                    //? if >1.21.6
                    /*RenderPipelines.GUI_TEXTURED,*/
                    //? =1.21.5
                    class_1921::method_62277,
                    selected, class_3532.method_15375(startX + currentIndex * spacing) - 3, y - 3, 0, 0, 22, 22, 22, 22);
        }
        //? if <1.21.2
        /*RenderSystem.disableBlend();*/
    }

    public void onMouseScrolled(int direction) {
        changeSlot(selectedIndex-direction);
    }

    public void changeSlot(int newIndex) {
        int maxIndex = shapes.size() - 1;
        selectedIndex = newIndex;
        if (ClutterNoMoreClient.CLIENT_CONFIG.WRAP_SCROLLING.value()) {
            if (selectedIndex < 0) selectedIndex = maxIndex;
            if (selectedIndex > maxIndex) selectedIndex = 0;
        } else {
            if (selectedIndex < 0) selectedIndex = 0;
            if (selectedIndex > maxIndex) selectedIndex = maxIndex;
        }

        class_1792 nextItem = shapes.get(selectedIndex);
        class_1799 next = nextItem.method_7854();
        next.method_7939(count);
        class_1657 player = Objects.requireNonNull(minecraft.field_1724);
        player.method_5783(class_3417.field_15015.comp_349(), 0.3F, 1.5F);
        player.method_6122(class_1268.field_5808, next);

        //? if fabric {
        ClientPlayNetworking.send(new ChangeStackPayload(-1, -1, next));
        //?} else if neoforge {
        /*PacketDistributor.sendToServer(new ChangeStackPayload(-1, -1, next));
        *///?} else if forge && <1.21.1 {
        /*ForgeNetworking.sendToServer(new ChangeStackPacket(-1, -1, next));
        *///?}
    }

    public boolean shouldStayOpenThisTick() {
        int selected = minecraft.field_1724.method_31548()
        //? if >1.21.2 {
        .method_67532();
        //?} else {
        /*.selected;
        *///?}
        class_1799 heldStack = minecraft.field_1724.method_5998(class_1268.field_5808);
        count = heldStack.method_7947();
        return shapes.contains(heldStack.method_7909()) && selected == this.selected;
    }
}
