package dev.tazer.clutternomore.client.assets;

import com.google.gson.JsonObject;
import dev.tazer.clutternomore.ClutterNoMore;
import dev.tazer.clutternomore.common.blocks.StepBlock;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.class_2350;
import net.minecraft.class_2771;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;

import static dev.tazer.clutternomore.client.assets.AssetGenerator.write;

public final class StepGenerator {
    public static ArrayList<class_2960> STAIRS = new ArrayList<>();

    public static void generate(class_3300 manager) {
        for (class_2960 parent : STAIRS) {
            String namespace = parent.method_12836() + "/";
            if (parent.method_12836().equals("minecraft")) namespace = "";

            class_2960 shape = ClutterNoMore.location(namespace + parent.method_12832().replace("stairs", "step"));

            try {
                generateBlock(parent, shape, manager);
                AssetGenerator.generateItem(shape, manager);
            } catch (IOException e) {
                ClutterNoMore.LOGGER.catching(e);
                throw new RuntimeException(e);
            }
        }
    }

    public static void generateBlock(class_2960 parent, class_2960 shape, class_3300 manager) throws IOException {
        Optional<class_3298> existingBlockState = manager.method_14486(shape.method_45138("blockstates/").method_48331(".json"));
        if (existingBlockState.isPresent()) return;

        JsonObject textures = AssetGenerator.getTextures(manager, parent);
        if (textures == null) return;

        JsonObject blockModel = new JsonObject();
        blockModel.addProperty("parent", "clutternomore:block/templates/step");
        blockModel.add("textures", textures);
        write("models/block/%s.json".formatted(shape.method_12832()), blockModel);
        blockModel.addProperty("parent", "clutternomore:block/templates/step_double");
        write("models/block/%s_double.json".formatted(shape.method_12832()), blockModel);
        blockModel.addProperty("parent", "clutternomore:block/templates/step_top");
        write("models/block/%s_top.json".formatted(shape.method_12832()), blockModel);

        JsonObject variants = new JsonObject();
        StepBlock.field_11177.method_30043().forEach(directionValue -> {
            StepBlock.SLAB_TYPE.method_30043().forEach(doubleState->{
                JsonObject model = new JsonObject();
                String modelString = "clutternomore:block/"+shape.method_12832();
                modelString = modelString.replace("waxed_", "");

                model.addProperty("uvlock", true);

                if (doubleState.comp_71().equals(class_2771.field_12682)) {
                    model.addProperty("model", modelString+"_double");
                } else if (doubleState.comp_71().equals(class_2771.field_12679)) {
                    model.addProperty("model", modelString+"_top");
                } else {
                    model.addProperty("model", modelString);
                }

                if (directionValue.comp_71().equals(class_2350.field_11034)) {
                    model.addProperty("y", 90);
                } else if (directionValue.comp_71().equals(class_2350.field_11035)) {
                    model.addProperty("y", 180);
                } else if (directionValue.comp_71().equals(class_2350.field_11039)) {
                    model.addProperty("y", 270);
                }

                variants.add(directionValue+","+doubleState, model);
            });
        });

        JsonObject blockState = new JsonObject();
        blockState.add("variants", variants);
        write("blockstates/%s.json".formatted(shape.method_12832()), blockState);
    }
}

