package dev.tazer.clutternomore.common.mixin.pack;

import dev.tazer.clutternomore.ClutterNoMore;
import dev.tazer.clutternomore.Platform;
import dev.tazer.clutternomore.common.mixin.access.PackRepositoryAccessor;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_1065;
import net.minecraft.class_3264;
import net.minecraft.class_3283;
import net.minecraft.class_3285;
import net.minecraft.class_3288;

@Mixin(class_3283.class)
public class PackRepositoryMixin {
    @Inject(method = "<init>", at = @At("TAIL"))
    private void init(class_3285[] sources, CallbackInfo ci) {
        class_3288 pack;
        if (Platform.INSTANCE.isClient() && Arrays.stream(sources).toList().stream().anyMatch(source -> source instanceof class_1065))
            pack = ClutterNoMore.createPack(class_3264.field_14188);
        else pack = ClutterNoMore.createPack(class_3264.field_14190);
        Set<class_3285> newSources = new HashSet<>(((PackRepositoryAccessor) this).getSources());
        newSources.add(consumer -> consumer.accept(pack));
        ((PackRepositoryAccessor) this).setSources(newSources);
    }
}
