package dev.tazer.clutternomore.common.networking;

//? if neoforge || fabric {

import dev.tazer.clutternomore.ClutterNoMore;
import dev.tazer.clutternomore.common.shape_map.ShapeMap;
//? if fabric
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public record ShapeMapPayload(Map<class_1799, List<class_1799>> shapes, Map<class_1799, class_1799> inverseShapes) implements class_8710 {
    public static final class_9154<ShapeMapPayload> TYPE = new class_9154<>(class_2960.method_60655(ClutterNoMore.MODID, "shapes"));

    private static final class_9139<class_9129, Map<class_1799, List<class_1799>>> SHAPE_MAP_CODEC = class_9135.method_57992(
            HashMap::new, class_1799.field_48349, class_1799.field_49269, class_7923.field_41178.method_10204()
    );

    private static final class_9139<class_9129, Map<class_1799, class_1799>> INVERSE_SHAPE_MAP_CODEC = class_9135.method_57992(
            HashMap::new, class_1799.field_48349, class_1799.field_48349, class_7923.field_41178.method_10204()
    );

    public static final class_9139<class_9129, ShapeMapPayload> STREAM_CODEC = class_9139.method_56435(
            SHAPE_MAP_CODEC,
            ShapeMapPayload::shapes,
            INVERSE_SHAPE_MAP_CODEC,
            ShapeMapPayload::inverseShapes,
            ShapeMapPayload::new
    );

    @Override
    public class_9154<? extends class_8710> method_56479() {
        return TYPE;
    }

    public static void handleDataOnClient(final ShapeMapPayload data,
                                          //? if fabric
                                          ClientPlayNetworking.Context
                                          //? if neoforge
                                          /*IPayloadContext*/
                                          //? if forge
                                          /*Object*/
                                          context) {
        final Map<class_1792, List<class_1792>> SHAPES_DATAMAP = new HashMap<>();
        data.shapes.forEach(((item, items) -> {
            ArrayList<class_1792> objects = new ArrayList<>();
            items.forEach((stack -> objects.add(stack.method_7909())));
            SHAPES_DATAMAP.put(item.method_7909(), objects);
        }));
        final Map<class_1792, class_1792> INVERSE_SHAPES_DATAMAP = new HashMap<>();
        data.inverseShapes.forEach(((item, items) -> {
            INVERSE_SHAPES_DATAMAP.put(item.method_7909(), items.method_7909());
        }));
        ShapeMap.setShapeMaps(SHAPES_DATAMAP, INVERSE_SHAPES_DATAMAP);
    }
}

//?}