/*
 * Decompiled with CFR 0.152.
 */
package dev.tazer.clutternomore.common.data;

import com.google.gson.JsonElement;
import com.google.gson.Strictness;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonWriter;
import dev.tazer.clutternomore.ClutterNoMore;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_11555;
import net.minecraft.class_155;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3255;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3272;
import net.minecraft.class_6489;
import net.minecraft.class_6497;
import net.minecraft.class_7367;
import net.minecraft.class_7677;
import net.minecraft.class_9224;
import org.jetbrains.annotations.Nullable;

public class CNMPackResources
extends class_3255 {
    protected final Map<class_2960, byte[]> clientResources = new ConcurrentHashMap<class_2960, byte[]>();
    protected final Map<class_2960, byte[]> serverData = new ConcurrentHashMap<class_2960, byte[]>();
    protected final Map<String, byte[]> rootResources = new ConcurrentHashMap<String, byte[]>();
    protected final class_3272 clientMetadata = new class_3272((class_2561)class_2561.method_43470((String)"ClutterNoMore Runtime Client Resources"), resourcePackVersion);
    protected final class_3272 serverMetadata = new class_3272((class_2561)class_2561.method_43470((String)"ClutterNoMore Runtime Server Data"), dataPackVersion);
    private static final class_6489 currentVersion = class_155.method_16673();
    public static final class_6497<class_11555> resourcePackVersion = currentVersion.method_70592(class_3264.field_14188).method_72318();
    public static final class_6497<class_11555> dataPackVersion = currentVersion.method_70592(class_3264.field_14190).method_72318();

    public CNMPackResources(class_9224 info) {
        super(info);
    }

    public Set<String> method_14406(class_3264 packType) {
        return Set.of("clutternomore");
    }

    @Nullable
    public <T> T method_14407(class_7677<T> type) {
        return (T)(type == class_3272.field_61155 ? this.clientMetadata : (type == class_3272.field_61156 ? this.serverMetadata : null));
    }

    public void addResource(class_3264 packType, class_2960 id, byte[] bytes) {
        Map<class_2960, byte[]> resources = packType == class_3264.field_14188 ? this.clientResources : this.serverData;
        resources.put(id, bytes);
    }

    public void addJson(class_3264 packType, class_2960 path, JsonElement json) {
        try {
            this.addResource(packType, path, CNMPackResources.serializeJson(json).getBytes());
        }
        catch (IOException e) {
            ClutterNoMore.LOGGER.error("Failed to write JSON {} to resource pack.", (Object)path, (Object)e);
        }
    }

    @Nullable
    public class_7367<InputStream> method_14410(String ... strings) {
        byte[] resource = this.rootResources.get(String.join((CharSequence)"/", strings));
        return resource != null ? () -> new ByteArrayInputStream(resource) : null;
    }

    public class_7367<InputStream> method_14405(class_3264 packType, class_2960 id) {
        Map<class_2960, byte[]> resources = packType == class_3264.field_14188 ? this.clientResources : this.serverData;
        byte[] resource = resources.get(id);
        return resource != null ? () -> new ByteArrayInputStream(resource) : null;
    }

    public void method_14408(class_3264 packType, String namespace, String path, class_3262.class_7664 output) {
        Map<class_2960, byte[]> resources = packType == class_3264.field_14188 ? this.clientResources : this.serverData;
        for (class_2960 location : resources.keySet()) {
            if (!location.method_12832().startsWith(path)) continue;
            byte[] resource = resources.get(location);
            output.accept((Object)location, () -> new ByteArrayInputStream(resource));
        }
    }

    public void close() {
    }

    public static String serializeJson(JsonElement json) throws IOException {
        try {
            String string;
            try (StringWriter stringWriter = new StringWriter();
                 JsonWriter jsonWriter = new JsonWriter((Writer)stringWriter);){
                jsonWriter.setStrictness(Strictness.LENIENT);
                jsonWriter.setIndent("  ");
                Streams.write((JsonElement)json, (JsonWriter)jsonWriter);
                string = stringWriter.toString();
            }
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

