package dev.tazer.clutternomore.common.registry;

import dev.tazer.clutternomore.ClutterNoMore;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import net.minecraft.world.level.block.*;
import org.jetbrains.annotations.Nullable;

import java.util.*;

import static dev.tazer.clutternomore.ClutterNoMore.MODID;

public class BlockSetRegistry {

    public static ShapeSet getBlockTypeOf(class_1792 item) {
        return ShapeSetRegistry.items.get(item);
    }

    public static class ShapeSetRegistry {
        public static final Map<class_1792, ShapeSet> items = new LinkedHashMap<>();

        public static void register(class_1792 block, ShapeSet shapeSet) {
            items.put(block, shapeSet);
        }

        public static void detectTypeFromBlock(class_2248 block, class_2960 blockId) {
            if (block.method_8389() != class_1802.field_8162) {
                if (isParentBlock(blockId)) {
                    new ShapeSet(blockId, block);
                }
            }

        }

        private static boolean has(class_2960 block) {
            return class_7923.field_41175.method_10250(block);
        }

        private static boolean isParentBlock(class_2960 block) {
            List<String> namespaces = List.of(block.method_12836(), "minecraft");
            String path = block.method_12832();

            List<String> parentSuffixes = List.of("log", "planks", "block");
            List<String> ignoredSuffixes = List.of("block");
            Map<String, String> replacements = Map.of("log", "wood");
            List<String> prefixes = List.of("spiked");
            List<String> ignoredPrefixes = List.of("stripped");
            List<String> suffixes = List.of("stairs", "slab", "wall");

            for (String namespace : namespaces) {
                class_2960 base = ClutterNoMore.location(namespace, path);

                String suffixBase = path;
                for (String ignored : ignoredSuffixes) {
                    suffixBase = stripSuffix(suffixBase, ignored);
                }

                for (String parent : parentSuffixes) {
                    String suffixed = suffixBase + "_" + parent;
                    if (!suffixed.equals(path)) {
                        class_2960 candidate = base.method_45134(p -> suffixed);
                        if (has(candidate)) return false;
                    }
                }

                for (Map.Entry<String, String> replacement : replacements.entrySet()) {
                    String replaced = path.replace(replacement.getKey(), replacement.getValue());
                    if (!replaced.equals(path)) {
                        class_2960 candidate = base.method_45134(p -> replaced);
                        if (has(candidate)) return true;
                    }
                }

                String prefixBase = path;
                for (String ignored : ignoredPrefixes) {
                    prefixBase = stripPrefix(prefixBase, ignored);
                }

                for (String prefix : prefixes) {
                    String prefixed = prefix + "_" + prefixBase;
                    if (!prefixed.equals(path)) {
                        class_2960 candidate = base.method_45134(p -> prefixed);
                        if (has(candidate)) return true;
                    }
                }

                for (String parent : parentSuffixes) {
                    suffixBase = stripSuffix(suffixBase, parent);
                }

                for (String suffix : suffixes) {
                    if (suffixBase.endsWith("s")) {
                        String trimmed  = suffixBase.substring(0, suffixBase.length() - 1);
                        String suffixed = trimmed + "_" + suffix;
                        if (!suffixed.equals(path)) {
                            class_2960 candidate = base.method_45134(p -> suffixed);
                            if (has(candidate)) return true;
                        }
                    }

                    String suffixed = suffixBase + "_" + suffix;
                    if (!suffixed.equals(path)) {
                        class_2960 candidate = base.method_45134(p -> suffixed);
                        if (has(candidate)) return true;
                    }
                }
            }

            return false;
        }
    }

    public static class ShapeSet {
        private final class_2960 id;
        private final String type;
        private final class_2248 block;
        private final Map<String, class_1935> items = new LinkedHashMap<>();

        ShapeSet(class_2960 id, class_2248 block) {
            this.id = id;
            this.block = block;
            this.type = id.method_12832().replace("_block", "").replace("_planks", "");
            initializeChildrenBlocks();
            ShapeSetRegistry.register(block.method_8389(), this);

        }

        protected void initializeChildrenBlocks() {
            addChild("block", block);
            if (id.method_12832().contains("log")) {
                addChild("wood", getWood());
                if (id.method_12832().contains("stripped")) {
                    addChild("hollow_log",ClutterNoMore.location("wilderwild", id.method_12832().replace("stripped_", "stripped_hollowed_")));
                } else {
                    addChild("hollow_log", ClutterNoMore.location("wilderwild", "hollowed_"+ id.method_12832()));
                }
            }
            addChild("slab", findShape("slab"));
            addChild("stairs", findShape("stairs"));
            addChild("wall", findShape("wall"));
            addChild("vertical_slab", findShape(MODID,id.method_12836() + "/vertical", "slab"));
            addChild("vertical_slab", findShape(MODID,"vertical", "slab"));
            addChild("vertical_slab", findShape("vertical", "slab"));
            addChild("step", findShape(MODID, id.method_12836() + "/","step", false));
            addChild("step", findShape(MODID, "","step"));
            addChild("step", findShape("", "step"));
            addChild("spiked", findShape("spiked", ""));
        }

        private void addChild(String block, class_1935 block1) {
            if (block1 != null && !items.containsKey(block))
                items.put(block, block1);
        }

        private void addChild(String block, class_2960 id) {
            class_7923.field_41178.method_17966(id).ifPresent(block1 -> items.put(block, block1));
        }

        public String getVariantId(String prefix, String postfix) {
            String name = prefix + (prefix.isEmpty() ? "" : "_") + getTypeName();

            List<String> suffixes = List.of("_block", "_planks", "s");

            for (String suffix : suffixes) {
                if (name.endsWith(suffix)) {
                    name = name.substring(0, name.length() - suffix.length());
                    break;
                }
            }

            return name + (postfix.isEmpty() ? "" : "_") + postfix;
        }

        private String getTypeName() {
            return type;
        }

        protected @Nullable class_1792 findShape(String prefix, String postfix) {
            return findShape(id.method_12836(), prefix, postfix);
        }

        protected @Nullable class_1792 findShape(String namespace, String prefix, String postfix) {
            return findShape(namespace, prefix, postfix, true);
        }

            protected @Nullable class_1792 findShape(String namespace, String prefix, String postfix, boolean addUnderscore) {
            String basePath = id.method_12832();

            List<String> parentSuffixes = List.of("block", "planks");
            for (String parent : parentSuffixes) {
                basePath = stripSuffix(basePath, parent);
            }

            List<String> ignoredPrefixes = List.of("stripped");
            String reapplyPrefix = "";
            for (String ignored : ignoredPrefixes) {
                if (id.method_12832().startsWith(ignored + "_")) {
                    reapplyPrefix = ignored + "_";
                    basePath = stripPrefix(basePath, ignored);
                }
            }

            String prefixPart = prefix.isEmpty() ? "" : prefix + (addUnderscore ? "_" : "");
            String postfixPart = postfix.isEmpty() ? "" : "_" + postfix;

            List<String> candidates = new ArrayList<>();
            if (basePath.endsWith("s")) {
                candidates.add(basePath.substring(0, basePath.length() - 1));
            }
            candidates.add(basePath);

            for (String stem : candidates) {
                String candidatePath = reapplyPrefix + prefixPart + stem + postfixPart;
                class_2960 candidateId = ClutterNoMore.location(namespace, candidatePath);
                Optional<class_1792> found = class_7923.field_41178.method_17966(candidateId);
                if (found.isPresent()) return found.get();
            }

            return null;
        }

        protected @Nullable class_1792 findShape(String postfix) {
            return findShape("", postfix);
        }

        protected @Nullable class_1792 getWood() {
            String path = id.method_12832();
            if (path.endsWith("log")) {
                String stem = path.substring(0, path.length() - 3);
                class_2960 woodId = id.method_45134(p -> stem + "wood");
                return class_7923.field_41178.method_17966(woodId).orElse(null);
            }

            return null;
        }

        public class_2248 mainChild() {
            return block;
        }

        public Collection<class_1935> getChildren() {
            return items.values();
        }
    }

    private static String stripSuffix(String path, String suffix) {
        if (path.endsWith("_" + suffix)) return path.substring(0, path.length() - suffix.length() - 1);
        if (path.endsWith(suffix)) return path.substring(0, path.length() - suffix.length());
        return path;
    }

    private static String stripPrefix(String path, String prefix) {
        if (path.startsWith(prefix + "_")) return path.substring(prefix.length() + 1);
        if (path.startsWith(prefix)) return path.substring(prefix.length());
        return path;
    }
}