/*
 * Decompiled with CFR 0.152.
 */
package dev.tazer.clutternomore.common.data;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import dev.tazer.clutternomore.ClutterNoMore;
import java.nio.file.Path;
import net.minecraft.class_2960;
import net.minecraft.class_3264;

public class DataGenerator {
    public static JsonArray verticalSlabsArray = new JsonArray();
    public static JsonArray stepsArray = new JsonArray();
    public static JsonArray woodenVerticalSlabsArray = new JsonArray();
    public static JsonArray woodenStepsArray = new JsonArray();
    public static JsonArray pickaxeMineableArray = new JsonArray();
    public static JsonArray shovelMineableArray = new JsonArray();

    public static void addToTag(String path, JsonArray array) {
        DataGenerator.addToTag(ClutterNoMore.location(path), array);
    }

    public static void addToTag(class_2960 path, JsonArray array) {
        array.add(path.toString());
    }

    public static void generate() {
        DataGenerator.blockAndItemTag("vertical_slabs", verticalSlabsArray);
        DataGenerator.blockAndItemTag("wooden_vertical_slabs", woodenVerticalSlabsArray);
        DataGenerator.blockAndItemTag("steps", stepsArray);
        DataGenerator.blockAndItemTag("wooden_steps", woodenStepsArray);
        DataGenerator.blockAndItemTag("minecraft", "mineable/pickaxe", pickaxeMineableArray);
        DataGenerator.blockAndItemTag("minecraft", "mineable/shovel", shovelMineableArray);
    }

    private static void blockTag(String s, JsonArray verticalSlabTag) {
        DataGenerator.blockTag("clutternomore", s, verticalSlabTag);
    }

    private static void itemTag(String namespace, String s, JsonArray tagValues) {
        class_2960 location = ClutterNoMore.location(namespace, "tags/item/" + s + ".json");
        DataGenerator.writeServerData(location, (JsonElement)DataGenerator.generateTagFile(tagValues));
    }

    private static void blockTag(String namespace, String s, JsonArray tagValues) {
        class_2960 location = ClutterNoMore.location(namespace, "tags/block/" + s + ".json");
        DataGenerator.writeServerData(location, (JsonElement)DataGenerator.generateTagFile(tagValues));
    }

    private static void itemTag(String path, JsonArray verticalSlabTag) {
        DataGenerator.itemTag("clutternomore", path, verticalSlabTag);
    }

    private static void blockAndItemTag(String path, JsonArray verticalSlabTag) {
        DataGenerator.blockTag(path, verticalSlabTag);
        DataGenerator.itemTag(path, verticalSlabTag);
    }

    private static void blockAndItemTag(String namespace, String path, JsonArray verticalSlabTag) {
        DataGenerator.blockTag(namespace, path, verticalSlabTag);
        DataGenerator.itemTag(namespace, path, verticalSlabTag);
    }

    private static JsonObject generateTagFile(JsonArray tagValues) {
        JsonObject tag = new JsonObject();
        JsonArray values = new JsonArray();
        tagValues.forEach(value -> {
            JsonObject tagElement = new JsonObject();
            tagElement.add("id", value);
            tagElement.addProperty("required", Boolean.valueOf(false));
            values.add((JsonElement)tagElement);
        });
        tag.add("values", (JsonElement)values);
        return tag;
    }

    public static void addLootTable(class_2960 block, class_2960 shape) {
        JsonObject lootTable = new JsonObject();
        lootTable.add("type", (JsonElement)new JsonPrimitive("block"));
        JsonArray pools = new JsonArray();
        JsonObject pool = new JsonObject();
        pool.add("rolls", (JsonElement)new JsonPrimitive((Number)1));
        JsonArray entries = new JsonArray();
        JsonObject entry = new JsonObject();
        entry.add("type", (JsonElement)new JsonPrimitive("loot_table"));
        entry.add("value", (JsonElement)new JsonPrimitive(block.method_45138("blocks/").toString()));
        entries.add((JsonElement)entry);
        pool.add("entries", (JsonElement)entries);
        pools.add((JsonElement)pool);
        lootTable.add("pools", (JsonElement)pools);
        String path = "loot_table";
        DataGenerator.writeServerData("%s/blocks/%s.json".formatted(path, shape.method_12832()), (JsonElement)lootTable);
    }

    public static void writeServerData(class_2960 fileName, JsonElement contents) {
        ClutterNoMore.RESOURCES.addJson(class_3264.field_14190, fileName, contents);
        if (((Boolean)ClutterNoMore.STARTUP_CONFIG.RUNTIME_DATA_GENERATION.value()).booleanValue()) {
            Path data = ClutterNoMore.pack.resolve("data/clutternomore");
            ClutterNoMore.writeFile(data.resolve(fileName.method_12832().substring(0, fileName.method_12832().lastIndexOf("/"))), data.resolve(fileName.method_12832()), contents.toString());
        }
    }

    public static void writeServerData(String fileName, JsonElement contents) {
        DataGenerator.writeServerData(ClutterNoMore.location(fileName), contents);
    }
}

