/*
 * Decompiled with CFR 0.152.
 */
package dev.tazer.clutternomore;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import dev.tazer.clutternomore.CNMConfig;
import dev.tazer.clutternomore.Platform;
import dev.tazer.clutternomore.client.assets.AssetGenerator;
import dev.tazer.clutternomore.client.assets.StepGenerator;
import dev.tazer.clutternomore.client.assets.VerticalSlabGenerator;
import dev.tazer.clutternomore.common.blocks.StepBlock;
import dev.tazer.clutternomore.common.blocks.VerticalSlabBlock;
import dev.tazer.clutternomore.common.data.CNMPackResources;
import dev.tazer.clutternomore.common.mixin.access.BlockBehaviorAccessor;
import dev.tazer.clutternomore.common.registry.CBlocks;
import dev.tazer.clutternomore.common.shape_map.ShapeMap;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackSelectionConfig;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClutterNoMore {
    public static final String MODID = "clutternomore";
    public static final Logger LOGGER = LogManager.getLogger((String)"ClutterNoMore");
    public static final CNMConfig.StartupConfig STARTUP_CONFIG = (CNMConfig.StartupConfig)CNMConfig.StartupConfig.createToml((Path)Platform.INSTANCE.configPath(), (String)"clutternomore", (String)"startup", CNMConfig.StartupConfig.class);
    private static final PackLocationInfo PACK_INFO = new PackLocationInfo("clutternomore-runtime", (Component)Component.literal((String)"ClutterNoMore"), PackSource.BUILT_IN, Optional.empty());
    public static final CNMPackResources RESOURCES = new CNMPackResources(PACK_INFO);
    public static final ArrayList<ResourceLocation> ALIASES = new ArrayList();

    public static void init() {
        LOGGER.info("Initializing {} on {}", (Object)MODID, (Object)Platform.INSTANCE.loader());
    }

    public static Pack createPack(PackType type) {
        return Pack.readMetaAndCreate((PackLocationInfo)PACK_INFO, (Pack.ResourcesSupplier)new PackResourcesSupplier(), (PackType)type, (PackSelectionConfig)new PackSelectionConfig(true, Pack.Position.TOP, false));
    }

    public static ResourceLocation location(String path) {
        return ClutterNoMore.location(MODID, path);
    }

    public static ResourceLocation location(String namespace, String path) {
        return ResourceLocation.fromNamespaceAndPath((String)namespace, (String)path);
    }

    public static ResourceLocation parse(String id) {
        return ResourceLocation.parse((String)id);
    }

    public static void load(HolderLookup.Provider registries, RecipeManager recipeManager) {
        boolean changed = false;
        Collection originalRecipes = recipeManager.getRecipes();
        ArrayList<RecipeHolder> newRecipes = new ArrayList<RecipeHolder>();
        for (RecipeHolder recipeHolder : originalRecipes) {
            Recipe recipe = recipeHolder.value();
            Item result = recipe.getResultItem(registries).getItem();
            if (ShapeMap.isShape(result)) continue;
            NonNullList ingredients = recipe.getIngredients();
            for (Ingredient ingredient : new ArrayList(ingredients)) {
                ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
                for (ItemStack stack : ingredient.getItems()) {
                    Item item = stack.getItem();
                    if (ShapeMap.isShape(item)) {
                        ItemStack originalStack = ShapeMap.getParent(item).getDefaultInstance();
                        originalStack.setCount(stack.getCount());
                        stacks.add(originalStack);
                        changed = true;
                        continue;
                    }
                    stacks.add(stack);
                }
                Stream newStacks = stacks.stream();
                if (!changed) continue;
                try {
                    int index = ingredients.indexOf((Object)ingredient);
                    ingredients.set(index, (Object)Ingredient.of(newStacks));
                }
                catch (Exception exception) {}
            }
            RecipeHolder newHolder = new RecipeHolder(recipeHolder.id(), recipe);
            newRecipes.add(newHolder);
        }
        if (changed) {
            recipeManager.replaceRecipes(newRecipes);
        }
    }

    public static void registerVariants() {
        if (((Boolean)ClutterNoMore.STARTUP_CONFIG.VERTICAL_SLABS.value()).booleanValue() || ((Boolean)ClutterNoMore.STARTUP_CONFIG.STEPS.value()).booleanValue()) {
            LinkedHashMap<Object, Supplier> toRegister = new LinkedHashMap<Object, Supplier>();
            ArrayList<ResourceLocation> slabs = new ArrayList<ResourceLocation>();
            ArrayList<ResourceLocation> stairs = new ArrayList<ResourceLocation>();
            JsonArray verticalSlabsArray = new JsonArray();
            JsonArray stepsArray = new JsonArray();
            JsonArray woodenVerticalSlabsArray = new JsonArray();
            JsonArray woodenStepsArray = new JsonArray();
            JsonArray pickaxeMineableArray = new JsonArray();
            JsonArray shovelMineableArray = new JsonArray();
            List<SoundType> woodenSoundTypes = List.of(SoundType.WOOD, SoundType.BAMBOO_WOOD, SoundType.CHERRY_WOOD, SoundType.NETHER_WOOD);
            List<SoundType> shovelSoundTypes = List.of(SoundType.GRAVEL, SoundType.GRASS);
            for (Map.Entry resourceKeyItemEntry : BuiltInRegistries.ITEM.entrySet()) {
                StairBlock stairBlock;
                SoundType soundType;
                ResourceLocation shapeId;
                String path;
                Object shortPath;
                SlabBlock slabBlock;
                Block block;
                Item item = ((Item)resourceKeyItemEntry.getValue()).asItem();
                if (!(item instanceof BlockItem)) continue;
                BlockItem blockItem = (BlockItem)item;
                ResourceLocation blockId = ((ResourceKey)resourceKeyItemEntry.getKey()).location();
                Object blockNamespace = blockId.getNamespace() + "/";
                if (blockId.getNamespace().equals("minecraft")) {
                    blockNamespace = "";
                }
                if ((block = blockItem.getBlock()) instanceof SlabBlock && (slabBlock = (SlabBlock)block).defaultBlockState().getValues().size() == 2 && ((Boolean)ClutterNoMore.STARTUP_CONFIG.VERTICAL_SLABS.value()).booleanValue()) {
                    shortPath = "vertical_" + blockId.getPath();
                    path = (String)blockNamespace + (String)shortPath;
                    ClutterNoMore.addAlias((String)blockNamespace, (String)shortPath, path);
                    toRegister.put(path, () -> new VerticalSlabBlock(ClutterNoMore.copy((Block)slabBlock)));
                    slabs.add(blockId);
                    shapeId = ClutterNoMore.location(path);
                    ClutterNoMore.addLootTable(blockId, shapeId);
                    soundType = ((BlockBehaviorAccessor)slabBlock).getSoundType();
                    if (woodenSoundTypes.contains(soundType)) {
                        woodenVerticalSlabsArray.add(ClutterNoMore.location(path).toString());
                    } else {
                        verticalSlabsArray.add(ClutterNoMore.location(path).toString());
                        if (shovelSoundTypes.contains(soundType)) {
                            shovelMineableArray.add(ClutterNoMore.location(path).toString());
                        } else {
                            pickaxeMineableArray.add(ClutterNoMore.location(path).toString());
                        }
                    }
                }
                if (!((shortPath = blockItem.getBlock()) instanceof StairBlock) || (stairBlock = (StairBlock)shortPath).defaultBlockState().getValues().size() != 4 || !((Boolean)ClutterNoMore.STARTUP_CONFIG.STEPS.value()).booleanValue()) continue;
                shortPath = blockId.getPath().replace("stairs", "step");
                path = (String)blockNamespace + (String)shortPath;
                ClutterNoMore.addAlias((String)blockNamespace, (String)shortPath, path);
                toRegister.put(path, () -> new StepBlock(ClutterNoMore.copy((Block)stairBlock)));
                stairs.add(blockId);
                shapeId = ClutterNoMore.location(path);
                ClutterNoMore.addLootTable(blockId, shapeId);
                soundType = ((BlockBehaviorAccessor)stairBlock).getSoundType();
                if (woodenSoundTypes.contains(soundType)) {
                    woodenStepsArray.add(shapeId.toString());
                    continue;
                }
                stepsArray.add(shapeId.toString());
                if (shovelSoundTypes.contains(soundType)) {
                    shovelMineableArray.add(shapeId.toString());
                    continue;
                }
                pickaxeMineableArray.add(shapeId.toString());
            }
            toRegister.forEach(CBlocks::register);
            AssetGenerator.keys = toRegister.keySet();
            VerticalSlabGenerator.SLABS = slabs;
            StepGenerator.STAIRS = stairs;
            JsonObject verticalSlabTag = new JsonObject();
            verticalSlabTag.add("values", (JsonElement)verticalSlabsArray);
            ClutterNoMore.blockAndItemTag("vertical_slabs", (JsonElement)verticalSlabTag);
            JsonObject woodenVerticalSlabTag = new JsonObject();
            woodenVerticalSlabTag.add("values", (JsonElement)woodenVerticalSlabsArray);
            ClutterNoMore.blockAndItemTag("wooden_vertical_slabs", (JsonElement)woodenVerticalSlabTag);
            JsonObject stepTag = new JsonObject();
            stepTag.add("values", (JsonElement)stepsArray);
            ClutterNoMore.blockAndItemTag("steps", (JsonElement)stepTag);
            JsonObject woodenStepTag = new JsonObject();
            woodenStepTag.add("values", (JsonElement)woodenStepsArray);
            ClutterNoMore.blockAndItemTag("wooden_steps", (JsonElement)woodenStepTag);
            JsonObject pickaxeMineableTag = new JsonObject();
            pickaxeMineableTag.add("values", (JsonElement)pickaxeMineableArray);
            ClutterNoMore.blockAndItemTag("minecraft", "mineable/pickaxe", (JsonElement)pickaxeMineableTag);
            JsonObject shovelMineableTag = new JsonObject();
            shovelMineableTag.add("values", (JsonElement)shovelMineableArray);
            ClutterNoMore.blockAndItemTag("minecraft", "mineable/shovel", (JsonElement)shovelMineableTag);
        }
    }

    private static void blockTag(String s, JsonElement verticalSlabTag) {
        ClutterNoMore.blockTag(MODID, s, verticalSlabTag);
    }

    private static void itemTag(String namespace, String s, JsonElement verticalSlabTag) {
        ResourceLocation location = ClutterNoMore.location(namespace, "tags/item/" + s + ".json");
        RESOURCES.addJson(PackType.SERVER_DATA, location, verticalSlabTag);
    }

    private static void blockTag(String namespace, String s, JsonElement verticalSlabTag) {
        ResourceLocation location = ClutterNoMore.location(namespace, "tags/block/" + s + ".json");
        RESOURCES.addJson(PackType.SERVER_DATA, location, verticalSlabTag);
    }

    private static void itemTag(String path, JsonElement verticalSlabTag) {
        ClutterNoMore.itemTag(MODID, path, verticalSlabTag);
    }

    private static void blockAndItemTag(String path, JsonElement verticalSlabTag) {
        ClutterNoMore.blockTag(path, verticalSlabTag);
        ClutterNoMore.itemTag(path, verticalSlabTag);
    }

    private static void blockAndItemTag(String namespace, String path, JsonElement verticalSlabTag) {
        ClutterNoMore.blockTag(namespace, path, verticalSlabTag);
        ClutterNoMore.itemTag(namespace, path, verticalSlabTag);
    }

    private static void addAlias(String blockNamespace, String shortPath, String path) {
        ResourceLocation shortNamespace = ClutterNoMore.location(shortPath);
        if (!blockNamespace.isEmpty() && !ALIASES.contains(shortNamespace)) {
            ResourceLocation id = ClutterNoMore.location(path);
            BuiltInRegistries.BLOCK.addAlias(shortNamespace, id);
            BuiltInRegistries.ITEM.addAlias(shortNamespace, id);
            ALIASES.add(shortNamespace);
        }
    }

    public static void addLootTable(ResourceLocation block, ResourceLocation shape) {
        JsonObject lootTable = new JsonObject();
        lootTable.add("type", (JsonElement)new JsonPrimitive("block"));
        JsonArray pools = new JsonArray();
        JsonObject pool = new JsonObject();
        pool.add("rolls", (JsonElement)new JsonPrimitive((Number)1));
        JsonArray entries = new JsonArray();
        JsonObject entry = new JsonObject();
        entry.add("type", (JsonElement)new JsonPrimitive("loot_table"));
        entry.add("value", (JsonElement)new JsonPrimitive(block.withPrefix("blocks/").toString()));
        entries.add((JsonElement)entry);
        pool.add("entries", (JsonElement)entries);
        pools.add((JsonElement)pool);
        lootTable.add("pools", (JsonElement)pools);
        String path = "loot_table";
        RESOURCES.addJson(PackType.SERVER_DATA, ClutterNoMore.location("%s/blocks/%s.json".formatted(path, shape.getPath())), (JsonElement)lootTable);
    }

    public static BlockBehaviour.Properties copy(Block block) {
        return BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)block);
    }

    private static class PackResourcesSupplier
    implements Pack.ResourcesSupplier {
        private PackResourcesSupplier() {
        }

        public PackResources openPrimary(PackLocationInfo location) {
            return RESOURCES;
        }

        public PackResources openFull(PackLocationInfo location, Pack.Metadata metadata) {
            return RESOURCES;
        }
    }
}

