/*
 * Decompiled with CFR 0.152.
 */
package dev.tazer.clutternomore.common.data;

import com.google.gson.JsonElement;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonWriter;
import dev.tazer.clutternomore.ClutterNoMore;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.SharedConstants;
import net.minecraft.WorldVersion;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.AbstractPackResources;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.server.packs.resources.IoSupplier;
import org.jetbrains.annotations.Nullable;

public class CNMPackResources
extends AbstractPackResources {
    protected final Map<ResourceLocation, byte[]> clientResources = new ConcurrentHashMap<ResourceLocation, byte[]>();
    protected final Map<ResourceLocation, byte[]> serverData = new ConcurrentHashMap<ResourceLocation, byte[]>();
    protected final Map<String, byte[]> rootResources = new ConcurrentHashMap<String, byte[]>();
    protected final PackMetadataSection clientMetadata = new PackMetadataSection((Component)Component.literal((String)"ClutterNoMore Runtime Client Resources"), resourcePackVersion, Optional.empty());
    protected final PackMetadataSection serverMetadata = new PackMetadataSection((Component)Component.literal((String)"ClutterNoMore Runtime Server Data"), dataPackVersion, Optional.empty());
    private static final WorldVersion currentVersion = SharedConstants.getCurrentVersion();
    public static final int resourcePackVersion = currentVersion.getPackVersion(PackType.CLIENT_RESOURCES);
    public static final int dataPackVersion = currentVersion.getPackVersion(PackType.SERVER_DATA);

    public CNMPackResources(PackLocationInfo info) {
        super(info);
    }

    public Set<String> getNamespaces(PackType packType) {
        return Set.of("clutternomore");
    }

    @Nullable
    public <T> T getMetadataSection(MetadataSectionSerializer<T> deserializer) throws IOException {
        try {
            return (T)(deserializer == PackMetadataSection.TYPE ? this.clientMetadata : null);
        }
        catch (Exception var3) {
            return null;
        }
    }

    public void addResource(PackType packType, ResourceLocation id, byte[] bytes) {
        Map<ResourceLocation, byte[]> resources = packType == PackType.CLIENT_RESOURCES ? this.clientResources : this.serverData;
        resources.put(id, bytes);
    }

    public void addJson(PackType packType, ResourceLocation path, JsonElement json) {
        try {
            this.addResource(packType, path, CNMPackResources.serializeJson(json).getBytes());
        }
        catch (IOException e) {
            ClutterNoMore.LOGGER.error("Failed to write JSON {} to resource pack.", (Object)path, (Object)e);
        }
    }

    @Nullable
    public IoSupplier<InputStream> getRootResource(String ... strings) {
        byte[] resource = this.rootResources.get(String.join((CharSequence)"/", strings));
        return resource != null ? () -> new ByteArrayInputStream(resource) : null;
    }

    public IoSupplier<InputStream> getResource(PackType packType, ResourceLocation id) {
        Map<ResourceLocation, byte[]> resources = packType == PackType.CLIENT_RESOURCES ? this.clientResources : this.serverData;
        byte[] resource = resources.get(id);
        return resource != null ? () -> new ByteArrayInputStream(resource) : null;
    }

    public void listResources(PackType packType, String namespace, String path, PackResources.ResourceOutput output) {
        Map<ResourceLocation, byte[]> resources = packType == PackType.CLIENT_RESOURCES ? this.clientResources : this.serverData;
        for (ResourceLocation location : resources.keySet()) {
            if (!location.getPath().startsWith(path)) continue;
            byte[] resource = resources.get(location);
            output.accept((Object)location, () -> new ByteArrayInputStream(resource));
        }
    }

    public void close() {
    }

    public static String serializeJson(JsonElement json) throws IOException {
        try {
            String string;
            try (StringWriter stringWriter = new StringWriter();
                 JsonWriter jsonWriter = new JsonWriter((Writer)stringWriter);){
                jsonWriter.setLenient(true);
                jsonWriter.setIndent("  ");
                Streams.write((JsonElement)json, (JsonWriter)jsonWriter);
                string = stringWriter.toString();
            }
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

