/*
 * Decompiled with CFR 0.152.
 */
package dev.tazer.clutternomore.common.mixin;

import com.llamalad7.mixinextras.sugar.Local;
import dev.tazer.clutternomore.common.blocks.VerticalSlabBlock;
import dev.tazer.clutternomore.common.shape_map.ShapeMap;
import java.util.Optional;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={BlockItem.class})
public class BlockItemMixin {
    @Redirect(method={"place"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;consume(ILnet/minecraft/world/entity/LivingEntity;)V"))
    private void place(ItemStack instance, int amount, LivingEntity entity, @Local(argsOnly=true) BlockPlaceContext context, @Local(ordinal=0) BlockState blockstate) {
        boolean consume = true;
        if (ShapeMap.isShape(instance.getItem())) {
            Optional slabType = blockstate.getOptionalValue((Property)SlabBlock.TYPE);
            Optional isDouble = blockstate.getOptionalValue((Property)VerticalSlabBlock.DOUBLE);
            if (slabType.isPresent()) {
                boolean bl = consume = slabType.get() != SlabType.DOUBLE;
            }
            if (isDouble.isPresent()) {
                boolean bl = consume = (Boolean)isDouble.get() == false;
            }
        }
        if (consume) {
            instance.consume(amount, entity);
        }
    }
}

