/*
 * Decompiled with CFR 0.152.
 */
package dev.tazer.clutternomore.common.shape_map;

import dev.tazer.clutternomore.common.networking.ShapeMapPayload;
import dev.tazer.clutternomore.common.registry.BlockSetRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.network.PacketDistributor;

public class ShapeMap {
    private static final Map<Item, List<Item>> SHAPES_DATAMAP = new HashMap<Item, List<Item>>();
    private static final Map<Item, Item> INVERSE_SHAPES_DATAMAP = new HashMap<Item, Item>();

    public static void setShapeMaps(Map<Item, List<Item>> newShapeMap, Map<Item, Item> newInverseShapeMap) {
        SHAPES_DATAMAP.clear();
        SHAPES_DATAMAP.putAll(newShapeMap);
        INVERSE_SHAPES_DATAMAP.clear();
        INVERSE_SHAPES_DATAMAP.putAll(newInverseShapeMap);
    }

    public static boolean hasShapes(Item item) {
        return SHAPES_DATAMAP.containsKey(item);
    }

    public static boolean isShape(Item item) {
        return INVERSE_SHAPES_DATAMAP.containsKey(item);
    }

    public static boolean contains(Item item) {
        return ShapeMap.hasShapes(item) || ShapeMap.isShape(item);
    }

    public static Item getParent(Item item) {
        return INVERSE_SHAPES_DATAMAP.getOrDefault(item, item);
    }

    public static boolean isParentOfShape(Item parent, Item shape) {
        return ShapeMap.getParent(shape) == parent;
    }

    public static boolean inSameShapeSet(Item item, Item other) {
        if (ShapeMap.isShape(item) || ShapeMap.isShape(other)) {
            return ShapeMap.getParent(item) == ShapeMap.getParent(other);
        }
        return false;
    }

    public static List<Item> getShapes(Item item) {
        return SHAPES_DATAMAP.getOrDefault(ShapeMap.getParent(item), List.of());
    }

    public static void set(Map<ResourceLocation, List<ResourceLocation>> idMap) {
        SHAPES_DATAMAP.clear();
        INVERSE_SHAPES_DATAMAP.clear();
        for (Map.Entry<ResourceLocation, List<ResourceLocation>> entry : idMap.entrySet()) {
            ResourceLocation key2 = entry.getKey();
            Item newKey = BuiltInRegistries.ITEM.getOptional(key2).orElse(null);
            if (newKey == null) continue;
            List<ResourceLocation> value = entry.getValue();
            ArrayList arrayList = new ArrayList();
            for (ResourceLocation location : value) {
                BuiltInRegistries.ITEM.getOptional(location).map(arrayList::add);
            }
            if (arrayList.isEmpty()) continue;
            SHAPES_DATAMAP.put(newKey, arrayList);
        }
        BuiltInRegistries.ITEM.entrySet().forEach(key -> {
            ResourceLocation id = ((ResourceKey)key.getKey()).location();
            Item item = (Item)key.getValue();
            if (item instanceof BlockItem) {
                BlockItem blockItem = (BlockItem)item;
                Block block = blockItem.getBlock();
                BlockSetRegistry.ShapeSetRegistry.detectTypeFromBlock(block, id);
            }
        });
        for (Item item : BuiltInRegistries.ITEM.stream().toList()) {
            Item mainChild;
            ArrayList<Item> shapes = new ArrayList<Item>(ShapeMap.getShapes(item));
            BlockSetRegistry.ShapeSet shapeSet = BlockSetRegistry.getBlockTypeOf(item);
            if (shapeSet != null && item == (mainChild = shapeSet.mainChild().asItem())) {
                shapeSet.getChildren().forEach(child -> {
                    if (child != mainChild && child instanceof Item) {
                        Item shape = (Item)child;
                        shapes.add(shape);
                    }
                });
            }
            if (shapes.isEmpty()) continue;
            SHAPES_DATAMAP.put(item, shapes);
        }
        for (Map.Entry<Object, List<Object>> entry : new HashSet<Map.Entry<Item, List<Item>>>(SHAPES_DATAMAP.entrySet())) {
            Item item = (Item)entry.getKey();
            List<Object> shapes = entry.getValue();
            for (Item item2 : shapes) {
                INVERSE_SHAPES_DATAMAP.put(item2, item);
            }
        }
        for (Map.Entry<Object, List<Object>> entry : new HashSet<Map.Entry<Item, Item>>(INVERSE_SHAPES_DATAMAP.entrySet())) {
            if (ShapeMap.hasShapes((Item)entry.getValue())) continue;
            INVERSE_SHAPES_DATAMAP.remove(entry.getKey());
        }
    }

    public static void sendShapeMap(ServerPlayer serverPlayer) {
        HashMap<ItemStack, List<ItemStack>> shapes = new HashMap<ItemStack, List<ItemStack>>();
        SHAPES_DATAMAP.forEach((item, items) -> {
            ArrayList objects = new ArrayList();
            items.forEach(stack -> objects.add(stack.getDefaultInstance()));
            shapes.put(item.getDefaultInstance(), objects);
        });
        HashMap<ItemStack, ItemStack> inverseShapes = new HashMap<ItemStack, ItemStack>();
        INVERSE_SHAPES_DATAMAP.forEach((item, items) -> inverseShapes.put(item.getDefaultInstance(), items.getDefaultInstance()));
        PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new ShapeMapPayload(shapes, inverseShapes), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

