package dev.tazer.clutternomore.common.data;

import com.google.gson.JsonElement;
//? if >1.21.9 {
import com.google.gson.Strictness;
//?}
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonWriter;
import dev.tazer.clutternomore.ClutterNoMore;
import net.minecraft.class_11555;
import net.minecraft.class_155;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3255;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3272;
import net.minecraft.class_6489;
import net.minecraft.class_6497;
import net.minecraft.class_7367;
import net.minecraft.class_7677;
import net.minecraft.class_9224;
import net.minecraft.server.packs.*;
import org.jetbrains.annotations.Nullable;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.*;
import java.util.concurrent.ConcurrentHashMap;

public class CNMPackResources extends class_3255 {
    protected final Map<class_2960, byte[]> clientResources;
    protected final Map<class_2960, byte[]> serverData;
    protected final Map<String, byte[]> rootResources;
    protected final class_3272 clientMetadata;
    protected final class_3272 serverMetadata;

    private static final class_6489 currentVersion = class_155.method_16673();

    //? if >1.21.9 {
    public static final class_6497<class_11555> resourcePackVersion = currentVersion.method_70592(class_3264.field_14188).method_72318();
    public static final class_6497<class_11555> dataPackVersion = currentVersion.method_70592(class_3264.field_14190).method_72318();
    //?} else if >1.21.5 {
    /*public static final int resourcePackVersion = currentVersion.packVersion(PackType.CLIENT_RESOURCES);
    public static final int dataPackVersion = currentVersion.packVersion(PackType.SERVER_DATA);
    *///?} else {
    /*public static final int resourcePackVersion = currentVersion.getPackVersion(PackType.CLIENT_RESOURCES);
    public static final int dataPackVersion = currentVersion.getPackVersion(PackType.SERVER_DATA);
    *///?}

    public CNMPackResources(
            //? if >1.21 {
            class_9224
            //?} else {
            /*String
            *///?}
             info
    ) {
        super(info
        //? if <1.21 {
            /*, true
        *///?}
        );
        this.clientResources = new ConcurrentHashMap<>();
        this.serverData = new ConcurrentHashMap<>();
        this.rootResources = new ConcurrentHashMap<>();
        this.clientMetadata = new class_3272(class_2561.method_43470("ClutterNoMore Runtime Client Resources"), resourcePackVersion
                //? if >1.21 && <1.21.9
                /*, Optional.empty()*/
        );
        this.serverMetadata = new class_3272(class_2561.method_43470("ClutterNoMore Runtime Server Data"), dataPackVersion
                //? if >1.21 && <1.21.9
                /*, Optional.empty()*/
        );
    }

    @Override
    public Set<String> method_14406(class_3264 packType) {
        return Set.of(ClutterNoMore.MODID);
    }

    //? if >1.21.9 {
    @Override
    public @Nullable <T> T method_14407(class_7677<T> type) {
        return type == class_3272.field_61155 ? (T) clientMetadata : type == class_3272.field_61156 ? (T) serverMetadata : null;
    }
    //?} else if >1.21.1 {
    
    /*@Override
    public @Nullable <T> T getMetadataSection(MetadataSectionType<T> type) throws IOException {
        try {
            return (T) (type == PackMetadataSection.TYPE ? clientMetadata : null);
        } catch (Exception var3) {
            return null;
        }
    }

    *///?} else {
    /*@Nullable
    public <T> T getMetadataSection(MetadataSectionSerializer<T> deserializer) throws IOException {
        try {
            return (T) (deserializer == PackMetadataSection.TYPE ? clientMetadata : null);
        } catch (Exception var3) {
            return null;
        }
    }
    *///?}

    public void addResource(class_3264 packType, class_2960 id, byte[] bytes) {
        Map<class_2960, byte[]> resources = packType == class_3264.field_14188 ? clientResources : serverData;
        resources.put(id, bytes);
    }

    public void addJson(class_3264 packType, class_2960 path, JsonElement json) {
        try {
            addResource(packType, path, serializeJson(json).getBytes());
        } catch (IOException e) {
            ClutterNoMore.LOGGER.error("Failed to write JSON {} to resource pack.", path, e);
        }
    }

    public @Nullable class_7367<InputStream> method_14410(String... strings) {
        byte[] resource = rootResources.get(String.join("/", strings));
        return resource != null ? () -> new ByteArrayInputStream(resource) : null;    }

    @Override
    public class_7367<InputStream> method_14405(class_3264 packType, class_2960 id) {
        Map<class_2960, byte[]> resources = packType == class_3264.field_14188 ? clientResources : serverData;
        byte[] resource = resources.get(id);
        return resource != null ? () -> new ByteArrayInputStream(resource) : null;
    }

    @Override
    public void method_14408(class_3264 packType, String namespace, String path, class_3262.class_7664 output) {
        Map<class_2960, byte[]> resources = packType == class_3264.field_14188 ? clientResources : serverData;
        for (class_2960 location : resources.keySet()) {
            if (location.method_12832().startsWith(path)) {
                byte[] resource = resources.get(location);
                output.accept(location, () -> new ByteArrayInputStream(resource));
            }
        }
    }

    @Override
    public void close() {
    }

    public static String serializeJson(JsonElement json) throws IOException {
        try {
            String string;
            try (StringWriter stringWriter = new StringWriter(); JsonWriter jsonWriter = new JsonWriter(stringWriter)) {
                //? if >1.21.9 {
                jsonWriter.setStrictness(Strictness.LENIENT);
                //?} else {
                /*jsonWriter.setLenient(true);
                 *///?}
                jsonWriter.setIndent("  ");
                Streams.write(json, jsonWriter);
                string = stringWriter.toString();
            }

            return string;
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}