/*
 * Decompiled with CFR 0.152.
 */
package dev.tazer.clutternomore.client.assets;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.tazer.clutternomore.ClutterNoMore;
import dev.tazer.clutternomore.client.assets.AssetGenerator;
import dev.tazer.clutternomore.common.blocks.VerticalSlabBlock;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.class_2350;
import net.minecraft.class_2960;
import net.minecraft.class_3300;

public final class VerticalSlabGenerator {
    public static ArrayList<class_2960> SLABS = new ArrayList();

    public static void generate(class_3300 manager) {
        for (class_2960 parent : SLABS) {
            Object namespace = parent.method_12836() + "/";
            if (parent.method_12836().equals("minecraft")) {
                namespace = "";
            }
            class_2960 shape = ClutterNoMore.location((String)namespace + "vertical_" + parent.method_12832());
            try {
                VerticalSlabGenerator.generateBlock(parent, shape, manager);
                AssetGenerator.generateItem(shape, manager);
            }
            catch (IOException e) {
                ClutterNoMore.LOGGER.catching((Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }

    public static void generateBlock(class_2960 parent, class_2960 shape, class_3300 manager) throws IOException {
        Optional existingBlockState = manager.method_14486(shape.method_45138("blockstates/").method_48331(".json"));
        if (existingBlockState.isPresent()) {
            return;
        }
        JsonObject textures = AssetGenerator.getTextures(manager, parent);
        if (textures == null) {
            return;
        }
        JsonObject blockModel = new JsonObject();
        blockModel.addProperty("parent", "clutternomore:block/templates/vertical_slab");
        blockModel.add("textures", (JsonElement)textures);
        AssetGenerator.write("models/block/%s.json".formatted(shape.method_12832()), (JsonElement)blockModel);
        blockModel.addProperty("parent", "clutternomore:block/templates/vertical_slab_double");
        AssetGenerator.write("models/block/%s_double.json".formatted(shape.method_12832()), (JsonElement)blockModel);
        JsonObject variants = new JsonObject();
        VerticalSlabBlock.FACING.method_30043().forEach(directionValue -> VerticalSlabBlock.DOUBLE.method_30043().forEach(doubleState -> {
            JsonObject model = new JsonObject();
            Object modelString = "clutternomore:block/" + shape.method_12832();
            modelString = ((String)modelString).replace("waxed_", "");
            if (((Boolean)doubleState.comp_71()).booleanValue()) {
                model.addProperty("model", (String)modelString + "_double");
            } else {
                model.addProperty("model", (String)modelString);
            }
            if (((class_2350)directionValue.comp_71()).equals((Object)class_2350.field_11034)) {
                model.addProperty("y", (Number)90);
            } else if (((class_2350)directionValue.comp_71()).equals((Object)class_2350.field_11035)) {
                model.addProperty("y", (Number)180);
            } else if (((class_2350)directionValue.comp_71()).equals((Object)class_2350.field_11039)) {
                model.addProperty("y", (Number)270);
            }
            variants.add(String.valueOf(directionValue) + "," + String.valueOf(doubleState), (JsonElement)model);
        }));
        JsonObject blockState = new JsonObject();
        blockState.add("variants", (JsonElement)variants);
        AssetGenerator.write("blockstates/%s.json".formatted(shape.method_12832()), (JsonElement)blockState);
    }
}

