/*
 * Decompiled with CFR 0.152.
 */
package dev.tazer.clutternomore;

import dev.tazer.clutternomore.CNMConfig;
import dev.tazer.clutternomore.Platform;
import dev.tazer.clutternomore.client.ShapeSwitcherOverlay;
import dev.tazer.clutternomore.client.assets.AssetGenerator;
import dev.tazer.clutternomore.common.mixin.access.SlotAccessor;
import dev.tazer.clutternomore.common.mixin.screen.ContainerScreenAccessor;
import dev.tazer.clutternomore.common.shape_map.ShapeMap;
import dev.tazer.clutternomore.forge.networking.ChangeStackPacket;
import dev.tazer.clutternomore.forge.networking.ForgeNetworking;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;

public class ClutterNoMoreClient {
    public static boolean showTooltip = false;
    public static ShapeSwitcherOverlay OVERLAY = null;
    public static final CNMConfig.ClientConfig CLIENT_CONFIG = (CNMConfig.ClientConfig)CNMConfig.ClientConfig.createToml((Path)Platform.INSTANCE.configPath(), (String)"clutternomore", (String)"client", CNMConfig.ClientConfig.class);
    public static boolean requireReload = false;

    public static void init() {
    }

    public static void clientStarted(Minecraft client) {
        AssetGenerator.generate();
        ClutterNoMoreClient.enablePack(client);
    }

    public static void onItemTooltips(ItemStack stack, Object tooltipContext, TooltipFlag tooltipFlag, List<Component> tooltip) {
        if (!showTooltip && ShapeMap.contains(stack.m_41720_())) {
            MutableComponent component = tooltip.get(0).m_6881_().m_7220_((Component)Component.m_237113_((String)" [+]").m_130940_(ChatFormatting.DARK_GRAY));
            tooltip.remove(0);
            tooltip.add(0, (Component)component);
        }
    }

    public static void onKeyInput(int keyCode, int action) {
        if (keyCode == ClutterNoMoreClient.shapeKey()) {
            ItemStack heldStack;
            LocalPlayer player;
            Minecraft minecraft = Minecraft.m_91087_();
            if (minecraft.f_91080_ == null && (player = minecraft.f_91074_) != null && ShapeMap.contains((heldStack = player.m_21120_(InteractionHand.MAIN_HAND)).m_41720_())) {
                switch ((CNMConfig.InputType)((Object)ClutterNoMoreClient.CLIENT_CONFIG.HOLD.value())) {
                    case HOLD: {
                        if (OVERLAY == null && action == 1) {
                            OVERLAY = new ShapeSwitcherOverlay(minecraft, heldStack, true);
                            break;
                        }
                        if (action != 0) break;
                        OVERLAY = null;
                        break;
                    }
                    case TOGGLE: {
                        if (action != 1) break;
                        if (OVERLAY == null) {
                            OVERLAY = new ShapeSwitcherOverlay(minecraft, heldStack, true);
                            break;
                        }
                        OVERLAY = null;
                        break;
                    }
                    case PRESS: {
                        if (action != 1) break;
                        if (OVERLAY == null) {
                            OVERLAY = new ShapeSwitcherOverlay(minecraft, heldStack, false);
                        }
                        OVERLAY.onMouseScrolled(-1);
                        OVERLAY = null;
                    }
                }
            }
        }
    }

    public static void onKeyPress(Screen screen, int button) {
        if (button == ClutterNoMoreClient.shapeKey() && screen instanceof AbstractContainerScreen) {
            AbstractContainerScreen containerScreen = (AbstractContainerScreen)screen;
            Slot slot = ((ContainerScreenAccessor)screen).getSlotUnderMouse();
            if (slot != null) {
                ItemStack heldStack = slot.m_7993_();
                LocalPlayer player = Minecraft.m_91087_().f_91074_;
                if (slot.m_150651_((Player)player) && ShapeMap.contains(heldStack.m_41720_())) {
                    switch ((CNMConfig.InputType)((Object)ClutterNoMoreClient.CLIENT_CONFIG.HOLD.value())) {
                        case HOLD: {
                            showTooltip = true;
                            break;
                        }
                        case TOGGLE: {
                            showTooltip = !showTooltip;
                            break;
                        }
                        case PRESS: {
                            ClutterNoMoreClient.switchShapeInSlot((Player)player, containerScreen.m_6262_().f_38840_, ((SlotAccessor)slot).getSlotIndex(), heldStack, -1);
                        }
                    }
                }
            }
        }
    }

    public static boolean onKeyReleased(int button) {
        if (button == ClutterNoMoreClient.shapeKey() && ClutterNoMoreClient.CLIENT_CONFIG.HOLD.value() == CNMConfig.InputType.HOLD) {
            showTooltip = false;
        }
        return false;
    }

    public static void switchShapeInSlot(Player player, int containerId, int slotId, ItemStack heldStack, int direction) {
        Item item = ShapeMap.getParent(heldStack.m_41720_());
        int count = heldStack.m_41613_();
        ArrayList<Item> shapes = new ArrayList<Item>(ShapeMap.getShapes(item));
        shapes.add(0, item);
        int selectedIndex = shapes.indexOf(heldStack.m_41720_());
        int maxIndex = shapes.size() - 1;
        if ((selectedIndex -= direction) < 0) {
            selectedIndex = maxIndex;
        }
        if (selectedIndex > maxIndex) {
            selectedIndex = 0;
        }
        Item nextItem = (Item)shapes.get(selectedIndex);
        ItemStack next = nextItem.m_7968_();
        next.m_41764_(count);
        player.m_5496_((SoundEvent)SoundEvents.f_12490_.m_203334_(), 0.3f, 1.5f);
        if (slotId < 9) {
            slotId += 36;
        }
        ChangeStackPacket p = new ChangeStackPacket(containerId, slotId, next);
        ForgeNetworking.sendToServer(p);
    }

    public static int shapeKey() {
        return Platform.INSTANCE.shapeKey();
    }

    public static void onPlayerTick(Minecraft minecraft) {
        if (OVERLAY != null && !OVERLAY.shouldStayOpenThisTick()) {
            OVERLAY = null;
        }
    }

    public static boolean allowScreenScroll(Screen pScreen, double mouseX, double mouseY, double scrollX, double scrollY) {
        if (showTooltip && pScreen instanceof AbstractContainerScreen) {
            ItemStack heldStack;
            AbstractContainerScreen screen = (AbstractContainerScreen)pScreen;
            Slot slot = ((ContainerScreenAccessor)screen).getSlotUnderMouse();
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (slot != null && slot.m_150651_((Player)player) && ShapeMap.contains((heldStack = slot.m_7993_()).m_41720_())) {
                ClutterNoMoreClient.switchShapeInSlot((Player)player, screen.m_6262_().f_38840_, ((SlotAccessor)slot).getSlotIndex(), heldStack, (int)scrollY);
                return false;
            }
        }
        return true;
    }

    public static boolean onMouseScrolling(double yOffset) {
        int direction = (int)yOffset;
        if (OVERLAY != null) {
            OVERLAY.onMouseScrolled(direction);
            return true;
        }
        return false;
    }

    private static void enablePack(Minecraft client) {
        PackRepository repository = client.m_91099_();
        Path packPath = client.m_245161_().resolve("clutternomore");
        String packId = "file/" + packPath.getFileName().toString();
        if ((requireReload || !repository.m_10523_().contains(packId)) && repository.m_10507_(packId) != null) {
            repository.m_275855_(packId);
            client.m_91391_();
        }
    }
}

