/*
 * Decompiled with CFR 0.152.
 */
package dev.tazer.clutternomore.common.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class StepBlock
extends HorizontalDirectionalBlock
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final EnumProperty<SlabType> SLAB_TYPE = BlockStateProperties.f_61397_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;

    public StepBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(SLAB_TYPE, (Comparable)SlabType.BOTTOM)).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{SLAB_TYPE}).m_61104_(new Property[]{FACING}).m_61104_(new Property[]{WATERLOGGED});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos pos = context.m_8083_();
        Vec3 exactPos = context.m_43720_();
        Direction direction = context.m_8125_();
        BlockState replacingBlockState = context.m_43725_().m_8055_(pos);
        FluidState replacingFluidState = context.m_43725_().m_6425_(pos);
        if (replacingBlockState.m_60713_((Block)this)) {
            if (replacingBlockState.m_61143_(SLAB_TYPE) == SlabType.BOTTOM) {
                replacingBlockState = (BlockState)replacingBlockState.m_61124_((Property)FACING, (Comparable)((Direction)replacingBlockState.m_61143_((Property)FACING)).m_122424_());
            }
            return (BlockState)replacingBlockState.m_61124_(SLAB_TYPE, (Comparable)SlabType.DOUBLE);
        }
        BlockState stateForPlacement = (BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(replacingFluidState.m_76152_() == Fluids.f_76193_));
        switch (direction) {
            case NORTH: {
                if (!(exactPos.f_82481_ - (double)pos.m_123343_() > 0.5)) break;
                direction = direction.m_122424_();
                break;
            }
            case SOUTH: {
                if (!(exactPos.f_82481_ - (double)pos.m_123343_() < 0.5)) break;
                direction = direction.m_122424_();
                break;
            }
            case EAST: {
                if (!(exactPos.f_82479_ - (double)pos.m_123341_() < 0.5)) break;
                direction = direction.m_122424_();
                break;
            }
            case WEST: {
                if (!(exactPos.f_82479_ - (double)pos.m_123341_() > 0.5)) break;
                direction = direction.m_122424_();
            }
        }
        if (exactPos.f_82480_ - (double)pos.m_123342_() > 0.5) {
            stateForPlacement = (BlockState)stateForPlacement.m_61124_(SLAB_TYPE, (Comparable)SlabType.TOP);
        }
        return (BlockState)stateForPlacement.m_61124_((Property)FACING, (Comparable)direction);
    }

    public boolean m_6864_(BlockState state, BlockPlaceContext context) {
        ItemStack itemStack = context.m_43722_();
        if (state.m_61143_(SLAB_TYPE) == SlabType.DOUBLE || !itemStack.m_150930_(this.m_5456_())) {
            return false;
        }
        if (!context.m_7058_()) {
            return true;
        }
        Direction direction = context.m_43719_();
        return direction == (state.m_61143_(SLAB_TYPE) == SlabType.BOTTOM ? Direction.UP : Direction.DOWN) || direction == ((Direction)state.m_61143_((Property)FACING)).m_122424_();
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        if (state.m_61143_(SLAB_TYPE) == SlabType.DOUBLE) {
            return Shapes.m_83110_((VoxelShape)StepBlock.createShape(direction, 0.5), (VoxelShape)StepBlock.createShape(direction.m_122424_(), 0.0));
        }
        double y = state.m_61143_(SLAB_TYPE) == SlabType.TOP ? 0.5 : 0.0;
        return StepBlock.createShape(direction, y);
    }

    public static VoxelShape createShape(Direction direction, double y) {
        return switch (direction) {
            case Direction.NORTH -> Shapes.m_166049_((double)0.0, (double)y, (double)0.0, (double)1.0, (double)(y + 0.5), (double)0.5);
            case Direction.EAST -> Shapes.m_166049_((double)0.5, (double)y, (double)0.0, (double)1.0, (double)(y + 0.5), (double)1.0);
            case Direction.SOUTH -> Shapes.m_166049_((double)0.0, (double)y, (double)0.5, (double)1.0, (double)(y + 0.5), (double)1.0);
            case Direction.WEST -> Shapes.m_166049_((double)0.0, (double)y, (double)0.0, (double)0.5, (double)(y + 0.5), (double)1.0);
            default -> Shapes.m_83144_();
        };
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return super.m_7417_(state, direction, neighborState, level, pos, neighborPos);
    }

    public boolean m_7923_(BlockState state) {
        return true;
    }

    public FluidState m_5888_(BlockState state) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            return Fluids.f_76193_.m_76068_(false);
        }
        return state.m_60819_();
    }
}

