/*
 * Decompiled with CFR 0.152.
 */
package dev.tazer.clutternomore.common.registry;

import dev.tazer.clutternomore.ClutterNoMore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public class BlockSetRegistry {
    public static ShapeSet getBlockTypeOf(Item item) {
        return ShapeSetRegistry.items.get(item);
    }

    private static String stripSuffix(String path, String suffix) {
        if (path.endsWith("_" + suffix)) {
            return path.substring(0, path.length() - suffix.length() - 1);
        }
        if (path.endsWith(suffix)) {
            return path.substring(0, path.length() - suffix.length());
        }
        return path;
    }

    private static String stripPrefix(String path, String prefix) {
        if (path.startsWith(prefix + "_")) {
            return path.substring(prefix.length() + 1);
        }
        if (path.startsWith(prefix)) {
            return path.substring(prefix.length());
        }
        return path;
    }

    public static class ShapeSetRegistry {
        public static final Map<Item, ShapeSet> items = new LinkedHashMap<Item, ShapeSet>();

        public static void register(Item block, ShapeSet shapeSet) {
            items.put(block, shapeSet);
        }

        public static void detectTypeFromBlock(Block block, ResourceLocation blockId) {
            if (block.m_5456_() != Items.f_41852_ && ShapeSetRegistry.isParentBlock(blockId)) {
                new ShapeSet(blockId, block);
            }
        }

        private static boolean has(ResourceLocation block) {
            return BuiltInRegistries.f_256975_.m_7804_(block);
        }

        private static boolean isParentBlock(ResourceLocation block) {
            List<String> namespaces = List.of(block.m_135827_(), "minecraft");
            String path = block.m_135815_();
            List<String> parentSuffixes = List.of("log", "planks", "block");
            List<String> ignoredSuffixes = List.of("block");
            Map<String, String> replacements = Map.of("log", "wood");
            List<String> prefixes = List.of("spiked");
            List<String> ignoredPrefixes = List.of("stripped");
            List<String> suffixes = List.of("stairs", "slab", "wall");
            for (String namespace : namespaces) {
                ResourceLocation candidate;
                ResourceLocation base = ClutterNoMore.location(namespace, path);
                String suffixBase = path;
                for (String string : ignoredSuffixes) {
                    suffixBase = BlockSetRegistry.stripSuffix(suffixBase, string);
                }
                for (String string : parentSuffixes) {
                    ResourceLocation candidate2;
                    String suffixed = suffixBase + "_" + string;
                    if (suffixed.equals(path) || !ShapeSetRegistry.has(candidate2 = base.m_247266_(p -> suffixed))) continue;
                    return false;
                }
                for (Map.Entry entry : replacements.entrySet()) {
                    ResourceLocation candidate2;
                    String replaced = path.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
                    if (replaced.equals(path) || !ShapeSetRegistry.has(candidate2 = base.m_247266_(p -> replaced))) continue;
                    return true;
                }
                String prefixBase = path;
                for (String ignored : ignoredPrefixes) {
                    prefixBase = BlockSetRegistry.stripPrefix(prefixBase, ignored);
                }
                for (String prefix : prefixes) {
                    String prefixed = prefix + "_" + prefixBase;
                    if (prefixed.equals(path) || !ShapeSetRegistry.has(candidate = base.m_247266_(p -> prefixed))) continue;
                    return true;
                }
                for (String parent : parentSuffixes) {
                    suffixBase = BlockSetRegistry.stripSuffix(suffixBase, parent);
                }
                for (String suffix : suffixes) {
                    ResourceLocation candidate3;
                    String trimmed;
                    String suffixed;
                    if (suffixBase.endsWith("s") && !(suffixed = (trimmed = suffixBase.substring(0, suffixBase.length() - 1)) + "_" + suffix).equals(path) && ShapeSetRegistry.has(candidate3 = base.m_247266_(p -> suffixed))) {
                        return true;
                    }
                    String suffixed2 = suffixBase + "_" + suffix;
                    if (suffixed2.equals(path) || !ShapeSetRegistry.has(candidate = base.m_247266_(p -> suffixed2))) continue;
                    return true;
                }
            }
            return false;
        }
    }

    public static class ShapeSet {
        private final ResourceLocation id;
        private final String type;
        private final Block block;
        private final Map<String, ItemLike> items = new LinkedHashMap<String, ItemLike>();

        ShapeSet(ResourceLocation id, Block block) {
            this.id = id;
            this.block = block;
            this.type = id.m_135815_().replace("_block", "").replace("_planks", "");
            this.initializeChildrenBlocks();
            ShapeSetRegistry.register(block.m_5456_(), this);
        }

        protected void initializeChildrenBlocks() {
            this.addChild("block", (ItemLike)this.block);
            if (this.id.m_135815_().contains("log")) {
                this.addChild("wood", (ItemLike)this.getWood());
                if (this.id.m_135815_().contains("stripped")) {
                    this.addChild("hollow_log", ClutterNoMore.location("wilderwild", this.id.m_135815_().replace("stripped_", "stripped_hollowed_")));
                } else {
                    this.addChild("hollow_log", ClutterNoMore.location("wilderwild", "hollowed_" + this.id.m_135815_()));
                }
            }
            this.addChild("slab", (ItemLike)this.findShape("slab"));
            this.addChild("stairs", (ItemLike)this.findShape("stairs"));
            this.addChild("wall", (ItemLike)this.findShape("wall"));
            this.addChild("vertical_slab", (ItemLike)this.findShape("clutternomore", this.id.m_135827_() + "/vertical", "slab"));
            this.addChild("vertical_slab", (ItemLike)this.findShape("clutternomore", "vertical", "slab"));
            this.addChild("vertical_slab", (ItemLike)this.findShape("vertical", "slab"));
            this.addChild("step", (ItemLike)this.findShape("clutternomore", this.id.m_135827_() + "/", "step", false));
            this.addChild("step", (ItemLike)this.findShape("clutternomore", "", "step"));
            this.addChild("step", (ItemLike)this.findShape("", "step"));
            this.addChild("spiked", (ItemLike)this.findShape("spiked", ""));
        }

        private void addChild(String block, ItemLike block1) {
            if (block1 != null && !this.items.containsKey(block)) {
                this.items.put(block, block1);
            }
        }

        private void addChild(String block, ResourceLocation id) {
            BuiltInRegistries.f_257033_.m_6612_(id).ifPresent(block1 -> this.items.put(block, (ItemLike)block1));
        }

        public String getVariantId(String prefix, String postfix) {
            Object name = prefix + (prefix.isEmpty() ? "" : "_") + this.getTypeName();
            List<String> suffixes = List.of("_block", "_planks", "s");
            for (String suffix : suffixes) {
                if (!((String)name).endsWith(suffix)) continue;
                name = ((String)name).substring(0, ((String)name).length() - suffix.length());
                break;
            }
            return (String)name + (postfix.isEmpty() ? "" : "_") + postfix;
        }

        private String getTypeName() {
            return this.type;
        }

        @Nullable
        protected Item findShape(String prefix, String postfix) {
            return this.findShape(this.id.m_135827_(), prefix, postfix);
        }

        @Nullable
        protected Item findShape(String namespace, String prefix, String postfix) {
            return this.findShape(namespace, prefix, postfix, true);
        }

        @Nullable
        protected Item findShape(String namespace, String prefix, String postfix, boolean addUnderscore) {
            String basePath = this.id.m_135815_();
            List<String> parentSuffixes = List.of("block", "planks");
            for (String parent : parentSuffixes) {
                basePath = BlockSetRegistry.stripSuffix(basePath, parent);
            }
            List<String> ignoredPrefixes = List.of("stripped");
            Object reapplyPrefix = "";
            for (String ignored : ignoredPrefixes) {
                if (!this.id.m_135815_().startsWith(ignored + "_")) continue;
                reapplyPrefix = ignored + "_";
                basePath = BlockSetRegistry.stripPrefix(basePath, ignored);
            }
            String prefixPart = prefix.isEmpty() ? "" : prefix + (addUnderscore ? "_" : "");
            Object postfixPart = postfix.isEmpty() ? "" : "_" + postfix;
            ArrayList<String> candidates = new ArrayList<String>();
            if (basePath.endsWith("s")) {
                candidates.add(basePath.substring(0, basePath.length() - 1));
            }
            candidates.add(basePath);
            for (String stem : candidates) {
                String candidatePath = (String)reapplyPrefix + prefixPart + stem + (String)postfixPart;
                ResourceLocation candidateId = ClutterNoMore.location(namespace, candidatePath);
                Optional found = BuiltInRegistries.f_257033_.m_6612_(candidateId);
                if (!found.isPresent()) continue;
                return (Item)found.get();
            }
            return null;
        }

        @Nullable
        protected Item findShape(String postfix) {
            return this.findShape("", postfix);
        }

        @Nullable
        protected Item getWood() {
            String path = this.id.m_135815_();
            if (path.endsWith("log")) {
                String stem = path.substring(0, path.length() - 3);
                ResourceLocation woodId = this.id.m_247266_(p -> stem + "wood");
                return BuiltInRegistries.f_257033_.m_6612_(woodId).orElse(null);
            }
            return null;
        }

        public Block mainChild() {
            return this.block;
        }

        public Collection<ItemLike> getChildren() {
            return this.items.values();
        }
    }
}

