package dev.tazer.clutternomore;

import dev.tazer.clutternomore.client.ShapeSwitcherOverlay;
import dev.tazer.clutternomore.client.assets.AssetGenerator;
import dev.tazer.clutternomore.common.shape_map.ShapeMap;
import dev.tazer.clutternomore.common.mixin.access.SlotAccessor;
import dev.tazer.clutternomore.common.mixin.screen.ContainerScreenAccessor;
//? if !forge {
 import dev.tazer.clutternomore.common.networking.ChangeStackPayload;
//?} else if forge && <1.21.1 {
/*import dev.tazer.clutternomore.forge.networking.ChangeStackPacket;
import dev.tazer.clutternomore.forge.networking.ForgeNetworking;
*///?}
//? if fabric {
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3283;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_9779;
//? if neoforge {
/*import net.neoforged.neoforge.network.PacketDistributor;
*///?}
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;

import static dev.tazer.clutternomore.ClutterNoMore.MODID;

public class ClutterNoMoreClient {
    public static boolean showTooltip = false;
    public static ShapeSwitcherOverlay OVERLAY = null;
    public static final CNMConfig.ClientConfig CLIENT_CONFIG = CNMConfig.ClientConfig.createToml(Platform.INSTANCE.configPath(), MODID,  "client", CNMConfig.ClientConfig.class);
    public static boolean requireReload = false;

    public static void init() {
    }

    public static void clientStarted(class_310 client) {
        AssetGenerator.generate();
        ClutterNoMoreClient.enablePack(client);
    }

    public static void onItemTooltips(class_1799 stack,
                                      //? if >1.21 {
                                      class_1792.class_9635
                                              //?} else
                                              /*Object*/
                                              tooltipContext, class_1836 tooltipFlag, List<class_2561> tooltip) {
        if (!showTooltip) {
            if (ShapeMap.contains(stack.method_7909())) {
                class_2561 component = tooltip.get(0).method_27661().method_10852(class_2561.method_43470(" [+]").method_27692(class_124.field_1063));
                tooltip.remove(0);
                tooltip.add(0, component);
            }
        }
    }

    public static void onKeyInput(int keyCode, int action) {
        if (keyCode == shapeKey()) {
            class_310 minecraft = class_310.method_1551();
            if (minecraft.field_1755 == null) {
                class_1657 player = minecraft.field_1724;
                if (player != null) {
                    class_1799 heldStack = player.method_5998(class_1268.field_5808);
                    if (ShapeMap.contains(heldStack.method_7909())) {
                        switch (CLIENT_CONFIG.HOLD.value()) {
                            case HOLD -> {
                                if (OVERLAY == null && action == 1)
                                    OVERLAY = new ShapeSwitcherOverlay(minecraft, heldStack, true);
                                else if (action == 0) OVERLAY = null;
                            }
                            case TOGGLE -> {
                                if (action == 1) {
                                    if (OVERLAY == null) OVERLAY = new ShapeSwitcherOverlay(minecraft, heldStack, true);
                                    else OVERLAY = null;
                                }
                            }
                            case PRESS -> {
                                if (action == 1) {
                                    if (OVERLAY == null)
                                        OVERLAY = new ShapeSwitcherOverlay(minecraft, heldStack, false);
                                    OVERLAY.onMouseScrolled(-1);
                                    OVERLAY = null;
                                }
                            }
                        }

                    }
                }
            }
        }
    }

    public static void onKeyPress(class_437 screen, int button) {
        if (button == shapeKey() && screen instanceof class_465<?> containerScreen) {
            class_1735 slot = ((ContainerScreenAccessor) screen).getSlotUnderMouse();
            if (slot != null) {
                class_1799 heldStack = slot.method_7677();
                class_1657 player = class_310.method_1551().field_1724;

                if (slot.method_32754(player) && (ShapeMap.contains(heldStack.method_7909()))) {
                    switch (CLIENT_CONFIG.HOLD.value()) {
                        case HOLD -> showTooltip = true;
                        case TOGGLE -> showTooltip = !showTooltip;
                        case PRESS -> switchShapeInSlot(
                                player,
                                containerScreen.method_17577().field_7763,
                                ((SlotAccessor) slot).getSlotIndex(),
                                heldStack,
                                -1
                        );
                    }
                }
            }
        }
    }

    public static boolean onKeyReleased(int button) {
        if (button == shapeKey()) {
            if (CLIENT_CONFIG.HOLD.value() == CNMConfig.InputType.HOLD) {
                showTooltip = false;
            }
        }
        return false;
    }

    public static void switchShapeInSlot(class_1657 player, int containerId, int slotId, class_1799 heldStack, int direction) {
        class_1792 item = ShapeMap.getParent(heldStack.method_7909());
        int count = heldStack.method_7947();

        List<class_1792> shapes = new ArrayList<>(ShapeMap.getShapes(item));
        shapes.add(0, item);
        int selectedIndex = shapes.indexOf(heldStack.method_7909());

        int maxIndex = shapes.size() - 1;
        selectedIndex = selectedIndex - direction;
        if (selectedIndex < 0) selectedIndex = maxIndex;
        if (selectedIndex > maxIndex) selectedIndex = 0;

        class_1792 nextItem = shapes.get(selectedIndex);
        class_1799 next = nextItem.method_7854();
        next.method_7939(count);
        player.method_5783(class_3417.field_15015.comp_349(), 0.3F, 1.5F);
        if (slotId < 9) slotId += 36;
        //? if !forge {
        var p = new ChangeStackPayload(containerId, slotId, next);
        //?}
        //? if fabric
        ClientPlayNetworking.send(p);
        //? if neoforge
        /*PacketDistributor.sendToServer(p);*/
        //? if forge && <1.21.1 {
        /*ChangeStackPacket p = new ChangeStackPacket(containerId, slotId, next);
        ForgeNetworking.sendToServer(p);
        *///?}
    }

    public static int shapeKey() {
        return Platform.INSTANCE.shapeKey();
    }

    public static void onPlayerTick(class_310 minecraft) {
        if (OVERLAY != null) {
            if (!OVERLAY.shouldStayOpenThisTick()) OVERLAY = null;
        }
    }

    //? if >1.21 {
    public static void onRenderGui(class_332 guiGraphics, class_9779 tracker) {
        if (OVERLAY != null && OVERLAY.render) {
            OVERLAY.render(guiGraphics, tracker.method_60636());
        }
    }
    //?}

    public static boolean allowScreenScroll(class_437 pScreen, double mouseX, double mouseY, double scrollX, double scrollY) {
        if (showTooltip) {
            if (pScreen instanceof class_465<?> screen) {
                class_1735 slot = ((ContainerScreenAccessor) screen).getSlotUnderMouse();
                class_1657 player = class_310.method_1551().field_1724;
                if (slot != null && slot.method_32754(player)) {
                    class_1799 heldStack = slot.method_7677();
                    if (ShapeMap.contains(heldStack.method_7909())) {
                        switchShapeInSlot(player, screen.method_17577().field_7763, ((SlotAccessor) slot).getSlotIndex(), heldStack, (int) scrollY);
                        return false;
                    }
                }
            }
        }

        return true;
    }

    public static boolean onMouseScrolling(double yOffset) {
        int direction = (int) yOffset;
        if (OVERLAY != null) {
            OVERLAY.onMouseScrolled(direction);
            return true;
        }
        return false;
    }

    private static void enablePack(class_310 client) {
        class_3283 repository = client.method_1520();
        Path packPath = client.method_1479().resolve("clutternomore");
        String packId = "file/" + packPath.getFileName().toString();
        if (requireReload || !repository.method_29210().contains(packId)) {
            if (repository.method_14449(packId) != null) {
                repository.method_49427(packId);
                client.method_1521();
            }
        }
    }
}
