package dev.tazer.clutternomore.common.shape_map;


import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.tazer.clutternomore.ClutterNoMore;
import java.util.*;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_5699;
import net.minecraft.class_7654;

public class ShapeMapFileHandler extends class_4309
//? >1.21.2
<JsonElement>
//? if fabric && <1.21.9 {
    /*implements IdentifiableResourceReloadListener
*///?}
{

    //? if >1.21.2 {

    public static final class_7654 CONVERTER = class_7654.method_45114("shape_map");
    public ShapeMapFileHandler() {
        super(class_5699.field_40721, CONVERTER);
    }
    //?} else {
    /*public static final Gson GSON = new GsonBuilder().create();

    public ShapeMapFileHandler() {
        super(GSON, "shape_map");
    }
    *///?}
    
    //? if fabric && <1.21.9 {
    /*@Override
    public ResourceLocation getFabricId() {
        return ClutterNoMore.location("shape_map");
    }
    *///?}

    @Override
    protected void apply(Map<class_2960, JsonElement> file, class_3300 resourceManager, class_3695 profilerFiller) {
        Map<class_2960, List<class_2960>> result = new HashMap<>();
        Map<String, ShapeMapFile> namespaceMap = new HashMap<>();

        for (Map.Entry<class_2960, JsonElement> fileEntry : file.entrySet()) {
            class_2960 fileName = fileEntry.getKey();
            String path = fileName.method_12832();
            if (!path.equals("add_shapes") && !path.equals("remove_shapes")) continue;

            Map<class_2960, List<class_2960>> fileShapeMap = new HashMap<>();

            JsonObject content = fileEntry.getValue().getAsJsonObject();
            for (Map.Entry<String, JsonElement> contentEntry : content.entrySet()) {
                class_2960 key = ClutterNoMore.parse(contentEntry.getKey());
                List<class_2960> values = new ArrayList<>();

                for (JsonElement element : contentEntry.getValue().getAsJsonArray()) {
                    values.add(ClutterNoMore.parse(element.getAsString()));
                }

                fileShapeMap.put(key, values);
            }

            String namespace = fileName.method_12836();
            ShapeMapFile namespaceShapeMap = namespaceMap.computeIfAbsent(namespace, s -> new ShapeMapFile(new HashMap<>(), new HashMap<>()));

            if (path.equals("add_shapes")) {
                namespaceShapeMap.addMap().putAll(fileShapeMap);
            } else {
                namespaceShapeMap.removeMap().putAll(fileShapeMap);
            }
        }

        for (ShapeMapFile shapeMapFile : namespaceMap.values()) {
            result.putAll(shapeMapFile.getResultingMap());
        }

        ShapeMap.set(result);
    }

    private record ShapeMapFile(Map<class_2960, List<class_2960>> addMap, Map<class_2960, List<class_2960>> removeMap) {
        public Map<class_2960, List<class_2960>> getResultingMap() {
            for (Map.Entry<class_2960, List<class_2960>> entry : new HashSet<>(removeMap.entrySet())) {
                class_2960 key = entry.getKey();
                List<class_2960> removeList = entry.getValue();

                List<class_2960> list = addMap.get(key);
                if (list != null) {
                    if (list.removeAll(removeList)) {
                        if (list.isEmpty()) addMap.remove(key);
                    }
                }
            }

            return addMap;
        }
    }
}
