/*
 * Decompiled with CFR 0.152.
 */
package dev.tazer.clutternomore;

import dev.tazer.clutternomore.CNMConfig;
import dev.tazer.clutternomore.Platform;
import dev.tazer.clutternomore.client.assets.AssetGenerator;
import dev.tazer.clutternomore.client.assets.StepGenerator;
import dev.tazer.clutternomore.client.assets.VerticalSlabGenerator;
import dev.tazer.clutternomore.common.blocks.StepBlock;
import dev.tazer.clutternomore.common.blocks.VerticalSlabBlock;
import dev.tazer.clutternomore.common.blocks.WeatheringStepBlock;
import dev.tazer.clutternomore.common.blocks.WeatheringVerticalSlabBlock;
import dev.tazer.clutternomore.common.data.CNMPackResources;
import dev.tazer.clutternomore.common.data.DataGenerator;
import dev.tazer.clutternomore.common.mixin.access.BlockBehaviorAccessor;
import dev.tazer.clutternomore.common.registry.CBlocks;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1863;
import net.minecraft.class_2248;
import net.minecraft.class_2482;
import net.minecraft.class_2498;
import net.minecraft.class_2510;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3288;
import net.minecraft.class_4970;
import net.minecraft.class_5321;
import net.minecraft.class_5352;
import net.minecraft.class_5813;
import net.minecraft.class_5814;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_9224;
import net.minecraft.class_9225;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClutterNoMore {
    public static final String MODID = "clutternomore";
    public static final Logger LOGGER = LogManager.getLogger((String)"ClutterNoMore");
    public static final CNMConfig.StartupConfig STARTUP_CONFIG = (CNMConfig.StartupConfig)CNMConfig.StartupConfig.createToml((Path)Platform.INSTANCE.configPath(), (String)"clutternomore", (String)"startup", CNMConfig.StartupConfig.class);
    private static final class_9224 PACK_INFO = new class_9224("clutternomore-runtime", (class_2561)class_2561.method_43470((String)"ClutterNoMore"), class_5352.field_25348, Optional.empty());
    public static final CNMPackResources RESOURCES = new CNMPackResources(PACK_INFO);
    public static LinkedHashMap<class_2960, class_2960> COPPER_BLOCKS = new LinkedHashMap();
    public static ArrayList<class_2960> WAXED_COPPER_BLOCKS = new ArrayList();
    public static final Path pack = Platform.INSTANCE.getResourcePack().resolve("clutternomore");

    public static void init() {
        LOGGER.info("Initializing {} on {}", (Object)MODID, (Object)Platform.INSTANCE.loader());
    }

    public static class_3288 createPack(class_3264 type) {
        return class_3288.method_45275((class_9224)PACK_INFO, (class_3288.class_7680)new PackResourcesSupplier(), (class_3264)type, (class_9225)new class_9225(true, class_3288.class_3289.field_14281, true));
    }

    public static class_2960 location(String path) {
        return ClutterNoMore.location(MODID, path);
    }

    public static class_2960 location(String namespace, String path) {
        return class_2960.method_60655((String)namespace, (String)path);
    }

    public static class_2960 parse(String id) {
        return class_2960.method_60654((String)id);
    }

    public static void modifyRecipes(class_7225.class_7874 registries, class_1863 recipeManager) {
    }

    public static void registerVariants() {
        if (((Boolean)ClutterNoMore.STARTUP_CONFIG.VERTICAL_SLABS.value()).booleanValue() || ((Boolean)ClutterNoMore.STARTUP_CONFIG.STEPS.value()).booleanValue()) {
            LinkedHashMap<Object, Supplier> toRegister = new LinkedHashMap<Object, Supplier>();
            ArrayList<class_2960> slabs = new ArrayList<class_2960>();
            ArrayList<class_2960> stairs = new ArrayList<class_2960>();
            List<class_2498> woodenSoundTypes = List.of(class_2498.field_11547, class_2498.field_40314, class_2498.field_42766, class_2498.field_40315);
            List<class_2498> shovelSoundTypes = List.of(class_2498.field_11529, class_2498.field_11535);
            for (Map.Entry resourceKeyItemEntry : class_7923.field_41178.method_29722()) {
                class_2510 stairBlock;
                class_2498 soundType;
                class_2960 shapeId;
                Supplier<class_2248> block;
                String path;
                Object shortPath;
                class_2482 slabBlock;
                class_2248 class_22482;
                class_1792 class_17922 = ((class_1792)resourceKeyItemEntry.getValue()).method_8389();
                if (!(class_17922 instanceof class_1747)) continue;
                class_1747 blockItem = (class_1747)class_17922;
                class_2960 blockId = ((class_5321)resourceKeyItemEntry.getKey()).method_29177();
                Object blockNamespace = blockId.method_12836() + "/";
                if (blockId.method_12836().equals("minecraft")) {
                    blockNamespace = "";
                }
                if ((class_22482 = blockItem.method_7711()) instanceof class_2482 && (slabBlock = (class_2482)class_22482).method_9564().method_11656().size() == 2 && ((Boolean)ClutterNoMore.STARTUP_CONFIG.VERTICAL_SLABS.value()).booleanValue()) {
                    shortPath = "vertical_" + blockId.method_12832();
                    path = (String)blockNamespace + (String)shortPath;
                    if (slabBlock instanceof class_5813) {
                        class_5813 weatheringSlabBlock = (class_5813)slabBlock;
                        block = () -> new WeatheringVerticalSlabBlock(ClutterNoMore.copy((class_2248)slabBlock).method_63500(CBlocks.registryKey(path)), weatheringSlabBlock.method_33633());
                        toRegister.put(path, block);
                        ClutterNoMore.matchCopperBlock(ClutterNoMore.location(path));
                    } else {
                        toRegister.put(path, () -> new VerticalSlabBlock(ClutterNoMore.copy((class_2248)slabBlock).method_63500(CBlocks.registryKey(path))));
                        if (path.contains("waxed")) {
                            WAXED_COPPER_BLOCKS.add(ClutterNoMore.location(path));
                        }
                    }
                    slabs.add(blockId);
                    shapeId = ClutterNoMore.location(path);
                    DataGenerator.addLootTable(blockId, shapeId);
                    soundType = ((BlockBehaviorAccessor)slabBlock).getSoundType();
                    if (woodenSoundTypes.contains(soundType)) {
                        DataGenerator.woodenVerticalSlabsArray.add(ClutterNoMore.location(path).toString());
                    } else {
                        DataGenerator.addToTag(path, DataGenerator.verticalSlabsArray);
                        if (shovelSoundTypes.contains(soundType)) {
                            DataGenerator.addToTag(path, DataGenerator.shovelMineableArray);
                        } else {
                            DataGenerator.addToTag(path, DataGenerator.pickaxeMineableArray);
                        }
                    }
                }
                if (!((shortPath = blockItem.method_7711()) instanceof class_2510) || (stairBlock = (class_2510)shortPath).method_9564().method_11656().size() != 4 || !((Boolean)ClutterNoMore.STARTUP_CONFIG.STEPS.value()).booleanValue()) continue;
                shortPath = blockId.method_12832().replace("stairs", "step");
                path = (String)blockNamespace + (String)shortPath;
                if (stairBlock instanceof class_5814) {
                    class_5814 weatheringCopperStairBlock = (class_5814)stairBlock;
                    block = () -> new WeatheringStepBlock(ClutterNoMore.copy((class_2248)stairBlock).method_63500(CBlocks.registryKey(path)), weatheringCopperStairBlock.method_33634());
                    toRegister.put(path, block);
                    ClutterNoMore.matchCopperBlock(ClutterNoMore.location(path));
                } else {
                    toRegister.put(path, () -> new StepBlock(ClutterNoMore.copy((class_2248)stairBlock).method_63500(CBlocks.registryKey(path))));
                    if (path.contains("waxed")) {
                        WAXED_COPPER_BLOCKS.add(ClutterNoMore.location(path));
                    }
                }
                stairs.add(blockId);
                shapeId = ClutterNoMore.location(path);
                DataGenerator.addLootTable(blockId, shapeId);
                soundType = ((BlockBehaviorAccessor)stairBlock).getSoundType();
                if (woodenSoundTypes.contains(soundType)) {
                    DataGenerator.addToTag(shapeId, DataGenerator.woodenStepsArray);
                    continue;
                }
                DataGenerator.addToTag(shapeId, DataGenerator.stepsArray);
                if (shovelSoundTypes.contains(soundType)) {
                    DataGenerator.addToTag(path, DataGenerator.shovelMineableArray);
                    continue;
                }
                DataGenerator.addToTag(path, DataGenerator.pickaxeMineableArray);
            }
            toRegister.forEach(CBlocks::register);
            AssetGenerator.keys = toRegister.keySet();
            VerticalSlabGenerator.SLABS = slabs;
            StepGenerator.STAIRS = stairs;
            DataGenerator.generate();
            Platform.INSTANCE.finalizeCopperBlockRegistration();
        }
    }

    private static void matchCopperBlock(class_2960 id) {
        if (id.method_12832().contains("oxidized")) {
            class_2960 weatheredPath = ClutterNoMore.location(id.method_12836(), id.method_12832().replace("oxidized", "weathered"));
            COPPER_BLOCKS.put(weatheredPath, id);
        }
        if (id.method_12832().contains("weathered")) {
            class_2960 exposed = ClutterNoMore.location(id.method_12836(), id.method_12832().replace("weathered", "exposed"));
            COPPER_BLOCKS.put(exposed, id);
        }
        if (id.method_12832().contains("exposed")) {
            class_2960 unaffected = ClutterNoMore.location(id.method_12836(), id.method_12832().replace("exposed_", ""));
            COPPER_BLOCKS.put(unaffected, id);
        }
    }

    public static void writeFile(Path path, Path filePath, String contents) {
        try {
            path.toFile().mkdirs();
            FileWriter langWriter = new FileWriter(filePath.toFile());
            langWriter.write(contents);
            langWriter.close();
            LOGGER.debug("Successfully wrote to {}", (Object)filePath);
        }
        catch (IOException e) {
            LOGGER.error("Failed to write dynamic data. %s".formatted(e));
        }
    }

    public static class_4970.class_2251 copy(class_2248 block) {
        return class_4970.class_2251.method_9630((class_4970)block);
    }

    private static class PackResourcesSupplier
    implements class_3288.class_7680 {
        private PackResourcesSupplier() {
        }

        public class_3262 method_52424(class_9224 location) {
            return RESOURCES;
        }

        public class_3262 method_52425(class_9224 location, class_3288.class_7679 metadata) {
            return RESOURCES;
        }
    }
}

