package io.github.atticushelvig.instant_shield.mixin;

import net.minecraft.class_10707;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_10707.class)
public abstract class BlocksAttacksComponentMixin {

    @Inject(method = "getBlockDelayTicks", at = @At("RETURN"), cancellable = true)
    private void modifyBlockDelay(CallbackInfoReturnable<Integer> cir) {
        cir.setReturnValue(0);
        cir.cancel();
    }
}
