/*
 * Decompiled with CFR 0.152.
 */
package github.mcdatapack.blocktopia.block.custom;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import github.mcdatapack.blocktopia.block.FutureBlocks;
import net.minecraft.class_1267;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2356;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import net.minecraft.class_4466;
import net.minecraft.class_4970;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_6880;

public class EyeblossomBlock
extends class_2356 {
    public static final MapCodec<EyeblossomBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.BOOL.fieldOf("open").forGetter(block -> block.state.open), (App)EyeblossomBlock.method_54096()).apply((Applicative)instance, EyeblossomBlock::new));
    private final EyeblossomState state;

    public MapCodec<? extends EyeblossomBlock> method_53969() {
        return CODEC;
    }

    public EyeblossomBlock(EyeblossomState state, class_4970.class_2251 settings) {
        super(state.stewEffect, state.effectLengthInSeconds, settings);
        this.state = state;
    }

    public EyeblossomBlock(boolean open, class_4970.class_2251 settings) {
        super(EyeblossomState.of((boolean)open).stewEffect, EyeblossomState.of((boolean)open).effectLengthInSeconds, settings);
        this.state = EyeblossomState.of(open);
    }

    protected void method_9514(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        this.updateStateAndNotifyOthers(state, world, pos, random);
        super.method_9514(state, world, pos, random);
    }

    protected void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        this.updateStateAndNotifyOthers(state, world, pos, random);
        super.method_9588(state, world, pos, random);
    }

    private boolean updateStateAndNotifyOthers(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        if (!world.method_8597().comp_645()) {
            return false;
        }
        if (world.method_23886() == this.state.open) {
            return false;
        }
        EyeblossomState eyeblossomState = this.state.getOpposite();
        world.method_8652(pos, eyeblossomState.getBlockState(), 3);
        world.method_43276((class_6880)class_5712.field_28733, pos, class_5712.class_7397.method_43287((class_2680)state));
        class_2338.method_10097((class_2338)pos.method_10069(-3, -2, -3), (class_2338)pos.method_10069(3, 2, 3)).forEach(otherPos -> {
            class_2680 blockState2 = world.method_8320(otherPos);
            if (blockState2 == state) {
                double d = Math.sqrt(pos.method_10262((class_2382)otherPos));
                int i = random.method_39332((int)(d * 5.0), (int)(d * 10.0));
                world.method_39279(otherPos, state.method_26204(), i);
            }
        });
        return true;
    }

    protected void method_9548(class_2680 state, class_1937 world, class_2338 pos, class_1297 entity) {
        if (!world.method_8608() && world.method_8407() != class_1267.field_5801 && entity instanceof class_4466) {
            class_4466 beeEntity = (class_4466)entity;
            if (state.method_26164(class_3481.field_20339) && !beeEntity.method_6059(class_1294.field_5899)) {
                beeEntity.method_6092(this.getContactEffect());
            }
        }
    }

    public class_1293 getContactEffect() {
        return new class_1293(class_1294.field_5899, 25);
    }

    public static enum EyeblossomState {
        OPEN(true, (class_6880<class_1291>)class_1294.field_5919, 11.0f),
        CLOSED(false, (class_6880<class_1291>)class_1294.field_5916, 7.0f);

        final boolean open;
        final class_6880<class_1291> stewEffect;
        final float effectLengthInSeconds;

        private EyeblossomState(boolean open, class_6880<class_1291> stewEffect, float effectLengthInSeconds) {
            this.open = open;
            this.stewEffect = stewEffect;
            this.effectLengthInSeconds = effectLengthInSeconds;
        }

        public class_2248 getBlock() {
            return this.open ? FutureBlocks.OPEN_EYEBLOSSOM : FutureBlocks.CLOSED_EYEBLOSSOM;
        }

        public class_2680 getBlockState() {
            return this.getBlock().method_9564();
        }

        public EyeblossomState getOpposite() {
            return EyeblossomState.of(!this.open);
        }

        public boolean isOpen() {
            return this.open;
        }

        public static EyeblossomState of(boolean open) {
            return open ? OPEN : CLOSED;
        }
    }
}

