/*
 * Decompiled with CFR 0.152.
 */
package github.mcdatapack.blocktopia.datagen.provider;

import github.mcdatapack.blocktopia.Blocktopia;
import github.mcdatapack.blocktopia.block.FutureBlocks;
import github.mcdatapack.blocktopia.block.LegacyBlocks;
import github.mcdatapack.blocktopia.block.ModBlocks;
import github.mcdatapack.blocktopia.block.custom.ChairBlock;
import github.mcdatapack.blocktopia.block.custom.WoodCutterBlock;
import github.mcdatapack.blocktopia.block.entity.custom.FluidTankBlockEntity;
import github.mcdatapack.blocktopia.item.FutureItems;
import github.mcdatapack.blocktopia.item.LegacyItems;
import github.mcdatapack.blocktopia.item.ModItemGroups;
import github.mcdatapack.blocktopia.item.ModItems;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricLanguageProvider;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_7225;
import net.minecraft.class_7417;
import org.jetbrains.annotations.NotNull;

public class BlocktopiaLangProvider
extends FabricLanguageProvider {
    public BlocktopiaLangProvider(FabricDataOutput dataOutput, CompletableFuture<class_7225.class_7874> registryLookup) {
        super(dataOutput, "en_us", registryLookup);
    }

    public void generateTranslations(class_7225.class_7874 registryLookup, FabricLanguageProvider.TranslationBuilder builder) {
        try {
            builder.add(Path.of(URI.create(String.valueOf(BlocktopiaLangProvider.class.getClassLoader().getResource("assets/blocktopia/notdatagen/lang/en_us.json")))));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        builder.add((class_2248)ModBlocks.FLUID_TANK, "Fluid Tank");
        BlocktopiaLangProvider.addText(builder, FluidTankBlockEntity.NAME, "Fluid Tank");
        builder.add(ModItemGroups.COLORED_BLOCKS_GROUP, "\u00a72\u00a7lBlocktopia: \u00a7rColored Blocks");
        builder.add(ModItemGroups.LEGACY_ITEMS_GROUP, "\u00a72\u00a7lBlocktopia: \u00a7rLegacy Items");
        this.addChairs(builder, ModBlocks.OAK_CHAIR, "Oak Chair");
        this.addChairs(builder, ModBlocks.BIRCH_CHAIR, "Birch Chair");
        this.addChairs(builder, ModBlocks.SPRUCE_CHAIR, "Spruce Chair");
        this.addChairs(builder, ModBlocks.JUNGLE_CHAIR, "Jungle Chair");
        this.addChairs(builder, ModBlocks.ACACIA_CHAIR, "Acacia Chair");
        this.addChairs(builder, ModBlocks.DARK_OAK_CHAIR, "Dark Oak Chair");
        this.addChairs(builder, ModBlocks.CRIMSON_CHAIR, "Crimson Chair");
        this.addChairs(builder, ModBlocks.WARPED_CHAIR, "Warped Chair");
        this.addChairs(builder, ModBlocks.MANGROVE_CHAIR, "Mangrove Chair");
        this.addChairs(builder, ModBlocks.BAMBOO_CHAIR, "Bamboo Chair");
        this.addChairs(builder, ModBlocks.CHERRY_CHAIR, "Cherry Chair");
        this.addChairs(builder, ModBlocks.PALM_CHAIR, "Palm Chair");
        this.addChairs(builder, ModBlocks.BANANA_CHAIR, "Banana Chair");
        this.addChairs(builder, ModBlocks.CORN_CHAIR, "Corn Chair");
        this.addChairs(builder, ModBlocks.POISONED_CHAIR, "Poisoned Chair");
        this.addChairs(builder, ModBlocks.MAHOGANY_CHAIR, "Mahogany Chair");
        this.addChairs(builder, ModBlocks.PALE_OAK_CHAIR, "Pale Oak Chair");
        builder.add(LegacyItems.QUIVER_IN20091231_2255, "Quiver");
        builder.add(LegacyItems.QUIVER_IN20100122_2251, "Quiver");
        builder.add(LegacyItems.APPLE_IN20091231_2255, "Apple");
        builder.add(LegacyItems.APPLE_1_4, "Apple");
        builder.add(LegacyItems.COAL_IN20100128, "Coal");
        builder.add(LegacyItems.COAL_IN20100219, "Coal");
        builder.add(LegacyItems.COAL_1_3, "Coal");
        builder.add(LegacyItems.DIAMOND_IN20100128, "Diamond");
        builder.add(LegacyItems.DIAMOND_1_3, "Diamond");
        builder.add(LegacyItems.GOLD_INGOT_IN20100128, "Gold Ingot");
        builder.add(LegacyItems.GOLD_INGOT_IN20100129, "Gold Ingot");
        builder.add(LegacyItems.IRON_INGOT_IN20100128, "Iron Ingot");
        builder.add(LegacyItems.IRON_INGOT_IN20100129, "Iron Ingot");
        builder.add(LegacyItems.BOWL_IN20100130, "Bowl");
        builder.add(LegacyItems.MUSHROOM_STEW_IN20100130, "Mushroom Stew");
        builder.add(LegacyItems.SULPHUR, "Sulphur");
        builder.add(LegacyItems.STRING_IN20100130, "String");
        builder.add(LegacyItems.FEATHER_IN20100130, "Feather");
        builder.add(LegacyItems.FEATHER_IN20100206, "Feather");
        builder.add(LegacyItems.BREAD_IN20100206, "Bread");
        builder.add(LegacyItems.BREAD_1_4, "Bread");
        builder.add(LegacyItems.WHEAT_IN20100206, "Wheat");
        builder.add(LegacyItems.FLINT_IN20100219, "Flint");
        builder.add(LegacyItems.FLINT_1_3, "Flint");
        builder.add(LegacyItems.PORKCHOP_IN20100219, "Raw Porkchop");
        builder.add(LegacyItems.PORKCHOP_1_4, "Raw Porkchop");
        builder.add(LegacyItems.COOKED_PORKCHOP_IN20100219, "Cooked Porkchop");
        builder.add(LegacyItems.COOKED_PORKCHOP_B1_8, "Cooked Porkchop");
        builder.add(LegacyItems.COOKED_PORKCHOP_1_4, "Cooked Porkchop");
        builder.add(LegacyItems.GOLDEN_APPLE_INF20100227, "Golden Apple");
        builder.add(LegacyItems.LEATHER_A1_0_8, "Leather");
        builder.add(LegacyItems.PAPER_A1_0_11, "Paper");
        builder.add(LegacyItems.BOOK_A1_0_11, "Book");
        builder.add(LegacyItems.CLAY_BALL_A1_0_11, "Clay Ball");
        builder.add(LegacyItems.BRICK_A1_0_11, "Brick");
        builder.add(LegacyItems.SLIMEBALL_A1_0_11, "Slimeball");
        builder.add(LegacyItems.GLOWSTONE_DUST_A1_2_0, "Glowstone");
        builder.add(LegacyItems.FISH_A1_2_0, "Raw Fish");
        builder.add(LegacyItems.COOKED_FISH_A1_2_0, "Cooked Fish");
        builder.add(LegacyItems.BONE_B1_2, "Bone");
        builder.add((class_1792)LegacyItems.BONE_MEAL_B1_2, "Bone Meal");
        builder.add((class_1792)LegacyItems.BONE_MEAL_1_3, "Bone Meal");
        builder.add(LegacyItems.COOKIE_B1_4, "Cookie");
        builder.add(LegacyItems.CHICKEN_B1_8, "Raw Chicken");
        builder.add(LegacyItems.CHICKEN_1_4, "Raw Chicken");
        builder.add(LegacyItems.COOKED_CHICKEN_B1_8, "Cooked Chicken");
        builder.add(LegacyItems.COOKED_CHICKEN_1_4, "Cooked Chicken");
        builder.add(LegacyItems.BEEF_B1_8, "Raw Beef");
        builder.add(LegacyItems.BEEF_1_3, "Raw Beef");
        builder.add(LegacyItems.BEEF_1_4, "Raw Beef");
        builder.add(LegacyItems.COOKED_BEEF_B1_8, "Cooked Beef");
        builder.add(LegacyItems.COOKED_BEEF_1_3, "Cooked Beef");
        builder.add(LegacyItems.COOKED_BEEF_1_4, "Cooked Beef");
        builder.add(LegacyItems.ROTTEN_FLESH_B1_8, "Rotten Flesh");
        builder.add(LegacyItems.ROTTEN_FLESH_1_3, "Rotten Flesh");
        builder.add(LegacyItems.GHAST_TEAR_B1_9PRE, "Ghast Tear");
        builder.add(LegacyItems.GOLD_NUGGET_B1_9PRE, "Gold Nugget");
        builder.add(LegacyItems.GOLD_NUGGET_1_3, "Gold Nugget");
        builder.add(LegacyItems.BLAZE_POWDER_B1_9PRE2, "Blaze Powder");
        builder.add(LegacyItems.FERMENTED_SPIDER_EYE_B1_9PRE2, "Fermented Spider Eye");
        builder.add(LegacyItems.MAGMA_CREAM_B1_9PRE2, "Magma Cream");
        builder.add(LegacyItems.MAGMA_CREAM_1_3, "Magma Cream");
        builder.add(LegacyItems.SPIDER_EYE_B1_9PRE2, "Spider Eye");
        builder.add(LegacyItems.GLISTERING_MELON_B1_9PRE4, "Glistering Melon Slice");
        builder.add(LegacyItems.RUBY, "Ruby");
        builder.add(LegacyItems.EMERALD_1_3, "Emerald");
        builder.add(LegacyItems.ENCHANTED_GOLDEN_APPLE_1_3, "Enchanted Golden Apple");
        builder.add(LegacyItems.GOLDEN_CARROT_1_4, "Golden Carrot");
        builder.add(LegacyItems.BAKED_POTATO_1_4, "Baked Potato");
        builder.add(LegacyItems.POISONOUS_POTATO_1_4, "Poisonous Potato");
        builder.add(LegacyItems.NETHER_STAR_1_4, "Nether Star");
        builder.add(LegacyItems.PUMPKIN_PIE_1_4, "Pumpkin Pie");
        builder.add(LegacyItems.QUARTZ_1_5, "Nether Quartz");
        builder.add(LegacyItems.CLOWNFISH_1_7, "Clownfish");
        builder.add(LegacyItems.SALMON_1_7, "Raw Salmon");
        builder.add(LegacyItems.COOKED_SALMON_1_7, "Cooked Salmon");
        builder.add(LegacyItems.PUFFERFISH_1_7, "Pufferfish");
        builder.add(LegacyItems.PRISMARINE_CRYSTAL_1_8, "Prismarine Crystals");
        builder.add(LegacyItems.PRISMARINE_SHARD_1_8, "Prismarine Shard");
        builder.add(LegacyItems.MUTTON_1_8, "Raw Mutton");
        builder.add(LegacyItems.COOKED_MUTTON_1_8, "Cooked Mutton");
        builder.add(LegacyItems.RABBIT_1_8, "Raw Rabbit");
        builder.add(LegacyItems.COOKED_RABBIT_1_8, "Cooked Rabbit");
        builder.add(LegacyItems.RABBIT_FOOT_1_8, "Rabbit Foot");
        builder.add(LegacyItems.RABBIT_HIDE_1_8, "Rabbit Hide");
        builder.add(LegacyItems.RABBIT_STEW_1_8, "Rabbit Stew");
        builder.add(LegacyBlocks.LIGHT_GRAY_WOOL_B1_2, "Light Gray Wool");
        builder.add(LegacyBlocks.GRAY_WOOL_B1_2, "Gray Wool");
        builder.add(LegacyBlocks.BLACK_WOOL_B1_2, "Black Wool");
        builder.add(LegacyBlocks.BROWN_WOOL_B1_2, "Brown Wool");
        builder.add(LegacyBlocks.RED_WOOL_B1_2, "Red Wool");
        builder.add(LegacyBlocks.ORANGE_WOOL_B1_2, "Orange Wool");
        builder.add(LegacyBlocks.YELLOW_WOOL_B1_2, "Yellow Wool");
        builder.add(LegacyBlocks.LIME_WOOL_B1_2, "Lime Wool");
        builder.add(LegacyBlocks.GREEN_WOOL_B1_2, "Green Wool");
        builder.add(LegacyBlocks.CYAN_WOOL_B1_2, "Cyan Wool");
        builder.add(LegacyBlocks.LIGHT_BLUE_WOOL_B1_2, "Light Blue Wool");
        builder.add(LegacyBlocks.BLUE_WOOL_B1_2, "Blue Wool");
        builder.add(LegacyBlocks.PURPLE_WOOL_B1_2, "Purple Wool");
        builder.add(LegacyBlocks.MAGENTA_WOOL_B1_2, "Magenta Wool");
        builder.add(LegacyBlocks.PINK_WOOL_B1_2, "Pink Wool");
        builder.add(LegacyBlocks.LIGHT_GRAY_WOOL_1_2_4, "Light Gray Wool");
        builder.add(LegacyBlocks.GRAY_WOOL_1_2_4, "Gray Wool");
        builder.add(LegacyBlocks.BLACK_WOOL_1_2_4, "Black Wool");
        builder.add(LegacyBlocks.BROWN_WOOL_1_2_4, "Brown Wool");
        builder.add(LegacyBlocks.RED_WOOL_1_2_4, "Red Wool");
        builder.add(LegacyBlocks.ORANGE_WOOL_1_2_4, "Orange Wool");
        builder.add(LegacyBlocks.YELLOW_WOOL_1_2_4, "Yellow Wool");
        builder.add(LegacyBlocks.LIME_WOOL_1_2_4, "Lime Wool");
        builder.add(LegacyBlocks.GREEN_WOOL_1_2_4, "Green Wool");
        builder.add(LegacyBlocks.CYAN_WOOL_1_2_4, "Cyan Wool");
        builder.add(LegacyBlocks.LIGHT_BLUE_WOOL_1_2_4, "Light Blue Wool");
        builder.add(LegacyBlocks.BLUE_WOOL_1_2_4, "Blue Wool");
        builder.add(LegacyBlocks.PURPLE_WOOL_1_2_4, "Purple Wool");
        builder.add(LegacyBlocks.MAGENTA_WOOL_1_2_4, "Magenta Wool");
        builder.add(LegacyBlocks.PINK_WOOL_1_2_4, "Pink Wool");
        builder.add((class_2248)LegacyBlocks.CAKE_B1_2, "Cake");
        builder.add((class_2248)LegacyBlocks.LAPIS_ORE_B1_2, "Lapis Lazuli Ore");
        builder.add((class_2248)LegacyBlocks.LAPIS_ORE_1_14, "Lapis Lazuli Ore");
        builder.add(LegacyBlocks.LAPIS_BLOCK_B1_2, "Block of Lapis Lazuli");
        builder.add(LegacyBlocks.LAPIS_BLOCK_1_6, "Block of Lapis Lazuli");
        builder.add((class_2248)LegacyBlocks.NOTE_BLOCK_B1_2, "Note Block");
        builder.add(LegacyBlocks.SANDSTONE_B1_2, "Sandstone");
        builder.add(LegacyBlocks.SANDSTONE_1_2_4, "Sandstone");
        builder.add(LegacyBlocks.BIRCH_LOG_B1_2, "Birch Log");
        builder.add(LegacyBlocks.BIRCH_LOG_1_7, "Birch Log");
        builder.add((class_2248)LegacyBlocks.BIRCH_LEAVES_B1_2, "Birch Leaves");
        builder.add(LegacyBlocks.SPRUCE_LOG_B1_2, "Spruce Log");
        builder.add(LegacyBlocks.SPRUCE_LOG_1_7, "Spruce Log");
        builder.add((class_2248)LegacyBlocks.SPRUCE_LEAVES_B1_2, "Spruce Leaves");
        builder.add((class_2248)LegacyBlocks.CRYING_OBSIDIAN_B1_3, "Crying Obsidian");
        builder.add((class_2248)LegacyBlocks.COBBLESTONE_SLAB_RD20090515, "\u00a74Cobblestone Slab");
        builder.add((class_2248)LegacyBlocks.COBBLESTONE_SLAB_B1_3, "Cobblestone Slab");
        builder.add((class_2248)LegacyBlocks.COBBLESTONE_SLAB_B1_7, "Cobblestone Slab");
        builder.add((class_2248)LegacyBlocks.WOODEN_SLAB_RD20090515, "\u00a74Wooden Slab");
        builder.add((class_2248)LegacyBlocks.WOODEN_SLAB_RD161348, "\u00a74Wooden Slab");
        builder.add((class_2248)LegacyBlocks.WOODEN_SLAB_C0_0_14A, "\u00a74Wooden Slab");
        builder.add((class_2248)LegacyBlocks.WOODEN_SLAB_B1_3, "Wooden Slab");
        builder.add((class_2248)LegacyBlocks.WOODEN_SLAB_B1_9PRE5, "Wooden Slab");
        builder.add((class_2248)LegacyBlocks.SANDSTONE_SLAB_B1_3, "Sandstone Slab");
        builder.add((class_2248)LegacyBlocks.SANDSTONE_SLAB_1_2_4, "Sandstone Slab");
        builder.add(LegacyBlocks.SMOOTH_STONE_B1_3, "Smooth Stone");
        builder.add((class_2248)LegacyBlocks.BIRCH_SAPLING_B1_5, "Birch Sapling");
        builder.add((class_2248)LegacyBlocks.SPRUCE_SAPLING_B1_5, "Spruce Sapling");
        builder.add((class_2248)LegacyBlocks.POWERED_RAIL_B1_5, "Powered Rail");
        builder.add((class_2248)LegacyBlocks.DETECTOR_RAIL_B1_5, "Detector Rail");
        builder.add((class_2248)LegacyBlocks.COBWEB_B1_5, "Cobweb");
        builder.add((class_2248)LegacyBlocks.DEAD_BUSH_B1_6, "Dead Bush");
        builder.add((class_2248)LegacyBlocks.SHRUB_B1_6, "Shrub");
        builder.add((class_2248)LegacyBlocks.SHORT_GRASS_B1_6, "Short Grass");
        builder.add((class_2248)LegacyBlocks.FERN_B1_6, "Fern");
        builder.add((class_2248)LegacyBlocks.TRAPDOOR_B1_6, "Wooden Trapdoor");
        builder.add(LegacyBlocks.STONE_BRICKS_B1_8, "Stone Bricks");
        builder.add(LegacyBlocks.CRACKED_STONE_BRICKS_B1_8, "Cracked Stone Bricks");
        builder.add(LegacyBlocks.MOSSY_STONE_BRICKS_B1_8, "Mossy Stone Bricks");
        builder.add((class_2248)LegacyBlocks.INFESTED_COBBLESTONE_RD20090515, "\u00a74Infested Cobblestone");
        builder.add((class_2248)LegacyBlocks.INFESTED_COBBLESTONE_C0_0_14A, "\u00a74Infested Cobblestone");
        builder.add((class_2248)LegacyBlocks.INFESTED_COBBLESTONE_B1_8, "Infested Cobblestone");
        builder.add((class_2248)LegacyBlocks.INFESTED_STONE_BRICKS_B1_8, "Infested Stone Bricks");
        builder.add((class_2248)LegacyBlocks.BRICK_SLAB_C0_26ST, "\u00a74Brick Slab");
        builder.add((class_2248)LegacyBlocks.BRICK_SLAB_B1_8, "Brick Slab");
        builder.add((class_2248)LegacyBlocks.STONE_BRICK_SLAB_B1_8, "Stone Brick Slab");
        builder.add((class_2248)LegacyBlocks.BRICK_STAIRS_C0_26ST, "\u00a74Brick Stairs");
        builder.add((class_2248)LegacyBlocks.BRICK_STAIRS_B1_8, "Brick Stairs");
        builder.add((class_2248)LegacyBlocks.STONE_BRICK_STAIRS_B1_8, "Stone Brick Stairs");
        builder.add((class_2248)LegacyBlocks.GLASS_PANE_B1_8, "Glass Pane");
        builder.add((class_2248)LegacyBlocks.WOODEN_FENCE_GATE_RD20090515, "\u00a74Wooden Fence Gate");
        builder.add((class_2248)LegacyBlocks.WOODEN_FENCE_GATE_RD161348, "\u00a74Wooden Fence Gate");
        builder.add((class_2248)LegacyBlocks.WOODEN_FENCE_GATE_C0_0_14A, "\u00a74Wooden Fence Gate");
        builder.add((class_2248)LegacyBlocks.WOODEN_FENCE_GATE_B1_8, "Wooden Fence Gate");
        builder.add((class_2248)LegacyBlocks.WOODEN_FENCE_GATE_B1_9PRE5, "Wooden Fence Gate");
        builder.add((class_2248)LegacyBlocks.VINES_B1_8, "Vines");
        builder.add((class_2248)LegacyBlocks.MUSHROOM_STEM_B1_8, "Mushroom Stem");
        builder.add((class_2248)LegacyBlocks.RED_MUSHROOM_BLOCK_B1_8, "Red Mushroom Block");
        builder.add((class_2248)LegacyBlocks.BROWN_MUSHROOM_BLOCK_B1_8, "Brown Mushroom Block");
        builder.add(LegacyBlocks.MELON_BLOCK_B1_8, "Melon Block");
        builder.add(LegacyBlocks.NETHER_BRICKS_B1_9PRE, "Nether Bricks");
        builder.add((class_2248)LegacyBlocks.NETHER_BRICK_STAIRS_B1_9PRE, "Nether Brick Stairs");
        builder.add((class_2248)LegacyBlocks.NETHER_BRICK_FENCE_B1_9PRE, "Nether Brick Fence");
        builder.add((class_2248)LegacyBlocks.LILY_PAD_B1_9PRE, "Lily Pad");
        builder.add(LegacyBlocks.ENDSTONE_B1_9PRE4, "Endstone");
        builder.add(LegacyBlocks.JUNGLE_LOG_1_2, "Jungle Log");
        builder.add(LegacyBlocks.JUNGLE_LOG_1_7, "Jungle Log");
        builder.add((class_2248)LegacyBlocks.JUNGLE_LEAVES_1_2, "Jungle Leaves");
        builder.add((class_2248)LegacyBlocks.JUNGLE_SAPLING_1_2, "Jungle Sapling");
        builder.add((class_2248)LegacyBlocks.REDSTONE_LAMP_1_2, "Redstone Lamp");
        builder.add(LegacyBlocks.CHISELED_STONE_BRICKS_1_2, "Chiseled Stone Bricks");
        builder.add(LegacyBlocks.BIRCH_PLANKS_1_2_4, "Birch Planks");
        builder.add(LegacyBlocks.SPRUCE_PLANKS_1_2_4, "Spruce Planks");
        builder.add(LegacyBlocks.JUNGLE_PLANKS_1_2_4, "Jungle Planks");
        builder.add(LegacyBlocks.CUT_SANDSTONE_1_2_4, "Cut Sandstone");
        builder.add(LegacyBlocks.CHISELED_SANDSTONE_1_2_4, "Chiseled Sandstone");
        builder.add((class_2248)LegacyBlocks.BIRCH_SLAB_1_3, "Birch Slab");
        builder.add((class_2248)LegacyBlocks.SPRUCE_SLAB_1_3, "Spruce Slab");
        builder.add((class_2248)LegacyBlocks.JUNGLE_SLAB_1_3, "Jungle Slab");
        builder.add((class_2248)LegacyBlocks.COCOA_1_3, "Cocoa");
        builder.add((class_2248)LegacyBlocks.RUBY_ORE, "Ruby Ore");
        builder.add((class_2248)LegacyBlocks.EMERALD_ORE_1_3, "Emerald Ore");
        builder.add((class_2248)LegacyBlocks.EMERALD_ORE_1_14, "Emerald Ore");
        builder.add((class_2248)LegacyBlocks.SANDSTONE_STAIRS_B1_2, "\u00a74Sandstone Stairs");
        builder.add((class_2248)LegacyBlocks.SANDSTONE_STAIRS_1_3, "Sandstone Stairs");
        builder.add(LegacyBlocks.EMERALD_BLOCK_1_3, "Emerald Block");
        builder.add((class_2248)LegacyBlocks.BIRCH_STAIRS_1_3, "Birch Stairs");
        builder.add((class_2248)LegacyBlocks.SPRUCE_STAIRS_1_3, "Spruce Stairs");
        builder.add((class_2248)LegacyBlocks.JUNGLE_STAIRS_1_3, "Jungle Stairs");
        builder.add(LegacyBlocks.OAK_WOOD_1_3, "Oak Wood");
        builder.add(LegacyBlocks.BIRCH_WOOD_1_3, "Birch Wood");
        builder.add(LegacyBlocks.SPRUCE_WOOD_1_3, "Spruce Wood");
        builder.add(LegacyBlocks.JUNGLE_WOOD_1_3, "Jungle Wood");
        builder.add(LegacyBlocks.WOODEN_BUTTON_RD20090515, "\u00a74Wooden Button");
        builder.add(LegacyBlocks.WOODEN_BUTTON_RD161348, "\u00a74Wooden Button");
        builder.add(LegacyBlocks.WOODEN_BUTTON_C0_0_14A, "\u00a74Wooden Button");
        builder.add(LegacyBlocks.WOODEN_BUTTON_C0_0_15A, "\u00a74Wooden Button");
        builder.add(LegacyBlocks.WOODEN_BUTTON_1_4, "Wooden Button");
        builder.add((class_2248)LegacyBlocks.COBBLESTONE_WALL_RD20090515, "\u00a74Cobblestone Wall");
        builder.add((class_2248)LegacyBlocks.COBBLESTONE_WALL_C0_0_14A, "\u00a74Cobblestone Wall");
        builder.add((class_2248)LegacyBlocks.COBBLESTONE_WALL_1_4, "Cobblestone Wall");
        builder.add((class_2248)LegacyBlocks.NETHER_BRICK_SLAB_1_4_6, "Nether Brick Slab");
        builder.add((class_2248)LegacyBlocks.QUARTZ_ORE_1_5, "Nether Quartz Ore");
        builder.add((class_2248)LegacyBlocks.REDSTONE_BLOCK_1_5, "Redstone Block");
        builder.add((class_2248)LegacyBlocks.ACTIVATOR_RAIL_1_5, "Activator Rail");
        builder.add(LegacyBlocks.QUARTZ_BLOCK_1_5, "Quartz Block");
        builder.add(LegacyBlocks.CHISELED_QUARTZ_BLOCK_1_5, "Chiseled Quartz Block");
        builder.add((class_2248)LegacyBlocks.QUARTZ_PILLAR_1_5, "Quartz Pillar");
        builder.add((class_2248)LegacyBlocks.QUARTZ_SLAB_1_5, "Quartz Slab");
        builder.add((class_2248)LegacyBlocks.QUARTZ_STAIRS_1_5, "Quartz Stairs");
        builder.add(LegacyBlocks.SMOOTH_SANDSTONE_1_5, "Smooth Sandstone");
        builder.add(LegacyBlocks.SMOOTH_QUARTZ_1_5, "Smooth Quartz");
        builder.add((class_2248)LegacyBlocks.WHITE_CLOTH_CARPET, "White Cloth Carpet");
        builder.add((class_2248)LegacyBlocks.LIGHT_GRAY_CLOTH_CARPET_C0_0_20A, "Light Gray Cloth Carpet");
        builder.add((class_2248)LegacyBlocks.LIGHT_GRAY_CLOTH_CARPET_C0_28A, "Light Gray Cloth Carpet");
        builder.add((class_2248)LegacyBlocks.DARK_GRAY_CLOTH_CARPET_C0_0_20A, "Dark Gray Cloth Carpet");
        builder.add((class_2248)LegacyBlocks.DARK_GRAY_CLOTH_CARPET_C0_28A, "Dark Gray Cloth Carpet");
        builder.add((class_2248)LegacyBlocks.RED_CLOTH_CARPET, "Red Cloth Carpet");
        builder.add((class_2248)LegacyBlocks.ORANGE_CLOTH_CARPET, "Orange Cloth Carpet");
        builder.add((class_2248)LegacyBlocks.YELLOW_CLOTH_CARPET, "Yellow Cloth Carpet");
        builder.add((class_2248)LegacyBlocks.CHARTREUSE_CLOTH_CARPET, "Chartreuse Cloth Carpet");
        builder.add((class_2248)LegacyBlocks.SPRING_GREEN_CLOTH_CARPET, "Spring Green Cloth Carpet");
        builder.add((class_2248)LegacyBlocks.CYAN_CLOTH_CARPET, "Cyan Cloth Carpet");
        builder.add((class_2248)LegacyBlocks.CAPRI_CLOTH_CARPET, "Capri Cloth Carpet");
        builder.add((class_2248)LegacyBlocks.ULTRAMARINE_CLOTH_CARPET, "Ultramarine Cloth Carpet");
        builder.add((class_2248)LegacyBlocks.VIOLET_CLOTH_CARPET, "Violet Cloth Carpet");
        builder.add((class_2248)LegacyBlocks.PURPLE_CLOTH_CARPET, "Purple Cloth Carpet");
        builder.add((class_2248)LegacyBlocks.MAGENTA_CLOTH_CARPET, "Magenta Cloth Carpet");
        builder.add((class_2248)LegacyBlocks.ROSE_CLOTH_CARPET, "Rose Cloth Carpet");
        builder.add((class_2248)LegacyBlocks.GRAY_CARPET_B1_2, "Gray Carpet");
        builder.add((class_2248)LegacyBlocks.BLACK_CARPET_B1_2, "Black Carpet");
        builder.add((class_2248)LegacyBlocks.BROWN_CARPET_B1_2, "Brown Carpet");
        builder.add((class_2248)LegacyBlocks.RED_CARPET_B1_2, "Red Carpet");
        builder.add((class_2248)LegacyBlocks.ORANGE_CARPET_B1_2, "Orange Carpet");
        builder.add((class_2248)LegacyBlocks.YELLOW_CARPET_B1_2, "Yellow Carpet");
        builder.add((class_2248)LegacyBlocks.LIME_CARPET_B1_2, "Lime Carpet");
        builder.add((class_2248)LegacyBlocks.GREEN_CARPET_B1_2, "Green Carpet");
        builder.add((class_2248)LegacyBlocks.CYAN_CARPET_B1_2, "Cyan Carpet");
        builder.add((class_2248)LegacyBlocks.LIGHT_BLUE_CARPET_B1_2, "Light Blue Carpet");
        builder.add((class_2248)LegacyBlocks.BLUE_CARPET_B1_2, "Blue Carpet");
        builder.add((class_2248)LegacyBlocks.PURPLE_CARPET_B1_2, "Purple Carpet");
        builder.add((class_2248)LegacyBlocks.MAGENTA_CARPET_B1_2, "Magenta Carpet");
        builder.add((class_2248)LegacyBlocks.PINK_CARPET_B1_2, "Pink Carpet");
        builder.add((class_2248)LegacyBlocks.LIGHT_GRAY_CARPET_1_2_4, "Light Gray Carpet");
        builder.add((class_2248)LegacyBlocks.GRAY_CARPET_1_2_4, "Gray Carpet");
        builder.add((class_2248)LegacyBlocks.BLACK_CARPET_1_2_4, "Black Carpet");
        builder.add((class_2248)LegacyBlocks.BROWN_CARPET_1_2_4, "Brown Carpet");
        builder.add((class_2248)LegacyBlocks.RED_CARPET_1_2_4, "Red Carpet");
        builder.add((class_2248)LegacyBlocks.ORANGE_CARPET_1_2_4, "Orange Carpet");
        builder.add((class_2248)LegacyBlocks.YELLOW_CARPET_1_2_4, "Yellow Carpet");
        builder.add((class_2248)LegacyBlocks.LIME_CARPET_1_2_4, "Lime Carpet");
        builder.add((class_2248)LegacyBlocks.GREEN_CARPET_1_2_4, "Green Carpet");
        builder.add((class_2248)LegacyBlocks.CYAN_CARPET_1_2_4, "Cyan Carpet");
        builder.add((class_2248)LegacyBlocks.LIGHT_BLUE_CARPET_1_2_4, "Light Blue Carpet");
        builder.add((class_2248)LegacyBlocks.BLUE_CARPET_1_2_4, "Blue Carpet");
        builder.add((class_2248)LegacyBlocks.PURPLE_CARPET_1_2_4, "Purple Carpet");
        builder.add((class_2248)LegacyBlocks.MAGENTA_CARPET_1_2_4, "Magenta Carpet");
        builder.add((class_2248)LegacyBlocks.PINK_CARPET_1_2_4, "Pink Carpet");
        builder.add((class_2248)LegacyBlocks.HAY_BALE_1_6, "Hay Bale");
        builder.add(LegacyBlocks.TERRACOTTA_1_6, "Terracotta");
        builder.add(LegacyBlocks.COAL_BLOCK_1_6, "Block of Coal");
        builder.add((class_2248)LegacyBlocks.ALLIUM_1_7, "Allium");
        builder.add((class_2248)LegacyBlocks.AZURE_BLUET_1_7, "Azure Bluet");
        builder.add((class_2248)LegacyBlocks.BLUE_ORCHID_1_7, "Blue Orchid");
        builder.add((class_2248)LegacyBlocks.LILAC_1_7, "Lilac");
        builder.add((class_2248)LegacyBlocks.PEONY_1_7, "Peony");
        builder.add((class_2248)LegacyBlocks.ROSE_BUSH_1_7, "Rose Bush");
        builder.add((class_2248)LegacyBlocks.SUNFLOWER_1_7, "Sunflower");
        builder.add((class_2248)LegacyBlocks.OXEYE_DAISY_1_7, "Oxeye Daisy");
        builder.add((class_2248)LegacyBlocks.RED_TULIP_1_7, "Red Tulip");
        builder.add((class_2248)LegacyBlocks.ORANGE_TULIP_1_7, "Orange Tulip");
        builder.add((class_2248)LegacyBlocks.WHITE_TULIP_1_7, "White Tulip");
        builder.add((class_2248)LegacyBlocks.PINK_TULIP_1_7, "Pink Tulip");
        builder.add((class_2248)LegacyBlocks.LARGE_FERN_1_7, "Large Fern");
        builder.add((class_2248)LegacyBlocks.TALL_GRASS_1_7, "Tall Grass");
        builder.add(LegacyBlocks.PACKED_ICE_1_7, "Packed Ice");
        builder.add((class_2248)LegacyBlocks.INFESTED_CRACKED_STONE_BRICKS_1_7, "Infested Cracked Stone Bricks");
        builder.add((class_2248)LegacyBlocks.INFESTED_MOSSY_STONE_BRICKS_1_7, "Infested Mossy Stone Bricks");
        builder.add((class_2248)LegacyBlocks.INFESTED_CHISELED_STONE_BRICKS_1_7, "Infested Chiseled Stone Bricks");
        builder.add((class_2248)LegacyBlocks.RED_SAND_1_7, "Red Sand");
        builder.add(LegacyBlocks.WHITE_STAINED_GLASS_1_7, "White Stained Glass");
        builder.add(LegacyBlocks.ORANGE_STAINED_GLASS_1_7, "Orange Stained Glass");
        builder.add(LegacyBlocks.MAGENTA_STAINED_GLASS_1_7, "Magenta Stained Glass");
        builder.add(LegacyBlocks.LIGHT_BLUE_STAINED_GLASS_1_7, "Light Blue Stained Glass");
        builder.add(LegacyBlocks.YELLOW_STAINED_GLASS_1_7, "Yellow Stained Glass");
        builder.add(LegacyBlocks.LIME_STAINED_GLASS_1_7, "Lime Stained Glass");
        builder.add(LegacyBlocks.PINK_STAINED_GLASS_1_7, "Pink Stained Glass");
        builder.add(LegacyBlocks.GRAY_STAINED_GLASS_1_7, "Gray Stained Glass");
        builder.add(LegacyBlocks.LIGHT_GRAY_STAINED_GLASS_1_7, "Light Gray Stained Glass");
        builder.add(LegacyBlocks.CYAN_STAINED_GLASS_1_7, "Cyan Stained Glass");
        builder.add(LegacyBlocks.PURPLE_STAINED_GLASS_1_7, "Purple Stained Glass");
        builder.add(LegacyBlocks.BLUE_STAINED_GLASS_1_7, "Blue Stained Glass");
        builder.add(LegacyBlocks.BROWN_STAINED_GLASS_1_7, "Brown Stained Glass");
        builder.add(LegacyBlocks.GREEN_STAINED_GLASS_1_7, "Green Stained Glass");
        builder.add(LegacyBlocks.RED_STAINED_GLASS_1_7, "Red Stained Glass");
        builder.add(LegacyBlocks.BLACK_STAINED_GLASS_1_7, "Black Stained Glass");
        builder.add(LegacyBlocks.WHITE_STAINED_GLASS_PANE_1_7, "White Stained Glass Pane");
        builder.add(LegacyBlocks.ORANGE_STAINED_GLASS_PANE_1_7, "Orange Stained Glass Pane");
        builder.add(LegacyBlocks.MAGENTA_STAINED_GLASS_PANE_1_7, "Magenta Stained Glass Pane");
        builder.add(LegacyBlocks.LIGHT_BLUE_STAINED_GLASS_PANE_1_7, "Light Blue Stained Glass Pane");
        builder.add(LegacyBlocks.YELLOW_STAINED_GLASS_PANE_1_7, "Yellow Stained Glass Pane");
        builder.add(LegacyBlocks.LIME_STAINED_GLASS_PANE_1_7, "Lime Stained Glass Pane");
        builder.add(LegacyBlocks.PINK_STAINED_GLASS_PANE_1_7, "Pink Stained Glass Pane");
        builder.add(LegacyBlocks.GRAY_STAINED_GLASS_PANE_1_7, "Gray Stained Glass Pane");
        builder.add(LegacyBlocks.LIGHT_GRAY_STAINED_GLASS_PANE_1_7, "Light Gray Stained Glass Pane");
        builder.add(LegacyBlocks.CYAN_STAINED_GLASS_PANE_1_7, "Cyan Stained Glass Pane");
        builder.add(LegacyBlocks.PURPLE_STAINED_GLASS_PANE_1_7, "Purple Stained Glass Pane");
        builder.add(LegacyBlocks.BLUE_STAINED_GLASS_PANE_1_7, "Blue Stained Glass Pane");
        builder.add(LegacyBlocks.BROWN_STAINED_GLASS_PANE_1_7, "Brown Stained Glass Pane");
        builder.add(LegacyBlocks.GREEN_STAINED_GLASS_PANE_1_7, "Green Stained Glass Pane");
        builder.add(LegacyBlocks.RED_STAINED_GLASS_PANE_1_7, "Red Stained Glass Pane");
        builder.add(LegacyBlocks.BLACK_STAINED_GLASS_PANE_1_7, "Black Stained Glass Pane");
        builder.add(LegacyBlocks.ACACIA_LOG_1_7, "Acacia Log");
        builder.add(LegacyBlocks.ACACIA_WOOD_1_7, "Acacia Wood");
        builder.add((class_2248)LegacyBlocks.ACACIA_LEAVES_1_7, "Acacia Leaves");
        builder.add((class_2248)LegacyBlocks.ACACIA_SAPLING_1_7, "Acacia Sapling");
        builder.add(LegacyBlocks.DARK_OAK_LOG_1_7, "Dark Oak Log");
        builder.add(LegacyBlocks.DARK_OAK_WOOD_1_7, "Dark Oak Wood");
        builder.add((class_2248)LegacyBlocks.DARK_OAK_LEAVES_1_7, "Dark Oak Leaves");
        builder.add((class_2248)LegacyBlocks.DARK_OAK_SAPLING_1_7, "Dark Oak Sapling");
        builder.add(LegacyBlocks.ACACIA_PLANKS_1_7, "Acacia Planks");
        builder.add((class_2248)LegacyBlocks.ACACIA_STAIRS_1_7, "Acacia Stairs");
        builder.add((class_2248)LegacyBlocks.ACACIA_SLAB_1_7, "Acacia Slab");
        builder.add(LegacyBlocks.DARK_OAK_PLANKS_1_7, "Dark Oak Planks");
        builder.add((class_2248)LegacyBlocks.DARK_OAK_STAIRS_1_7, "Dark Oak Stairs");
        builder.add((class_2248)LegacyBlocks.DARK_OAK_SLAB_1_7, "Dark Oak Slab");
        builder.add(LegacyBlocks.GRANITE_1_8, "Granite");
        builder.add(LegacyBlocks.POLISHED_GRANITE_1_8, "Polished Granite");
        builder.add(LegacyBlocks.DIORITE_1_8, "Diorite");
        builder.add(LegacyBlocks.POLISHED_DIORITE_1_8, "Polished Diorite");
        builder.add(LegacyBlocks.ANDESITE_1_8, "Andesite");
        builder.add(LegacyBlocks.POLISHED_ANDESITE_1_8, "Polished Andesite");
        builder.add((class_2248)LegacyBlocks.SLIME_BLOCK_1_8, "Slime Block");
        builder.add(LegacyBlocks.PRISMARINE_1_8, "Prismarine");
        builder.add(LegacyBlocks.PRISMARINE_BRICKS_1_8, "Prismarine Bricks");
        builder.add(LegacyBlocks.DARK_PRISMARINE_1_8, "Dark Prismarine");
        builder.add(LegacyBlocks.RED_SANDSTONE_1_8, "Red Sandstone");
        builder.add(LegacyBlocks.CUT_RED_SANDSTONE_1_8, "Cut Red Sandstone");
        builder.add(LegacyBlocks.CHISELED_RED_SANDSTONE_1_8, "Chiseled Red Sandstone");
        builder.add(LegacyBlocks.SMOOTH_RED_SANDSTONE_1_8, "Smooth Red Sandstone");
        builder.add((class_2248)LegacyBlocks.RED_SANDSTONE_SLAB_1_8, "Red Sandstone Slab");
        builder.add((class_2248)LegacyBlocks.RED_SANDSTONE_STAIRS_1_8, "Red Sandstone Stairs");
        builder.add((class_2248)LegacyBlocks.BIRCH_FENCE_1_8, "Birch Fence");
        builder.add((class_2248)LegacyBlocks.SPRUCE_FENCE_1_8, "Spruce Fence");
        builder.add((class_2248)LegacyBlocks.JUNGLE_FENCE_1_8, "Jungle Fence");
        builder.add((class_2248)LegacyBlocks.ACACIA_FENCE_1_8, "Acacia Fence");
        builder.add((class_2248)LegacyBlocks.DARK_OAK_FENCE_1_8, "Dark Oak Fence");
        builder.add((class_2248)LegacyBlocks.BIRCH_FENCE_GATE_1_8, "Birch Fence Gate");
        builder.add((class_2248)LegacyBlocks.SPRUCE_FENCE_GATE_1_8, "Spruce Fence Gate");
        builder.add((class_2248)LegacyBlocks.JUNGLE_FENCE_GATE_1_8, "Jungle Fence Gate");
        builder.add((class_2248)LegacyBlocks.ACACIA_FENCE_GATE_1_8, "Acacia Fence Gate");
        builder.add((class_2248)LegacyBlocks.DARK_OAK_FENCE_GATE_1_8, "Dark Oak Fence Gate");
        builder.add((class_2248)LegacyBlocks.END_ROD_1_9, "End Rod");
        builder.add(LegacyBlocks.ENDSTONE_BRICKS_1_9, "Endstone Bricks");
        builder.add(LegacyBlocks.PURPUR_BLOCK_1_9, "Purpur Block");
        builder.add((class_2248)LegacyBlocks.PURPUR_PILLAR_1_9, "Purpur Pillar");
        builder.add((class_2248)LegacyBlocks.PURPUR_SLAB_1_9, "Purpur Slab");
        builder.add((class_2248)LegacyBlocks.PURPUR_STAIRS_1_9, "Purpur Stairs");
        builder.add((class_2248)LegacyBlocks.BONE_BLOCK_1_10, "Bone Block");
        builder.add((class_2248)LegacyBlocks.MAGMA_BLOCK_1_10, "Magma Block");
        builder.add(LegacyBlocks.NETHER_WART_BLOCK_1_10, "Nether Wart Block");
        builder.add(LegacyBlocks.NETHER_WART_BLOCK_1_14, "Nether Wart Block");
        builder.add(LegacyBlocks.RED_NETHER_BRICKS_1_10, "Red Nether Bricks");
        builder.add(LegacyBlocks.BIRCH_BUTTON_1_13, "Birch Button");
        builder.add(LegacyBlocks.SPRUCE_BUTTON_1_13, "Spruce Button");
        builder.add(LegacyBlocks.JUNGLE_BUTTON_1_13, "Jungle Button");
        builder.add(LegacyBlocks.ACACIA_BUTTON_1_13, "Acacia Button");
        builder.add(LegacyBlocks.DARK_OAK_BUTTON_1_13, "Dark Oak Button");
        builder.add((class_2248)LegacyBlocks.BIRCH_PRESSURE_PLATE_1_13, "Birch Pressure Plate");
        builder.add((class_2248)LegacyBlocks.SPRUCE_PRESSURE_PLATE_1_13, "Spruce Pressure Plate");
        builder.add((class_2248)LegacyBlocks.JUNGLE_PRESSURE_PLATE_1_13, "Jungle Pressure Plate");
        builder.add((class_2248)LegacyBlocks.ACACIA_PRESSURE_PLATE_1_13, "Acacia Pressure Plate");
        builder.add((class_2248)LegacyBlocks.DARK_OAK_PRESSURE_PLATE_1_13, "Dark Oak Pressure Plate");
        builder.add((class_2248)LegacyBlocks.PRISMARINE_SLAB_1_13, "Prismarine Slab");
        builder.add((class_2248)LegacyBlocks.PRISMARINE_STAIRS_1_13, "Prismarine Stairs");
        builder.add(ModItems.END_DIAMOND_CHERRY, "End Diamond Cherry");
        builder.add(ModItems.ENCHANTED_END_DIAMOND_CHERRY, "Enchanted End Diamond Cherry");
        builder.add((class_1792)ModItems.SPAWNER_MINECART, "Spawner Minecart");
        builder.add(FutureBlocks.PALE_OAK_LOG, "Pale Oak Log");
        builder.add(FutureBlocks.STRIPPED_PALE_OAK_LOG, "Stripped Pale Oak Log");
        builder.add(FutureBlocks.PALE_OAK_WOOD, "Pale Oak Wood");
        builder.add(FutureBlocks.STRIPPED_PALE_OAK_WOOD, "Stripped Pale Oak Wood");
        builder.add((class_2248)FutureBlocks.PALE_OAK_LEAVES, "Pale Oak Leaves");
        builder.add((class_2248)FutureBlocks.PALE_OAK_SAPLING, "Pale Oak Sapling");
        builder.add(FutureBlocks.PALE_OAK_PLANKS, "Pale Oak Planks");
        builder.add((class_2248)FutureBlocks.PALE_OAK_DOOR, "Pale Oak Door");
        builder.add((class_2248)FutureBlocks.PALE_OAK_FENCE, "Pale Oak Fence");
        builder.add((class_2248)FutureBlocks.PALE_OAK_FENCE_GATE, "Pale Oak Fence Gate");
        builder.add((class_2248)FutureBlocks.PALE_OAK_STAIRS, "Pale Oak Stairs");
        builder.add((class_2248)FutureBlocks.PALE_OAK_SLAB, "Pale Oak Slab");
        builder.add((class_2248)FutureBlocks.PALE_OAK_PRESSURE_PLATE, "Pale Oak Pressure Plate");
        builder.add(FutureBlocks.PALE_OAK_BUTTON, "Pale Oak Button");
        builder.add((class_2248)FutureBlocks.PALE_OAK_TRAPDOOR, "Pale Oak Trapdoor");
        builder.add((class_2248)FutureBlocks.PALE_OAK_SIGN, "Pale Oak Sign");
        builder.add((class_2248)FutureBlocks.PALE_OAK_HANGING_SIGN, "Pale Oak Hanging Sign");
        builder.add(FutureItems.PALE_OAK_BOAT, "Pale Oak Boat");
        builder.add(FutureItems.PALE_OAK_CHEST_BOAT, "Pale Oak Chest Boat");
        builder.add((class_2248)FutureBlocks.PALE_MOSS, "Pale Moss");
        builder.add((class_2248)FutureBlocks.PALE_MOSS_CARPET, "Pale Moss Carpet");
        builder.add((class_2248)FutureBlocks.PALE_HANGING_MOSS, "Pale Hanging Moss");
        builder.add((class_2248)FutureBlocks.CLOSED_EYEBLOSSOM, "Closed Eyeblossom");
        builder.add((class_2248)FutureBlocks.OPEN_EYEBLOSSOM, "Open Eyeblossom");
        builder.add(FutureItems.RESIN_CLUMP, "Resin Clump");
        builder.add(FutureItems.RESIN_BRICK, "Resin Brick");
        builder.add(FutureBlocks.RESIN_BLOCK, "Resin Block");
        builder.add(FutureBlocks.RESIN_BRICKS, "Resin Bricks");
        builder.add((class_2248)FutureBlocks.RESIN_BRICK_STAIRS, "Resin Brick Stairs");
        builder.add((class_2248)FutureBlocks.RESIN_BRICK_SLAB, "Resin Brick Slab");
        builder.add((class_2248)FutureBlocks.RESIN_BRICK_WALL, "Resin Brick Wall");
        builder.add(FutureBlocks.CHISELED_RESIN_BRICKS, "Chiseled Resin Bricks");
        builder.add((class_2248)FutureBlocks.WILDFLOWERS, "Wildflowers");
        builder.add((class_2248)FutureBlocks.LEAF_LITTERS, "Leaf Litters");
        builder.add((class_2248)FutureBlocks.SHORT_DRY_GRASS, "Short Dry Grass");
        builder.add(ModItems.FUTURE_INGOT, "Future Ingot");
        builder.add((class_2248)ModBlocks.WOODCUTTER, "Woodcutter");
        builder.add(ModItemGroups.FUTURE_BLOCKS_AND_ITEMS, "\u00a72\u00a7lBlocktopia: \u00a7rFuture Blocks and Items");
        BlocktopiaLangProvider.addText(builder, WoodCutterBlock.TITLE, "Woodcutter");
        builder.add(ModItems.THERMORGANIC_FUEL, "Thermorganic Fuel");
    }

    private void addChairs(FabricLanguageProvider.TranslationBuilder builder, ChairBlock[] blocks, String baseName) {
        builder.add((class_2248)blocks[0], baseName);
        builder.add((class_2248)blocks[1], "White " + baseName);
        builder.add((class_2248)blocks[2], "Orange " + baseName);
        builder.add((class_2248)blocks[3], "Magenta " + baseName);
        builder.add((class_2248)blocks[4], "Light Blue " + baseName);
        builder.add((class_2248)blocks[5], "Yellow " + baseName);
        builder.add((class_2248)blocks[6], "Lime " + baseName);
        builder.add((class_2248)blocks[7], "Pink " + baseName);
        builder.add((class_2248)blocks[8], "Gray " + baseName);
        builder.add((class_2248)blocks[9], "Light Gray " + baseName);
        builder.add((class_2248)blocks[10], "Cyan " + baseName);
        builder.add((class_2248)blocks[11], "Purple " + baseName);
        builder.add((class_2248)blocks[12], "Blue " + baseName);
        builder.add((class_2248)blocks[13], "Brown " + baseName);
        builder.add((class_2248)blocks[14], "Green " + baseName);
        builder.add((class_2248)blocks[15], "Red " + baseName);
        builder.add((class_2248)blocks[16], "Black " + baseName);
        builder.add((class_2248)blocks[17], "Chartreuse " + baseName);
        builder.add((class_2248)blocks[18], "Spring Green " + baseName);
        builder.add((class_2248)blocks[19], "Capri " + baseName);
        builder.add((class_2248)blocks[20], "Ultramarine " + baseName);
        builder.add((class_2248)blocks[21], "Violet " + baseName);
        builder.add((class_2248)blocks[22], "Rose " + baseName);
    }

    private static void addText(@NotNull FabricLanguageProvider.TranslationBuilder builder, @NotNull class_2561 text, @NotNull String value) {
        class_7417 class_74172 = text.method_10851();
        if (class_74172 instanceof class_2588) {
            class_2588 translatableTextContent = (class_2588)class_74172;
            builder.add(translatableTextContent.method_11022(), value);
        } else {
            Blocktopia.LOGGER.warn("Failed to add translation for text: {}", (Object)text.getString());
        }
    }
}

