/*
 * Decompiled with CFR 0.152.
 */
package github.mcdatapack.blocktopia.worldgen.tree.trunkplacer;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import github.mcdatapack.blocktopia.worldgen.tree.trunkplacer.ModTrunkPlacerTypes;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_3746;
import net.minecraft.class_4643;
import net.minecraft.class_4647;
import net.minecraft.class_5141;
import net.minecraft.class_5142;
import net.minecraft.class_5819;

public class ExtremeTrunkPlacer
extends class_5141 {
    public static final MapCodec<ExtremeTrunkPlacer> CODEC = RecordCodecBuilder.mapCodec(instance -> ExtremeTrunkPlacer.method_28904((RecordCodecBuilder.Instance)instance).apply((Applicative)instance, ExtremeTrunkPlacer::new));
    private class_2338 highestLogPos;

    public ExtremeTrunkPlacer(int baseHeight, int heightRandA, int heightRandB) {
        super(baseHeight, heightRandA, heightRandB);
    }

    protected class_5142<?> method_28903() {
        return ModTrunkPlacerTypes.EXTREME_TRUNK_PLACER;
    }

    public List<class_4647.class_5208> method_26991(class_3746 world, BiConsumer<class_2338, class_2680> replacer, class_5819 random, int height, class_2338 startPos, class_4643 config) {
        class_2338 blockPos = startPos.method_10074();
        ExtremeTrunkPlacer.method_27400((class_3746)world, replacer, (class_5819)random, (class_2338)blockPos, (class_4643)config);
        class_2338.class_2339 mutable = new class_2338.class_2339();
        this.highestLogPos = startPos;
        int currentSize = 9;
        int shrinkInterval = height / 5;
        for (int y = 0; y < height; ++y) {
            int startX = -currentSize / 2;
            int startZ = -currentSize / 2;
            for (int dx = startX; dx < startX + currentSize; ++dx) {
                for (int dz = startZ; dz < startZ + currentSize; ++dz) {
                    class_2338 logPos = startPos.method_10069(dx, y, dz);
                    this.setLog(world, replacer, random, mutable, config, logPos);
                    if (logPos.method_10264() <= this.highestLogPos.method_10264()) continue;
                    this.highestLogPos = logPos;
                }
            }
            if (y % shrinkInterval == 0 && currentSize > 4) {
                --currentSize;
            }
            if (!(random.method_43057() < 0.3f)) continue;
            this.addThickBranch(world, replacer, random, mutable, config, startPos, y, currentSize, random);
        }
        return ImmutableList.of((Object)new class_4647.class_5208(this.highestLogPos.method_10084(), 0, true));
    }

    private void addThickBranch(class_3746 world, BiConsumer<class_2338, class_2680> replacer, class_5819 random, class_2338.class_2339 tmpPos, class_4643 config, class_2338 startPos, int y, int trunkSize, class_5819 rand) {
        int branchLength = random.method_43048(4) + 4;
        int directionX = rand.method_43056() ? 1 : -1;
        int directionZ = rand.method_43056() ? 1 : -1;
        for (int i = 0; i < branchLength; ++i) {
            int x = directionX * (trunkSize / 2 + i);
            int z = directionZ * (trunkSize / 2 + i);
            int yBranch = y + i / 2;
            class_2338 logPos = startPos.method_10069(x, yBranch, z);
            this.setLog(world, replacer, random, tmpPos, config, logPos);
            if (logPos.method_10264() > this.highestLogPos.method_10264()) {
                this.highestLogPos = logPos;
            }
            this.setLog(world, replacer, random, tmpPos, config, logPos.method_10069(1, 0, 0));
            this.setLog(world, replacer, random, tmpPos, config, logPos.method_10069(0, 0, 1));
            this.setLog(world, replacer, random, tmpPos, config, logPos.method_10069(-1, 0, 0));
            this.setLog(world, replacer, random, tmpPos, config, logPos.method_10069(0, 0, -1));
            this.setLog(world, replacer, random, tmpPos, config, logPos.method_10069(1, 0, 1));
            this.setLog(world, replacer, random, tmpPos, config, logPos.method_10069(-1, 0, -1));
            this.setLog(world, replacer, random, tmpPos, config, logPos.method_10069(1, 0, -1));
            this.setLog(world, replacer, random, tmpPos, config, logPos.method_10069(-1, 0, 1));
        }
    }

    private void setLog(class_3746 world, BiConsumer<class_2338, class_2680> replacer, class_5819 random, class_2338.class_2339 tmpPos, class_4643 config, class_2338 pos) {
        tmpPos.method_10101((class_2382)pos);
        this.method_27401(world, replacer, random, tmpPos, config);
    }

    public class_2338 getHighestLogPos() {
        return this.highestLogPos;
    }
}

