/*
 * Decompiled with CFR 0.152.
 */
package github.mcdatapack.blocktopia;

import github.mcdatapack.blocktopia.api.CustomPiglinTrading;
import github.mcdatapack.blocktopia.api.VillagerLevelTradeCountRegistry;
import github.mcdatapack.blocktopia.block.LegacyBlocks;
import github.mcdatapack.blocktopia.block.ModBlocks;
import github.mcdatapack.blocktopia.block.entity.ModBlockEntityTypes;
import github.mcdatapack.blocktopia.block.entity.custom.FluidTankBlockEntity;
import github.mcdatapack.blocktopia.block.entity.custom.SmallChestBlockEntity;
import github.mcdatapack.blocktopia.command.LocateMobCommand;
import github.mcdatapack.blocktopia.config.BlocktopiaConfig;
import github.mcdatapack.blocktopia.data.FluidInteractionRegistry;
import github.mcdatapack.blocktopia.enchantment.ModEnchantments;
import github.mcdatapack.blocktopia.entity.ModBoats;
import github.mcdatapack.blocktopia.entity.ModEntityTypes;
import github.mcdatapack.blocktopia.entity.custom.MonkeyEntity;
import github.mcdatapack.blocktopia.entity.custom.abstracts.AbstractBirdEntity;
import github.mcdatapack.blocktopia.fluid.ModFluids;
import github.mcdatapack.blocktopia.handlers.ItemGroupModifyEventHandler;
import github.mcdatapack.blocktopia.handlers.LootHandler;
import github.mcdatapack.blocktopia.handlers.TradeHandler;
import github.mcdatapack.blocktopia.item.LegacyItems;
import github.mcdatapack.blocktopia.item.ModItemGroups;
import github.mcdatapack.blocktopia.item.ModItems;
import github.mcdatapack.blocktopia.loottable.ModLootTables;
import github.mcdatapack.blocktopia.potion.ModPotions;
import github.mcdatapack.blocktopia.recipe.ModRecipes;
import github.mcdatapack.blocktopia.screen.ModScreenHandlerTypes;
import github.mcdatapack.blocktopia.villager.ModVillagers;
import github.mcdatapack.blocktopia.worldgen.biome.ModBiomeModifications;
import github.mcdatapack.blocktopia.worldgen.biome.ModBiomes;
import github.mcdatapack.blocktopia.worldgen.dimension.terrablender.BlocktopiaOverworldRegion;
import github.mcdatapack.blocktopia.worldgen.dimension.terrablender.BlocktopiaSurfaceRules;
import github.mcdatapack.blocktopia.worldgen.spawn.ModSpawnRestrictions;
import github.mcdatapack.blocktopia.worldgen.structure.ModProcessorLists;
import github.mcdatapack.blocktopia.worldgen.structure.ModStructurePools;
import github.mcdatapack.blocktopia.worldgen.structure.ModStructureSets;
import github.mcdatapack.blocktopia.worldgen.structure.ModStructures;
import github.mcdatapack.blocktopia.worldgen.structure.processor.ModStructureProcessorTypes;
import github.mcdatapack.blocktopia.worldgen.tree.decorator.ModTreeDecoratorTypes;
import github.mcdatapack.blocktopia.worldgen.tree.foilageplacer.ModFoliagePlacerTypes;
import github.mcdatapack.blocktopia.worldgen.tree.trunkplacer.ModTrunkPlacerTypes;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricDefaultAttributeRegistry;
import net.fabricmc.fabric.api.registry.CompostingChanceRegistry;
import net.fabricmc.fabric.api.registry.FabricBrewingRecipeRegistryBuilder;
import net.fabricmc.fabric.api.registry.FuelRegistry;
import net.fabricmc.fabric.api.registry.VillagerInteractionRegistries;
import net.fabricmc.fabric.api.transfer.v1.fluid.CauldronFluidContent;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributeHandler;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributes;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.kyrptonaught.customportalapi.api.CustomPortalBuilder;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1842;
import net.minecraft.class_1845;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_3852;
import net.minecraft.class_3854;
import net.minecraft.class_5132;
import net.minecraft.class_6686;
import net.minecraft.class_6880;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import terrablender.api.Region;
import terrablender.api.RegionType;
import terrablender.api.Regions;
import terrablender.api.SurfaceRuleManager;
import terrablender.api.TerraBlenderApi;

public class Blocktopia
implements ModInitializer,
TerraBlenderApi {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Blocktopia");

    public void onInitialize() {
        LOGGER.info("Loading Blocktopia");
        FluidInteractionRegistry.init();
        LocateMobCommand.register();
        ModRecipes.load();
        ModFluids.load();
        ModItems.load();
        ModBlocks.load();
        LegacyBlocks.load();
        LegacyItems.load();
        ModBoats.load();
        ModStructureProcessorTypes.load();
        ModTrunkPlacerTypes.load();
        ModFoliagePlacerTypes.load();
        ModTreeDecoratorTypes.load();
        ModPotions.load();
        ModBiomeModifications.load(BlocktopiaConfig.getConfig().worldgenConfig.worldgenFeatures.features);
        ModBiomes.load();
        ModStructures.load();
        ModStructureSets.load();
        ModStructurePools.load();
        ModProcessorLists.load();
        ModBlockEntityTypes.load();
        ModSpawnRestrictions.load();
        ModScreenHandlerTypes.load();
        ModLootTables.load();
        ModEntityTypes.load();
        TradeHandler.load(BlocktopiaConfig.getConfig().villagerConfig.maxUses);
        FabricDefaultAttributeRegistry.register(ModEntityTypes.MONKEY, (class_5132.class_5133)MonkeyEntity.createMonkeyAttributes());
        FabricDefaultAttributeRegistry.register(ModEntityTypes.TOUCAN, (class_5132.class_5133)AbstractBirdEntity.createBirdAttributes());
        if (BlocktopiaConfig.getConfig().villagerConfig.blocktopiaVillagers) {
            ModVillagers.load();
        }
        ModEnchantments.load();
        LootHandler.registerListeners();
        ItemGroupModifyEventHandler.register();
        ItemStorage.SIDED.registerForBlockEntity(SmallChestBlockEntity::getInventoryProvider, ModBlockEntityTypes.SMALL_CHEST_BLOCK_ENTITY);
        ItemStorage.SIDED.registerForBlockEntity(FluidTankBlockEntity::getInventoryProvider, ModBlockEntityTypes.FLUID_TANK);
        FluidStorage.SIDED.registerForBlockEntity(FluidTankBlockEntity::getFluidTankProvider, ModBlockEntityTypes.FLUID_TANK);
        CompostingChanceRegistry.INSTANCE.add((class_1935)ModItems.BANANA, (Object)Float.valueOf(0.5f));
        CompostingChanceRegistry.INSTANCE.add((class_1935)ModItems.CHERRY, (Object)Float.valueOf(1.0f));
        CompostingChanceRegistry.INSTANCE.add((class_1935)ModBlocks.TROPICAL_MOSS, (Object)Float.valueOf(0.7f));
        CompostingChanceRegistry.INSTANCE.add((class_1935)ModBlocks.TROPICAL_MOSS_CARPET, (Object)Float.valueOf(0.35f));
        CompostingChanceRegistry.INSTANCE.add((class_1935)LegacyBlocks.LEAVES_C0_0_14A, (Object)Float.valueOf(0.3f));
        CompostingChanceRegistry.INSTANCE.add((class_1935)LegacyBlocks.LEAVES_C0_0_15A, (Object)Float.valueOf(0.3f));
        CompostingChanceRegistry.INSTANCE.add((class_1935)LegacyBlocks.LEAVES_C0_24ST, (Object)Float.valueOf(0.3f));
        CompostingChanceRegistry.INSTANCE.add((class_1935)LegacyBlocks.SAPLING_RD161348, (Object)Float.valueOf(0.3f));
        CompostingChanceRegistry.INSTANCE.add((class_1935)LegacyBlocks.SAPLING_C0_0_13A, (Object)Float.valueOf(0.3f));
        CompostingChanceRegistry.INSTANCE.add((class_1935)LegacyBlocks.SAPLING_C0_24ST, (Object)Float.valueOf(0.3f));
        CompostingChanceRegistry.INSTANCE.add((class_1935)LegacyBlocks.DANDELION_C0_0_20A, (Object)Float.valueOf(0.65f));
        CompostingChanceRegistry.INSTANCE.add((class_1935)LegacyBlocks.ROSE_C0_0_20A, (Object)Float.valueOf(0.65f));
        CompostingChanceRegistry.INSTANCE.add((class_1935)LegacyBlocks.POPPY_1_7, (Object)Float.valueOf(0.65f));
        CompostingChanceRegistry.INSTANCE.add((class_1935)LegacyBlocks.BROWN_MUSHROOM_C0_0_20A, (Object)Float.valueOf(0.65f));
        CompostingChanceRegistry.INSTANCE.add((class_1935)LegacyBlocks.RED_MUSHROOM_C0_0_20A, (Object)Float.valueOf(0.65f));
        CompostingChanceRegistry.INSTANCE.add((class_1935)LegacyBlocks.CARVED_PUMPKIN_A1_2_0, (Object)Float.valueOf(0.65f));
        CompostingChanceRegistry.INSTANCE.add((class_1935)LegacyBlocks.BIRCH_LEAVES_B1_2, (Object)Float.valueOf(0.3f));
        CompostingChanceRegistry.INSTANCE.add((class_1935)LegacyBlocks.BIRCH_SAPLING_B1_5, (Object)Float.valueOf(0.3f));
        CompostingChanceRegistry.INSTANCE.add((class_1935)LegacyBlocks.SPRUCE_LEAVES_B1_2, (Object)Float.valueOf(0.3f));
        CompostingChanceRegistry.INSTANCE.add((class_1935)LegacyBlocks.SPRUCE_SAPLING_B1_5, (Object)Float.valueOf(0.3f));
        CompostingChanceRegistry.INSTANCE.add((class_1935)LegacyBlocks.SHRUB_B1_6, (Object)Float.valueOf(0.3f));
        CompostingChanceRegistry.INSTANCE.add((class_1935)LegacyBlocks.SHORT_GRASS_B1_6, (Object)Float.valueOf(0.3f));
        CompostingChanceRegistry.INSTANCE.add((class_1935)LegacyBlocks.FERN_B1_6, (Object)Float.valueOf(0.65f));
        CompostingChanceRegistry.INSTANCE.add((class_1935)LegacyBlocks.VINES_B1_8, (Object)Float.valueOf(0.5f));
        CompostingChanceRegistry.INSTANCE.add((class_1935)LegacyBlocks.MUSHROOM_STEM_B1_8, (Object)Float.valueOf(0.65f));
        CompostingChanceRegistry.INSTANCE.add((class_1935)LegacyBlocks.RED_MUSHROOM_BLOCK_B1_8, (Object)Float.valueOf(0.85f));
        CompostingChanceRegistry.INSTANCE.add((class_1935)LegacyBlocks.BROWN_MUSHROOM_BLOCK_B1_8, (Object)Float.valueOf(0.85f));
        CompostingChanceRegistry.INSTANCE.add((class_1935)LegacyBlocks.MELON_BLOCK_B1_8, (Object)Float.valueOf(0.65f));
        CompostingChanceRegistry.INSTANCE.add((class_1935)LegacyBlocks.ALLIUM_1_7, (Object)Float.valueOf(0.65f));
        CompostingChanceRegistry.INSTANCE.add((class_1935)LegacyBlocks.AZURE_BLUET_1_7, (Object)Float.valueOf(0.65f));
        CompostingChanceRegistry.INSTANCE.add((class_1935)LegacyBlocks.BLUE_ORCHID_1_7, (Object)Float.valueOf(0.65f));
        CompostingChanceRegistry.INSTANCE.add((class_1935)LegacyBlocks.LILAC_1_7, (Object)Float.valueOf(0.65f));
        CompostingChanceRegistry.INSTANCE.add((class_1935)LegacyBlocks.PEONY_1_7, (Object)Float.valueOf(0.65f));
        CompostingChanceRegistry.INSTANCE.add((class_1935)LegacyBlocks.ROSE_BUSH_1_7, (Object)Float.valueOf(0.65f));
        CompostingChanceRegistry.INSTANCE.add((class_1935)LegacyBlocks.SUNFLOWER_1_7, (Object)Float.valueOf(0.65f));
        CompostingChanceRegistry.INSTANCE.add((class_1935)LegacyBlocks.OXEYE_DAISY_1_7, (Object)Float.valueOf(0.65f));
        CompostingChanceRegistry.INSTANCE.add((class_1935)LegacyBlocks.RED_TULIP_1_7, (Object)Float.valueOf(0.65f));
        CompostingChanceRegistry.INSTANCE.add((class_1935)LegacyBlocks.ORANGE_TULIP_1_7, (Object)Float.valueOf(0.65f));
        CompostingChanceRegistry.INSTANCE.add((class_1935)LegacyBlocks.WHITE_TULIP_1_7, (Object)Float.valueOf(0.65f));
        CompostingChanceRegistry.INSTANCE.add((class_1935)LegacyBlocks.PINK_TULIP_1_7, (Object)Float.valueOf(0.65f));
        CompostingChanceRegistry.INSTANCE.add((class_1935)LegacyBlocks.LARGE_FERN_1_7, (Object)Float.valueOf(0.65f));
        CompostingChanceRegistry.INSTANCE.add((class_1935)LegacyBlocks.TALL_GRASS_1_7, (Object)Float.valueOf(0.65f));
        FuelRegistry.INSTANCE.add((class_1935)ModItems.THERMORGANIC_FUEL, (Object)32000);
        FabricBrewingRecipeRegistryBuilder.BUILD.register(builder -> Blocktopia.registerWithLongAndStrongAndNegative(builder, class_1802.field_8287, ModPotions.XP_BOOST, ModPotions.STRONG_XP_BOOST, ModPotions.LONG_XP_BOOST, ModPotions.XP_REMOVER, ModPotions.STRONG_XP_REMOVER, ModPotions.LONG_XP_REMOVER));
        VillagerInteractionRegistries.registerGiftLootTable((class_3852)ModVillagers.LEGACY, ModLootTables.LEGACY_VILLAGER_GIFT);
        VillagerInteractionRegistries.registerGiftLootTable((class_3852)ModVillagers.BEEKEEPER, ModLootTables.BEEKEEPER_VILLAGER_GIFT);
        VillagerInteractionRegistries.registerFood((class_1935)ModItems.BANANA, (int)1);
        VillagerInteractionRegistries.registerFood((class_1935)ModItems.CHERRY, (int)8);
        VillagerInteractionRegistries.registerCompostable((class_1935)ModItems.BANANA);
        VillagerInteractionRegistries.registerCompostable((class_1935)ModItems.CHERRY);
        ModItemGroups.load();
        FluidVariantAttributes.register((class_3611)ModFluids.TROPICAL_WATER, (FluidVariantAttributeHandler)new FluidVariantAttributeHandler(this){

            public class_2561 getName(FluidVariant fluidVariant) {
                return class_2561.method_43471((String)"fluid.blocktopia.tropical_water");
            }
        });
        CustomPortalBuilder.beginPortal().frameBlock(class_2246.field_10306).destDimID(Blocktopia.id("tropics")).tintColor(26, 158, 10).registerPortal();
        CustomPortalBuilder.beginPortal().frameBlock(class_2246.field_42729).destDimID(Blocktopia.id("tropics1")).tintColor(26, 158, 10).registerPortal();
        CustomPortalBuilder.beginPortal().frameBlock(ModBlocks.BANANA_LOG).destDimID(Blocktopia.id("tropics1")).tintColor(26, 158, 10).registerPortal();
        CustomPortalBuilder.beginPortal().frameBlock(ModBlocks.MAHOGANY_LOG).destDimID(Blocktopia.id("tropics1")).tintColor(26, 158, 10).registerPortal();
        CustomPortalBuilder.beginPortal().frameBlock(ModBlocks.CORN_LOG).destDimID(Blocktopia.id("tropics1")).tintColor(26, 158, 10).registerPortal();
        CustomPortalBuilder.beginPortal().frameBlock(ModBlocks.POISONED_LOG).destDimID(Blocktopia.id("tropics1")).tintColor(26, 158, 10).registerPortal();
        CauldronFluidContent.registerCauldron((class_2248)ModBlocks.TROPICAL_WATER_CAULDRON, (class_3611)ModFluids.TROPICAL_WATER, (long)81000L, null);
        class_3854.field_17078.put(ModBiomes.RAIN_FOREST_KEY, class_3854.field_17072);
        VillagerLevelTradeCountRegistry.registerTradeCount(ModVillagers.LEGACY, 5);
        CustomPiglinTrading.addBarteringItem((class_1935)class_1802.field_22020, ModLootTables.NETHERITE_PIGLIN_BARTERING);
        CustomPiglinTrading.addBarteringItem((class_1935)class_1802.field_22018, ModLootTables.NETHERITE_BLOCK_PIGLIN_BARTERING);
        CustomPiglinTrading.addBarteringItem((class_1935)LegacyBlocks.BEDROCK_C0_0_12A, ModLootTables.BEDROCK_C0_0_12A_PIGLIN_BARTERING);
        LOGGER.info("Loaded Blocktopia");
    }

    public void onTerraBlenderInitialized() {
        if (BlocktopiaConfig.getConfig().worldgenConfig.worldgenFeatures.biomes.palm_island && BlocktopiaConfig.getConfig().worldgenConfig.worldgenFeatures.biomes.rain_forest) {
            Regions.register((Region)new BlocktopiaOverworldRegion(Blocktopia.id("overworld"), RegionType.OVERWORLD, BlocktopiaConfig.getConfig().worldgenConfig.weight));
        }
        if (BlocktopiaConfig.getConfig().worldgenConfig.worldgenFeatures.biomes.sandy_dirt_in_palm_island) {
            SurfaceRuleManager.addSurfaceRules((SurfaceRuleManager.RuleCategory)SurfaceRuleManager.RuleCategory.OVERWORLD, (String)"blocktopia", (class_6686.class_6708)BlocktopiaSurfaceRules.palmIslandRule());
        }
        if (BlocktopiaConfig.getConfig().worldgenConfig.worldgenFeatures.biomes.tropical_moss_in_rainforest) {
            SurfaceRuleManager.addSurfaceRules((SurfaceRuleManager.RuleCategory)SurfaceRuleManager.RuleCategory.OVERWORLD, (String)"blocktopia", (class_6686.class_6708)BlocktopiaSurfaceRules.rainForestRule());
        }
    }

    public static class_2960 id(String path) {
        return class_2960.method_60655((String)"blocktopia", (String)path);
    }

    public static class_2960 idTrinkets(String path) {
        return class_2960.method_60655((String)"trinkets", (String)path);
    }

    private static void registerWithLongAndStrongAndNegative(class_1845.class_9665 builder, class_1792 ingredient, class_6880<class_1842> potion, class_6880<class_1842> strongPotion, class_6880<class_1842> longPotion, class_6880<class_1842> negativePotion, class_6880<class_1842> negativeStrongPotion, class_6880<class_1842> negativeLongPotion) {
        Blocktopia.registerWithLongAndStrong(builder, ingredient, potion, strongPotion, longPotion);
        builder.method_59705(negativePotion, class_1802.field_8601, negativeStrongPotion);
        builder.method_59705(negativePotion, class_1802.field_8725, negativeLongPotion);
        builder.method_59705(potion, class_1802.field_8711, negativePotion);
        builder.method_59705(longPotion, class_1802.field_8711, negativeLongPotion);
        builder.method_59705(strongPotion, class_1802.field_8711, negativeStrongPotion);
    }

    private static void registerWithLongAndStrong(class_1845.class_9665 builder, class_1792 ingredient, class_6880<class_1842> potion, class_6880<class_1842> strongPotion, class_6880<class_1842> longPotion) {
        builder.method_59704(ingredient, potion);
        builder.method_59705(potion, class_1802.field_8601, strongPotion);
        builder.method_59705(potion, class_1802.field_8725, longPotion);
    }

    static {
        BlocktopiaConfig.register();
    }
}

