/*
 * Decompiled with CFR 0.152.
 */
package github.mcdatapack.blocktopia.block.custom;

import github.mcdatapack.blocktopia.block.entity.ModBlockEntityTypes;
import github.mcdatapack.blocktopia.block.entity.custom.FluidTankBlockEntity;
import github.mcdatapack.blocktopia.util.TickableBlockEntity;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3542;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_3908;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import org.jetbrains.annotations.Nullable;

public class FluidTankBlock
extends class_2248
implements class_2343,
class_3737 {
    public static final class_2754<TankSegmentType> SEGMENT_TYPE = class_2754.method_11850((String)"segment_type", TankSegmentType.class);
    public static final class_2754<class_2350.class_2351> CONNECTION_AXIS = class_2754.method_11850((String)"connection_axis", class_2350.class_2351.class);
    public static final class_2746 WATERLOGGED = class_2741.field_12508;

    public FluidTankBlock(class_4970.class_2251 settings) {
        super(settings);
    }

    public class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        if (world.field_9236) {
            return class_1269.field_5812;
        }
        class_2586 be = world.method_8321(pos);
        if (!(be instanceof FluidTankBlockEntity)) {
            return class_1269.field_5811;
        }
        FluidTankBlockEntity clickedTank = (FluidTankBlockEntity)be;
        FluidTankBlockEntity controller = clickedTank.getController();
        if (controller != null) {
            player.method_17355((class_3908)controller);
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    protected void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        class_2586 class_25862;
        if (state.method_26204() != newState.method_26204() && (class_25862 = world.method_8321(pos)) instanceof FluidTankBlockEntity) {
            FluidTankBlockEntity blockEntity = (FluidTankBlockEntity)class_25862;
            class_1264.method_5451((class_1937)world, (class_2338)pos, (class_1263)blockEntity.getInventory());
            world.method_8455(pos, (class_2248)this);
        }
        super.method_9536(state, world, pos, newState, moved);
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return ModBlockEntityTypes.FLUID_TANK.method_11032(pos, state);
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        return TickableBlockEntity.getTicker(world);
    }

    protected class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        class_2350.class_2351 axis = (class_2350.class_2351)state.method_11654(CONNECTION_AXIS);
        TankSegmentType type = (TankSegmentType)((Object)state.method_11654(SEGMENT_TYPE));
        if (axis == class_2350.class_2351.field_11048) {
            if (type == TankSegmentType.START) {
                return class_259.method_1081((double)0.25, (double)0.0, (double)0.25, (double)1.0, (double)0.8125, (double)0.75);
            }
            if (type == TankSegmentType.END) {
                return class_259.method_1081((double)0.0, (double)0.0, (double)0.25, (double)0.75, (double)0.8125, (double)0.75);
            }
            if (type == TankSegmentType.MIDDLE) {
                return class_259.method_1081((double)0.0, (double)0.0, (double)0.25, (double)1.0, (double)0.8125, (double)0.75);
            }
        } else if (axis == class_2350.class_2351.field_11051) {
            if (type == TankSegmentType.START) {
                return class_259.method_1081((double)0.25, (double)0.0, (double)0.25, (double)0.75, (double)0.8125, (double)1.0);
            }
            if (type == TankSegmentType.END) {
                return class_259.method_1081((double)0.25, (double)0.0, (double)0.0, (double)0.75, (double)0.8125, (double)0.75);
            }
            if (type == TankSegmentType.MIDDLE) {
                return class_259.method_1081((double)0.25, (double)0.0, (double)0.0, (double)0.75, (double)0.8125, (double)1.0);
            }
        }
        return class_259.method_1081((double)0.25, (double)0.0, (double)0.25, (double)0.75, (double)0.8125, (double)0.75);
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            world.method_39281(pos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789((class_4538)world));
        }
        if (direction.method_10166().method_10179()) {
            class_2350.class_2351 currentAxis = (class_2350.class_2351)state.method_11654(CONNECTION_AXIS);
            class_2350.class_2351 newAxis = currentAxis == class_2350.class_2351.field_11052 ? this.getConnectionAxis(world, pos) : currentAxis;
            TankSegmentType newSegment = this.getSegmentType(world, pos, newAxis);
            return (class_2680)((class_2680)state.method_11657(CONNECTION_AXIS, (Comparable)newAxis)).method_11657(SEGMENT_TYPE, (Comparable)((Object)newSegment));
        }
        return super.method_9559(state, direction, neighborState, world, pos, neighborPos);
    }

    protected class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    public class_2680 method_9605(class_1750 ctx) {
        boolean canConnectX;
        class_1937 world = ctx.method_8045();
        class_2338 pos = ctx.method_8037();
        class_2680 north = world.method_8320(pos.method_10095());
        class_2680 south = world.method_8320(pos.method_10072());
        class_2680 east = world.method_8320(pos.method_10078());
        class_2680 west = world.method_8320(pos.method_10067());
        boolean canConnectZ = this.isTank(north) && this.isUnconnected(north) || this.isTank(south) && this.isUnconnected(south);
        boolean bl = canConnectX = this.isTank(east) && this.isUnconnected(east) || this.isTank(west) && this.isUnconnected(west);
        class_2350.class_2351 axis = canConnectX && !canConnectZ ? class_2350.class_2351.field_11048 : (canConnectZ && !canConnectX ? class_2350.class_2351.field_11051 : class_2350.class_2351.field_11052);
        TankSegmentType segment = this.getSegmentType((class_1936)world, pos, axis);
        return (class_2680)((class_2680)((class_2680)this.method_9564().method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(world.method_8316(pos).method_15772() == class_3612.field_15910))).method_11657(CONNECTION_AXIS, (Comparable)axis)).method_11657(SEGMENT_TYPE, (Comparable)((Object)segment));
    }

    private boolean isConnectable(class_2680 state, class_2350.class_2351 axis) {
        if (!this.isTank(state)) {
            return false;
        }
        if (!state.method_28498(CONNECTION_AXIS)) {
            return false;
        }
        class_2350.class_2351 neighborAxis = (class_2350.class_2351)state.method_11654(CONNECTION_AXIS);
        return neighborAxis == class_2350.class_2351.field_11052 || neighborAxis == axis;
    }

    private boolean isUnconnected(class_2680 state) {
        return state.method_28498(CONNECTION_AXIS) && state.method_11654(CONNECTION_AXIS) == class_2350.class_2351.field_11052;
    }

    private class_2350.class_2351 getConnectionAxis(class_1936 world, class_2338 pos) {
        boolean canConnectX;
        class_2680 north = world.method_8320(pos.method_10095());
        class_2680 south = world.method_8320(pos.method_10072());
        class_2680 east = world.method_8320(pos.method_10078());
        class_2680 west = world.method_8320(pos.method_10067());
        boolean canConnectZ = this.isConnectable(north, class_2350.class_2351.field_11051) || this.isConnectable(south, class_2350.class_2351.field_11051);
        boolean bl = canConnectX = this.isConnectable(east, class_2350.class_2351.field_11048) || this.isConnectable(west, class_2350.class_2351.field_11048);
        if (canConnectX && !canConnectZ) {
            return class_2350.class_2351.field_11048;
        }
        if (canConnectZ && !canConnectX) {
            return class_2350.class_2351.field_11051;
        }
        return class_2350.class_2351.field_11052;
    }

    private TankSegmentType getSegmentType(class_1936 world, class_2338 pos, class_2350.class_2351 axis) {
        class_2350 positive = class_2350.method_10169((class_2350.class_2351)axis, (class_2350.class_2352)class_2350.class_2352.field_11056);
        class_2350 negative = class_2350.method_10169((class_2350.class_2351)axis, (class_2350.class_2352)class_2350.class_2352.field_11060);
        boolean posConnected = this.isConnectable(world.method_8320(pos.method_10093(positive)), axis);
        boolean negConnected = this.isConnectable(world.method_8320(pos.method_10093(negative)), axis);
        if (posConnected && negConnected) {
            return TankSegmentType.MIDDLE;
        }
        if (posConnected) {
            return TankSegmentType.START;
        }
        if (negConnected) {
            return TankSegmentType.END;
        }
        return TankSegmentType.SINGLE;
    }

    private boolean isTank(class_2680 state) {
        return state.method_26204() instanceof FluidTankBlock;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{WATERLOGGED, CONNECTION_AXIS, SEGMENT_TYPE});
    }

    public static enum TankSegmentType implements class_3542
    {
        SINGLE("single"),
        START("start"),
        MIDDLE("middle"),
        END("end");

        private final String name;

        private TankSegmentType(String name) {
            this.name = name;
        }

        public String method_15434() {
            return this.name;
        }
    }
}

