/*
 * Decompiled with CFR 0.152.
 */
package github.mcdatapack.blocktopia.block.entity.custom;

import github.mcdatapack.blocktopia.block.custom.FluidTankBlock;
import github.mcdatapack.blocktopia.block.entity.ModBlockEntityTypes;
import github.mcdatapack.blocktopia.config.BlocktopiaConfig;
import github.mcdatapack.blocktopia.network.BlockPosPayload;
import github.mcdatapack.blocktopia.screen.custom.screenhandler.FluidTankScreenHandler;
import github.mcdatapack.blocktopia.util.TickableBlockEntity;
import java.util.stream.IntStream;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.base.SingleFluidStorage;
import net.fabricmc.fabric.api.transfer.v1.item.InventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1278;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;

public class FluidTankBlockEntity
extends class_2586
implements TickableBlockEntity,
ExtendedScreenHandlerFactory<BlockPosPayload>,
class_1278 {
    public static final class_2561 NAME = class_2561.method_43471((String)"container.blocktopia.fluid_tank");
    private final class_2371<class_1799> inventory = class_2371.method_10213((int)1, (Object)class_1799.field_8037);
    private final InventoryStorage inventoryStorage = InventoryStorage.of((class_1263)this, null);
    private final ContainerItemContext fluidItemContext = ContainerItemContext.ofSingleSlot((SingleSlotStorage)this.inventoryStorage.getSlot(0));
    private final ResizableFluidStorage fluidStorage = new ResizableFluidStorage();
    private boolean tookFluid;

    public int[] method_5494(class_2350 side) {
        return this.getControllerOrSelf().getRawAvailableSlots(side);
    }

    public int[] getRawAvailableSlots(class_2350 side) {
        return IntStream.range(0, this.inventory.size()).toArray();
    }

    public boolean method_5492(int slot, class_1799 stack, class_2350 side) {
        return this.getControllerOrSelf().canInsertRaw(slot, stack, side);
    }

    public boolean canInsertRaw(int slot, class_1799 stack, class_2350 side) {
        return ((class_1799)this.inventory.getFirst()).method_7960() && stack.method_7947() == 1;
    }

    public boolean method_5493(int slot, class_1799 stack, class_2350 side) {
        return this.getControllerOrSelf().canExtractRaw(slot, stack, side);
    }

    public boolean canExtractRaw(int slot, class_1799 stack, class_2350 side) {
        return this.tookFluid && ContainerItemContext.withConstant((class_1799)stack).find(FluidStorage.ITEM) != null;
    }

    public int method_5439() {
        return this.inventory.size();
    }

    public class_1799 method_5438(int slot) {
        return (class_1799)this.getControllerOrSelf().inventory.get(slot);
    }

    public void method_5447(int slot, class_1799 stack) {
        this.getControllerOrSelf().inventory.set(slot, (Object)stack);
        this.method_5431();
    }

    public class_1799 method_5434(int slot, int amount) {
        class_1799 stack = class_1262.method_5430(this.getControllerOrSelf().inventory, (int)slot, (int)amount);
        if (!stack.method_7960()) {
            this.method_5431();
        }
        return stack;
    }

    public class_1799 method_5441(int slot) {
        class_1799 stack = class_1262.method_5428(this.getControllerOrSelf().inventory, (int)slot);
        this.method_5431();
        return stack;
    }

    public boolean method_5442() {
        return this.getControllerOrSelf().inventory.stream().allMatch(class_1799::method_7960);
    }

    public void method_5448() {
        this.getControllerOrSelf().inventory.clear();
    }

    public boolean method_5443(class_1657 player) {
        return true;
    }

    public FluidTankBlockEntity(class_2338 pos, class_2680 state) {
        super(ModBlockEntityTypes.FLUID_TANK, pos, state);
    }

    @Override
    public void tick() {
        Transaction transaction;
        if (this.field_11863 == null || this.field_11863.field_9236) {
            return;
        }
        FluidTankBlockEntity controller = this.getController();
        if (controller != this) {
            return;
        }
        int connectedCount = controller.getConnectedTankCount();
        long totalCapacity = (long)connectedCount * BlocktopiaConfig.getConfig().fluidTankCapacity;
        controller.fluidStorage.setCapacity(totalCapacity);
        if (this.tookFluid && ((class_1799)this.inventory.getFirst()).method_7960()) {
            this.tookFluid = false;
        } else if (this.tookFluid) {
            return;
        }
        if (controller.inventory.isEmpty() || !controller.isValid((class_1799)controller.inventory.getFirst(), 0)) {
            return;
        }
        Storage itemFluidStorage = (Storage)this.fluidItemContext.find(FluidStorage.ITEM);
        if (itemFluidStorage == null) {
            return;
        }
        FluidVariant match = null;
        for (StorageView storageView : itemFluidStorage.nonEmptyViews()) {
            if (storageView.isResourceBlank()) continue;
            Transaction transaction2 = Transaction.openOuter();
            try {
                if (this.fluidStorage.insert((TransferVariant)((FluidVariant)storageView.getResource()), 81000L, (TransactionContext)transaction2) <= 0L) continue;
                match = (FluidVariant)storageView.getResource();
                break;
            }
            finally {
                if (transaction2 == null) continue;
                transaction2.close();
            }
        }
        if (match != null && !match.isBlank()) {
            transaction = Transaction.openOuter();
            try {
                long inserted = this.fluidStorage.insert((TransferVariant)match, 81000L, (TransactionContext)transaction);
                long extracted = itemFluidStorage.extract(match, inserted, (TransactionContext)transaction);
                this.tookFluid = true;
                if (extracted < 81000L) {
                    long extra = 81000L - extracted;
                    this.fluidStorage.extract((TransferVariant)match, extra, (TransactionContext)transaction);
                }
                transaction.commit();
            }
            finally {
                if (transaction != null) {
                    transaction.close();
                }
            }
        }
        transaction = Transaction.openOuter();
        try {
            for (StorageView tankView : this.fluidStorage.nonEmptyViews()) {
                FluidVariant fluidInTank = (FluidVariant)tankView.getResource();
                long available = tankView.getAmount();
                if (available < 27000L) continue;
                long inserted = itemFluidStorage.insert((Object)fluidInTank, 27000L, (TransactionContext)transaction);
                if (inserted > 0L) {
                    this.fluidStorage.extract((TransferVariant)fluidInTank, inserted, (TransactionContext)transaction);
                    this.tookFluid = true;
                    transaction.commit();
                } else {
                    inserted = itemFluidStorage.insert((Object)fluidInTank, 81000L, (TransactionContext)transaction);
                    if (inserted <= 0L) continue;
                    this.fluidStorage.extract((TransferVariant)fluidInTank, inserted, (TransactionContext)transaction);
                    this.tookFluid = true;
                    transaction.commit();
                }
                break;
            }
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    private FluidTankBlockEntity getControllerOrSelf() {
        FluidTankBlockEntity controller = this.getController();
        return controller != null ? controller : this;
    }

    public FluidTankBlockEntity getController() {
        FluidTankBlockEntity tank;
        FluidTankBlockEntity tank2;
        class_2338 prev;
        class_2586 be;
        if (this.field_11863 == null) {
            return null;
        }
        class_2350.class_2351 axis = this.getConnectionAxis();
        class_2338 current = this.field_11867;
        while ((be = this.field_11863.method_8321(prev = current.method_10093(class_2350.method_10169((class_2350.class_2351)axis, (class_2350.class_2352)class_2350.class_2352.field_11060)))) instanceof FluidTankBlockEntity && (tank2 = (FluidTankBlockEntity)be).getConnectionAxis() == axis) {
            current = prev;
        }
        class_2586 controller = this.field_11863.method_8321(current);
        return controller instanceof FluidTankBlockEntity ? (tank = (FluidTankBlockEntity)controller) : this;
    }

    public boolean isConnected(class_2350 direction) {
        if (!this.getConnectionAxis().method_10176(direction)) {
            return false;
        }
        return this.field_11863.method_8320(this.field_11867.method_10093(direction)).method_26204() instanceof FluidTankBlock && ((class_2350.class_2351)this.field_11863.method_8320(this.field_11867.method_10093(direction)).method_11654(FluidTankBlock.CONNECTION_AXIS)).method_10176(direction);
    }

    public int getConnectedTankCount() {
        class_2338 prev;
        FluidTankBlockEntity tank;
        class_2338 next;
        class_2586 be;
        class_2350.class_2351 axis = this.getConnectionAxis();
        int count = 1;
        class_2338 current = this.field_11867;
        while ((be = this.field_11863.method_8321(next = current.method_10093(class_2350.method_10169((class_2350.class_2351)axis, (class_2350.class_2352)class_2350.class_2352.field_11056)))) instanceof FluidTankBlockEntity && (tank = (FluidTankBlockEntity)be).getConnectionAxis() == axis) {
            ++count;
            current = next;
        }
        current = this.field_11867;
        while ((be = this.field_11863.method_8321(prev = current.method_10093(class_2350.method_10169((class_2350.class_2351)axis, (class_2350.class_2352)class_2350.class_2352.field_11060)))) instanceof FluidTankBlockEntity && (tank = (FluidTankBlockEntity)be).getConnectionAxis() == axis) {
            ++count;
            current = prev;
        }
        return count;
    }

    private boolean isTank(class_2680 state) {
        return state.method_26204() instanceof FluidTankBlock;
    }

    public class_2350.class_2351 getConnectionAxis() {
        if (this.field_11863 == null) {
            return class_2350.class_2351.field_11052;
        }
        class_2680 state = this.field_11863.method_8320(this.field_11867);
        return state.method_28498(FluidTankBlock.CONNECTION_AXIS) ? (class_2350.class_2351)state.method_11654(FluidTankBlock.CONNECTION_AXIS) : class_2350.class_2351.field_11052;
    }

    public FluidTankBlock.TankSegmentType getSegmentType() {
        if (this.field_11863 == null) {
            return FluidTankBlock.TankSegmentType.SINGLE;
        }
        class_2680 state = this.field_11863.method_8320(this.field_11867);
        return state.method_28498(FluidTankBlock.SEGMENT_TYPE) ? (FluidTankBlock.TankSegmentType)((Object)state.method_11654(FluidTankBlock.SEGMENT_TYPE)) : FluidTankBlock.TankSegmentType.SINGLE;
    }

    public BlockPosPayload getScreenOpeningData(class_3222 player) {
        FluidTankBlockEntity controller = this.getController();
        return new BlockPosPayload(controller.method_11016());
    }

    public class_2561 method_5476() {
        return NAME;
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        return new FluidTankScreenHandler(syncId, playerInventory, this);
    }

    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        if (nbt.method_10573("Inventory", 10)) {
            class_1262.method_5429((class_2487)nbt.method_10562("Inventory"), this.inventory, (class_7225.class_7874)registryLookup);
        }
        if (nbt.method_10573("FluidTank", 10)) {
            this.fluidStorage.readNbt(nbt.method_10562("FluidTank"), registryLookup);
        }
        if (nbt.method_10573("FluidCapacity", 4)) {
            this.getControllerOrSelf().fluidStorage.setCapacity(nbt.method_10537("FluidCapacity"));
        }
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        class_2487 inventoryNbt = new class_2487();
        class_1262.method_5426((class_2487)inventoryNbt, this.inventory, (class_7225.class_7874)registryLookup);
        nbt.method_10566("Inventory", (class_2520)inventoryNbt);
        class_2487 fluidNbt = new class_2487();
        this.fluidStorage.writeNbt(fluidNbt, registryLookup);
        nbt.method_10566("FluidTank", (class_2520)fluidNbt);
        nbt.method_10544("FluidCapacity", this.fluidStorage.getCapacity());
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887(class_7225.class_7874 registryLookup) {
        class_2487 nbt = super.method_16887(registryLookup);
        this.method_11007(nbt, registryLookup);
        return nbt;
    }

    private void update() {
        this.method_5431();
        if (this.field_11863 != null) {
            this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 3);
        }
    }

    public boolean isValid(class_1799 stack, int slot) {
        if (stack.method_7960()) {
            return true;
        }
        if (slot != 0) {
            return false;
        }
        Storage storage = (Storage)ContainerItemContext.withConstant((class_1799)stack).find(FluidStorage.ITEM);
        return storage != null;
    }

    public InventoryStorage getInventoryProvider(class_2350 direction) {
        return this.inventoryStorage;
    }

    public ResizableFluidStorage getFluidTankProvider(class_2350 direction) {
        FluidTankBlockEntity controller = this.getController();
        return controller.fluidStorage;
    }

    public long getCapacity() {
        return this.getControllerOrSelf().fluidStorage.capacity;
    }

    public class_1263 getInventory() {
        return this;
    }

    public ResizableFluidStorage getFluidTank() {
        FluidTankBlockEntity controller = this.getController();
        return controller.fluidStorage;
    }

    public final class ResizableFluidStorage
    extends SingleFluidStorage {
        public long capacity;

        public ResizableFluidStorage() {
            this.capacity = BlocktopiaConfig.getConfig().fluidTankCapacity;
        }

        protected long getCapacity(FluidVariant variant) {
            return this.capacity;
        }

        public void setCapacity(long capacity) {
            this.capacity = capacity;
        }

        protected void onFinalCommit() {
            FluidTankBlockEntity.this.update();
        }
    }
}

