/*
 * Decompiled with CFR 0.152.
 */
package github.mcdatapack.blocktopia.block.entity.renderer;

import github.mcdatapack.blocktopia.block.custom.SmallChestBlock;
import github.mcdatapack.blocktopia.block.entity.custom.SmallChestBlockEntity;
import github.mcdatapack.blocktopia.block.entity.model.SmallChestModel;
import github.mcdatapack.blocktopia.config.BlocktopiaConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.class_1277;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_630;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_827;

public class SmallChestBlockEntityRenderer
implements class_827<SmallChestBlockEntity> {
    private static final List<ItemTransformation> TRANSFORMATIONS = new ArrayList<ItemTransformation>();
    private final class_5614.class_5615 context;
    private final SmallChestModel model;

    public SmallChestBlockEntityRenderer(class_5614.class_5615 context) {
        this.context = context;
        this.model = new SmallChestModel(context.method_32140(SmallChestModel.LAYER));
    }

    public void render(SmallChestBlockEntity entity, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay) {
        matrices.method_22903();
        matrices.method_46416(0.5f, 0.0f, 0.5f);
        class_630 lid = this.model.getLid();
        boolean defaultAngle = false;
        int numPlayersOpen = entity.getNumPlayersOpen();
        float lidAngle = entity.getLidAngle();
        double maxAngle = Math.toRadians(110.0);
        if (numPlayersOpen > 0 && (double)lidAngle < maxAngle) {
            lid.field_3654 = class_3532.method_16439((float)(tickDelta / (float)BlocktopiaConfig.getConfig().smallChestConfig.closingSpeed), (float)lidAngle, (float)((float)maxAngle));
        } else if (numPlayersOpen == 0 && lidAngle > (float)defaultAngle) {
            lid.field_3654 = class_3532.method_16439((float)(tickDelta / (float)BlocktopiaConfig.getConfig().smallChestConfig.closingSpeed), (float)lidAngle, (float)((float)defaultAngle));
        }
        entity.lidAngle = lid.field_3654;
        matrices.method_22907(class_7833.field_40716.rotationDegrees(switch ((class_2350)entity.method_11010().method_11654((class_2769)SmallChestBlock.FACING)) {
            case class_2350.field_11034 -> 270.0f;
            case class_2350.field_11035 -> 180.0f;
            case class_2350.field_11039 -> 90.0f;
            default -> 0.0f;
        }));
        if (BlocktopiaConfig.getConfig().smallChestConfig.renderItems && (double)entity.lidAngle > 0.1) {
            class_1277 inventory = entity.getInventory();
            class_1937 world = entity.method_10997();
            for (int i = 0; i < inventory.method_54454().size(); ++i) {
                class_1799 stack = inventory.method_5438(i);
                if (stack.method_7960()) continue;
                ItemTransformation transformation = TRANSFORMATIONS.get(i);
                matrices.method_22903();
                matrices.method_22904(transformation.x(), 0.5, transformation.z());
                matrices.method_22905(0.325f, 0.325f, 0.325f);
                matrices.method_22907(class_7833.field_40716.rotationDegrees((float)transformation.rotation()));
                this.context.method_43335().method_23178(stack, class_811.field_4319, light, overlay, matrices, vertexConsumers, world, 0);
                matrices.method_22909();
            }
        }
        this.model.method_60879(matrices, vertexConsumers.getBuffer(class_1921.method_23572((class_2960)SmallChestModel.TEXTURE_LOCATION)), light, overlay);
        lid.field_3654 = (float)defaultAngle;
        matrices.method_22909();
    }

    static {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        for (int index = 0; index < 36; ++index) {
            TRANSFORMATIONS.add(new ItemTransformation((((Random)random).nextDouble() - 0.5) * 0.4375, (((Random)random).nextDouble() - 0.5) * 0.4375, ((Random)random).nextInt(360)));
        }
    }

    public record ItemTransformation(double x, double z, int rotation) {
    }
}

