/*
 * Decompiled with CFR 0.152.
 */
package github.mcdatapack.blocktopia.compat;

import github.mcdatapack.blocktopia.block.ModBlocks;
import github.mcdatapack.blocktopia.compat.GeneratorRecipeCategory;
import github.mcdatapack.blocktopia.compat.LegacyCuttingRecipeCategory;
import github.mcdatapack.blocktopia.compat.WoodCuttingRecipeCategory;
import github.mcdatapack.blocktopia.data.FluidInteraction;
import github.mcdatapack.blocktopia.data.FluidInteractionRegistry;
import github.mcdatapack.blocktopia.recipe.ModRecipes;
import java.util.List;
import java.util.Objects;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.class_1799;
import net.minecraft.class_1863;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import org.jetbrains.annotations.NotNull;

@JeiPlugin
public class BlocktopiaJeiPlugin
implements IModPlugin {
    public static final class_2960 UID = class_2960.method_60655((String)"blocktopia", (String)"jei");

    @NotNull
    public class_2960 getPluginUid() {
        return UID;
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IGuiHelper guiHelper = registration.getJeiHelpers().getGuiHelper();
        registration.addRecipeCategories(new IRecipeCategory[]{new LegacyCuttingRecipeCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new WoodCuttingRecipeCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new GeneratorRecipeCategory(guiHelper)});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        class_1863 manager = Objects.requireNonNull(class_310.method_1551().field_1687).method_8433();
        List legacyRecipes = manager.method_30027(ModRecipes.LEGACY_CUTTING_RECIPE_TYPE);
        registration.addRecipes(LegacyCuttingRecipeCategory.TYPE, legacyRecipes);
        List woodRecipes = manager.method_30027(ModRecipes.WOOD_CUTTING_RECIPE_TYPE);
        registration.addRecipes(WoodCuttingRecipeCategory.TYPE, woodRecipes);
        List<FluidInteraction> generatorRecipes = FluidInteractionRegistry.getAll().stream().toList();
        registration.addRecipes(GeneratorRecipeCategory.TYPE, generatorRecipes);
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new class_1799((class_1935)ModBlocks.LEGACY_CUTTER), new RecipeType[]{LegacyCuttingRecipeCategory.TYPE});
        registration.addRecipeCatalyst(new class_1799((class_1935)ModBlocks.WOODCUTTER), new RecipeType[]{WoodCuttingRecipeCategory.TYPE});
    }
}

