/*
 * Decompiled with CFR 0.152.
 */
package github.mcdatapack.blocktopia.datagen.custom;

import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricAdvancementProvider;
import net.minecraft.class_161;
import net.minecraft.class_170;
import net.minecraft.class_174;
import net.minecraft.class_175;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_184;
import net.minecraft.class_185;
import net.minecraft.class_189;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_1999;
import net.minecraft.class_2037;
import net.minecraft.class_2066;
import net.minecraft.class_2073;
import net.minecraft.class_2090;
import net.minecraft.class_2096;
import net.minecraft.class_2135;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8779;
import net.minecraft.class_8782;
import org.jetbrains.annotations.Nullable;

public abstract class BlocktopiaAdvancementGenerator
extends FabricAdvancementProvider {
    private class_7225<class_1959> biomeWrapper;

    protected BlocktopiaAdvancementGenerator(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registryLookup) {
        super(output, registryLookup);
        registryLookup.thenAccept(lookup -> {
            this.biomeWrapper = lookup.method_46762(class_7924.field_41236);
        });
    }

    protected class_175<class_2135.class_2137> tick() {
        return class_2135.class_2137.method_49195();
    }

    public class_175<class_2037.class_2039> requireEnteringFluid(class_2248 block) {
        return class_174.field_1180.method_53699((class_184)new class_2037.class_2039(Optional.empty(), Optional.of(block.method_40142()), Optional.empty()));
    }

    public class_175<class_2066.class_2068> conditionsFromItem(class_2096.class_2100 count, class_1935 item) {
        return this.conditionsFromPredicates(class_2073.class_2074.method_8973().method_8977(new class_1935[]{item}).method_35233(count));
    }

    public class_175<class_2066.class_2068> conditionsFromItem(class_1935 item) {
        return this.conditionsFromPredicates(class_2073.class_2074.method_8973().method_8977(new class_1935[]{item}));
    }

    public class_175<class_2066.class_2068> conditionsFromTag(class_6862<class_1792> tag) {
        return this.conditionsFromPredicates(class_2073.class_2074.method_8973().method_8975(tag));
    }

    public class_175<class_2066.class_2068> conditionsFromPredicates(class_2073.class_2074 ... predicates) {
        return this.conditionsFromItemPredicates((class_2073[])Arrays.stream(predicates).map(class_2073.class_2074::method_8976).toArray(class_2073[]::new));
    }

    public class_175<class_2066.class_2068> conditionsFromItemPredicates(class_2073 ... predicates) {
        return class_174.field_1195.method_53699((class_184)new class_2066.class_2068(Optional.empty(), class_2066.class_2068.class_8948.field_47265, List.of(predicates)));
    }

    public class_175<class_2135.class_2137> conditionsFromBiome(class_5321<class_1959> biome) {
        return class_2135.class_2137.method_43137((class_2090.class_2091)class_2090.class_2091.method_53180((class_6880)this.biomeWrapper.method_46747(biome)));
    }

    public class_175<class_1999.class_2001> conditionsFromDimension(class_5321<class_1937> from, class_5321<class_1937> to) {
        return class_1999.class_2001.method_35068(from, to);
    }

    public class_175<class_1999.class_2001> conditionsFromDimension(class_5321<class_1937> to) {
        return class_1999.class_2001.method_8799(to);
    }

    public String hasItem(class_1935 item) {
        return "has_" + this.getItemPath(item);
    }

    public String getItemPath(class_1935 item) {
        return class_7923.field_41178.method_10221((Object)item.method_8389()).method_12832();
    }

    public String getRecipeName(class_1935 item) {
        return this.getItemPath(item);
    }

    public String convertBetween(class_1935 to, class_1935 from) {
        return this.getItemPath(to) + "_from_" + this.getItemPath(from);
    }

    public String getSmeltingItemPath(class_1935 item) {
        return this.getItemPath(item) + "_from_smelting";
    }

    public String getBlastingItemPath(class_1935 item) {
        return this.getItemPath(item) + "_from_blasting";
    }

    protected Builder create(class_1935 icon, String baseName) {
        return this.create(icon, baseName, Optional.empty(), Optional.empty(), true, true, false);
    }

    protected Builder create(class_1935 icon, String baseName, Optional<class_2960> background, Optional<class_189> frame) {
        return this.create(icon, baseName, background, frame, true, true, false);
    }

    protected Builder create(class_1935 icon, String baseName, Optional<class_2960> background, Optional<class_189> frame, boolean showToast, boolean announceToChat, boolean hidden) {
        return Builder.create().display(icon, (class_2561)class_2561.method_43471((String)("advancement.blocktopia." + baseName + ".title")), (class_2561)class_2561.method_43471((String)("advancement.blocktopia." + baseName + ".description")), (class_2960)background.orElse(null), frame.orElse(class_189.field_1254), showToast, announceToChat, hidden);
    }

    protected static class Builder {
        private Optional<class_2960> parentObj = Optional.empty();
        private Optional<class_185> display = Optional.empty();
        private class_170 rewards = class_170.field_1167;
        private final ImmutableMap.Builder<String, class_175<?>> criteria = ImmutableMap.builder();
        private Optional<class_8782> requirements = Optional.empty();
        private class_8782.class_8797 merger = class_8782.class_8797.field_16882;
        private boolean sendsTelemetryEvent;

        protected Builder() {
        }

        public static Builder create() {
            return new Builder().sendsTelemetryEvent();
        }

        public static Builder createUntelemetered() {
            return new Builder();
        }

        public Builder parent(class_2960 parentId) {
            this.parentObj = Optional.of(parentId);
            return this;
        }

        public Builder display(class_1799 icon, class_2561 title, class_2561 description, @Nullable class_2960 background, class_189 frame, boolean showToast, boolean announceToChat, boolean hidden) {
            return this.display(new class_185(icon, title, description, Optional.ofNullable(background), frame, showToast, announceToChat, hidden));
        }

        public Builder display(class_1935 icon, class_2561 title, class_2561 description, @Nullable class_2960 background, class_189 frame, boolean showToast, boolean announceToChat, boolean hidden) {
            return this.display(new class_185(new class_1799((class_1935)icon.method_8389()), title, description, Optional.ofNullable(background), frame, showToast, announceToChat, hidden));
        }

        public Builder display(class_185 display) {
            this.display = Optional.of(display);
            return this;
        }

        public Builder rewards(class_170.class_171 builder) {
            return this.rewards(builder.method_751());
        }

        public Builder rewards(class_170 rewards) {
            this.rewards = rewards;
            return this;
        }

        public Builder criterion(String name, class_175<?> criterion) {
            this.criteria.put((Object)name, criterion);
            return this;
        }

        public Builder criteriaMerger(class_8782.class_8797 merger) {
            this.merger = merger;
            return this;
        }

        public Builder requirements(class_8782 requirements) {
            this.requirements = Optional.of(requirements);
            return this;
        }

        public Builder sendsTelemetryEvent() {
            this.sendsTelemetryEvent = true;
            return this;
        }

        public class_8779 build(class_2960 id) {
            ImmutableMap map = this.criteria.buildOrThrow();
            class_8782 advancementRequirements = this.requirements.orElseGet(() -> this.lambda$build$0((Map)map));
            return new class_8779(id, new class_161(this.parentObj, this.display, this.rewards, (Map)map, advancementRequirements, this.sendsTelemetryEvent));
        }

        public class_8779 build(Consumer<class_8779> exporter, class_2960 id) {
            class_8779 advancementEntry = this.build(id);
            exporter.accept(advancementEntry);
            return advancementEntry;
        }

        private /* synthetic */ class_8782 lambda$build$0(Map map) {
            return this.merger.create(map.keySet());
        }
    }
}

