/*
 * Decompiled with CFR 0.152.
 */
package github.mcdatapack.blocktopia.entity.custom;

import github.mcdatapack.blocktopia.Blocktopia;
import github.mcdatapack.blocktopia.config.BlocktopiaConfig;
import github.mcdatapack.blocktopia.entity.ModEntityTypes;
import github.mcdatapack.blocktopia.entity.ai.MonkeyNavigation;
import github.mcdatapack.blocktopia.util.ModTags;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.class_1266;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1341;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1353;
import net.minecraft.class_1361;
import net.minecraft.class_1376;
import net.minecraft.class_1391;
import net.minecraft.class_1394;
import net.minecraft.class_1408;
import net.minecraft.class_1429;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3730;
import net.minecraft.class_4050;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_7094;
import org.jetbrains.annotations.Nullable;

public class MonkeyEntity
extends class_1429 {
    private static final class_2940<Byte> MONKEY_CLIMBING = class_2945.method_12791(MonkeyEntity.class, (class_2941)class_2943.field_13319);
    private static final class_2940<Integer> MONKEY_VARIANT = class_2945.method_12791(MonkeyEntity.class, (class_2941)class_2943.field_13327);
    public final class_7094 idleAnimationState = new class_7094();
    private int idleAnimationTimeout = 0;

    public MonkeyEntity(class_1299<? extends MonkeyEntity> entityType, class_1937 world) {
        super(entityType, world);
    }

    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData) {
        Variants variant = (Variants)((Object)class_156.method_27173((Object[])Variants.values(), (class_5819)this.field_5974));
        this.setVariant(variant);
        return super.method_5943(world, difficulty, spawnReason, entityData);
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(MONKEY_CLIMBING, (Object)0);
        builder.method_56912(MONKEY_VARIANT, (Object)0);
    }

    private void updateAnimationStates() {
        if (this.idleAnimationTimeout <= 0) {
            this.idleAnimationTimeout = this.field_5974.method_43048(40) + 80;
            this.idleAnimationState.method_41322(this.field_6012);
        } else {
            --this.idleAnimationTimeout;
        }
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new class_1341((class_1429)this, 1.2554));
        this.field_6201.method_6277(2, (class_1352)new class_1391((class_1314)this, 0.45, (Predicate)class_1856.method_8106(ModTags.Items.MONKEY_BREEDING_ITEMS), false));
        this.field_6201.method_6277(3, (class_1352)new class_1353((class_1429)this, 0.45));
        this.field_6201.method_6277(4, (class_1352)new class_1394((class_1314)this, 0.31));
        this.field_6201.method_6277(5, (class_1352)new class_1361((class_1308)this, class_1657.class, 15.0f));
        this.field_6201.method_6277(6, (class_1352)new class_1376((class_1308)this));
    }

    protected class_1408 method_5965(class_1937 world) {
        return new MonkeyNavigation((class_1308)this, world);
    }

    public void method_5773() {
        if (this.getVariant() == null) {
            this.setVariant(Variants.BROWN);
        }
        super.method_5773();
        if (this.method_37908().field_9236) {
            this.updateAnimationStates();
        } else {
            this.setClimbingWall(this.field_5976);
        }
    }

    public boolean method_6481(class_1799 stack) {
        return stack.method_31573(ModTags.Items.MONKEY_BREEDING_ITEMS);
    }

    public static class_5132.class_5133 createMonkeyAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 10.0).method_26868(class_5134.field_49079, 1000.0).method_26868(class_5134.field_23719, (double)0.4f);
    }

    @Nullable
    public class_1296 method_5613(class_3218 world, class_1296 entity) {
        if (!(entity instanceof MonkeyEntity)) {
            return null;
        }
        MonkeyEntity monkeyEntity = (MonkeyEntity)entity;
        MonkeyEntity baby = (MonkeyEntity)ModEntityTypes.MONKEY.method_5883((class_1937)world);
        Variants variant = Variants.getBreedVariant(this, monkeyEntity);
        assert (baby != null);
        baby.setVariant(variant);
        return baby;
    }

    @Nullable
    protected class_3414 method_6011(class_1282 source) {
        return class_3417.field_15115;
    }

    @Nullable
    protected class_3414 method_6002() {
        return class_3417.field_14904;
    }

    protected void method_48565(float posDelta) {
        float f = this.method_18376() == class_4050.field_18076 ? Math.min(posDelta * 6.0f, 1.0f) : 0.0f;
        this.field_42108.method_48568(f, 0.2f);
    }

    public boolean method_6101() {
        return this.field_5976 && this.isClimbingWall();
    }

    public boolean isClimbingWall() {
        return ((Byte)this.field_6011.method_12789(MONKEY_CLIMBING) & 1) != 0;
    }

    public void setClimbingWall(boolean climbing) {
        byte b = (Byte)this.field_6011.method_12789(MONKEY_CLIMBING);
        b = climbing ? (byte)(b | 1) : (byte)(b & 0xFFFFFFFE);
        this.field_6011.method_12778(MONKEY_CLIMBING, (Object)b);
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10569("Variant", this.getTypeVariant());
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.setVariant(Variants.BY_ID[nbt.method_10550("Variant")]);
    }

    public Variants getVariant() {
        return Variants.byId(this.getTypeVariant() & 0xFF);
    }

    private int getTypeVariant() {
        return (Integer)this.field_6011.method_12789(MONKEY_VARIANT);
    }

    private void setVariant(Variants variant) {
        this.field_6011.method_12778(MONKEY_VARIANT, (Object)(variant.getId() & 0xFF));
    }

    protected int method_6110() {
        return 10 + this.method_37908().field_9229.method_43048(10);
    }

    public static enum Variants {
        BROWN(0, "brown"),
        RED(1, "red"),
        BLACK(2, "black");

        private static final Variants[] BY_ID;
        private final int id;
        private final String fileName;

        private Variants(int id, String fileName) {
            this.id = id;
            this.fileName = "textures/entity/monkey/" + fileName + ".png";
        }

        public int getId() {
            return this.id;
        }

        public String getFileName() {
            return this.fileName;
        }

        public static Variants byId(int id) {
            return BY_ID[id];
        }

        public static Map<Variants, class_2960> textures() {
            HashMap<Variants, class_2960> result = new HashMap<Variants, class_2960>();
            for (Variants variant : Variants.values()) {
                result.put(variant, Blocktopia.id(variant.getFileName()));
            }
            return result;
        }

        public static Variants getBreedVariant(MonkeyEntity obj1, MonkeyEntity obj2) {
            if (BlocktopiaConfig.getConfig().randomMonkeyVariant) {
                class_156.method_27173((Object[])Variants.values(), (class_5819)obj1.field_5974);
            }
            Variants variant1 = obj1.getVariant();
            Variants variant2 = obj2.getVariant();
            return (Variants)((Object)class_156.method_27173((Object[])new Variants[]{variant1, variant2}, (class_5819)obj1.field_5974));
        }

        static {
            BY_ID = (Variants[])Arrays.stream(Variants.values()).sorted(Comparator.comparingInt(Variants::getId)).toArray(Variants[]::new);
        }
    }
}

