/*
 * Decompiled with CFR 0.152.
 */
package github.mcdatapack.blocktopia.screen.custom.widget;

import github.mcdatapack.blocktopia.block.entity.custom.FluidTankBlockEntity;
import github.mcdatapack.blocktopia.util.ScreenUtils;
import java.util.List;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.client.render.fluid.v1.FluidRenderHandler;
import net.fabricmc.fabric.api.client.render.fluid.v1.FluidRenderHandlerRegistry;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.minecraft.class_1058;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_4068;
import net.minecraft.class_5250;
import net.minecraft.class_638;
import net.minecraft.class_8021;

public class FluidWidget
implements class_4068,
class_8021 {
    private final FluidTankBlockEntity blockEntity;
    private final int width;
    private final int height;
    private int x;
    private int y;

    public FluidWidget(FluidTankBlockEntity blockEntity, int x, int y, int width, int height) {
        this.blockEntity = blockEntity;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public static Builder builder(FluidTankBlockEntity blockEntity) {
        return new Builder(blockEntity);
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        FluidTankBlockEntity.ResizableFluidStorage fluidStorage = this.blockEntity.getFluidTank();
        long fluidAmount = fluidStorage.getAmount();
        if (fluidAmount <= 0L) {
            return;
        }
        class_3611 fluid = ((FluidVariant)fluidStorage.variant).getFluid();
        long fluidCapacity = this.blockEntity.getCapacity();
        int fluidHeight = Math.round((float)fluidAmount / (float)fluidCapacity * (float)this.height);
        FluidRenderHandler fluidRenderHandler = FluidRenderHandlerRegistry.INSTANCE.get(fluid);
        if (fluidRenderHandler == null) {
            return;
        }
        class_2338 pos = this.blockEntity.method_11016();
        class_3610 fluidState = fluid.method_15785();
        class_638 world = class_310.method_1551().field_1687;
        if (world == null) {
            return;
        }
        class_1058 sprite = fluidRenderHandler.getFluidSprites((class_1920)world, pos, fluidState)[0];
        int tintColor = fluidRenderHandler.getFluidColor((class_1920)world, pos, fluidState);
        float red = (float)(tintColor >> 16 & 0xFF) / 255.0f;
        float green = (float)(tintColor >> 8 & 0xFF) / 255.0f;
        float blue = (float)(tintColor & 0xFF) / 255.0f;
        ScreenUtils.renderTiledSprite(context, sprite, this.x, this.y + this.height - fluidHeight, this.width, fluidHeight, red, green, blue, 1.0f);
        if (FluidWidget.isPointWithinBounds(this.x, this.y, this.width, this.height, mouseX, mouseY)) {
            this.drawTooltip(context, mouseX, mouseY);
        }
    }

    protected void drawTooltip(class_332 context, int mouseX, int mouseY) {
        FluidTankBlockEntity.ResizableFluidStorage fluidStorage = this.blockEntity.getFluidTank();
        class_3611 fluid = ((FluidVariant)fluidStorage.variant).getFluid();
        long fluidAmount = fluidStorage.getAmount();
        long fluidCapacity = this.blockEntity.getCapacity();
        class_327 textRenderer = class_310.method_1551().field_1772;
        if (fluid != null && fluidAmount > 0L) {
            List<class_5250> texts = List.of(class_2561.method_43471((String)fluid.method_15785().method_15759().method_26204().method_9539()), class_2561.method_43470((String)"%s / %s B".formatted(FluidWidget.getB(fluidAmount), FluidWidget.getB(fluidCapacity))));
            context.method_51434(textRenderer, texts, mouseX, mouseY);
        }
    }

    private static long getB(long amount) {
        return (long)((float)amount / 81000.0f);
    }

    private static boolean isPointWithinBounds(int x, int y, int width, int height, int pointX, int pointY) {
        return pointX >= x && pointX <= x + width && pointY >= y && pointY <= y + height;
    }

    public void method_46421(int x) {
        this.x = x;
    }

    public void method_46419(int y) {
        this.y = y;
    }

    public int method_46426() {
        return this.x;
    }

    public int method_46427() {
        return this.y;
    }

    public int method_25368() {
        return this.width;
    }

    public int method_25364() {
        return this.height;
    }

    public void method_48206(Consumer<class_339> consumer) {
    }

    public static class Builder {
        private final FluidTankBlockEntity blockEntity;
        private int x;
        private int y;
        private int width;
        private int height;

        public Builder(FluidTankBlockEntity blockEntity) {
            this.blockEntity = blockEntity;
        }

        public Builder x(int x) {
            this.x = x;
            return this;
        }

        public Builder y(int y) {
            this.y = y;
            return this;
        }

        public Builder position(int x, int y) {
            this.x = x;
            this.y = y;
            return this;
        }

        public Builder width(int width) {
            this.width = width;
            return this;
        }

        public Builder height(int height) {
            this.height = height;
            return this;
        }

        public Builder size(int width, int height) {
            this.width = width;
            this.height = height;
            return this;
        }

        public Builder bounds(int x, int y, int width, int height) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
            return this;
        }

        public FluidWidget build() {
            return new FluidWidget(this.blockEntity, this.x, this.y, this.width, this.height);
        }
    }
}

