/*
 * Decompiled with CFR 0.152.
 */
package com.etema.ragnarstats.client.ui;

import com.etema.ragnarcore.api.RagnarCoreAPI;
import com.etema.ragnarcore.api.stats.IPlayerStats;
import com.etema.ragnarstats.config.ClientConfig;
import com.etema.ragnarstats.core.progression.ExpTable;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="ragnarstats", value={Dist.CLIENT})
public final class ExperienceHudOverlay {
    private static final int BAR_HEIGHT = 6;
    private static final int BAR_MARGIN = 4;
    public static final int HANDLE_SIZE = 8;
    private static final int PADDING = 4;

    private ExperienceHudOverlay() {
    }

    public static int getOverlayHeight(Font font) {
        Objects.requireNonNull(font);
        int lineHeight = 9;
        return 4 + lineHeight + 4 + lineHeight + 4 + lineHeight + 4;
    }

    public static void renderOverlay(GuiGraphics graphics, Font font, IPlayerStats stats, String playerName, int x, int y, int width) {
        Objects.requireNonNull(font);
        int lineHeight = 9;
        int currentY = y + 4;
        graphics.m_280509_(x, y, x + width, y + ExperienceHudOverlay.getOverlayHeight(font), -2146430960);
        graphics.m_280614_(font, (Component)Component.m_237110_((String)"screen.ragnarstats.overlay.name", (Object[])new Object[]{playerName}), x + 4, currentY, 0xFFFFFF, false);
        currentY += lineHeight + 4;
        currentY = ExperienceHudOverlay.drawBar(graphics, font, (Component)Component.m_237110_((String)"screen.ragnarstats.overlay.level", (Object[])new Object[]{stats.getLevel()}), ExpTable.getProgressPercent(stats.getExp(), stats.getLevel()), x + 4, currentY, width - 8, -11751600);
        currentY = ExperienceHudOverlay.drawBar(graphics, font, (Component)Component.m_237110_((String)"screen.ragnarstats.overlay.job", (Object[])new Object[]{stats.getJobLevel()}), ExpTable.getJobProgressPercent(stats.getJobExp(), stats.getJobLevel()), x + 4, currentY, width - 8, -15108398);
        ExperienceHudOverlay.drawBorder(graphics, x, y, width, ExperienceHudOverlay.getOverlayHeight(font), 0x40FFFFFF);
    }

    private static int drawBar(GuiGraphics graphics, Font font, Component label, float progress, int x, int y, int width, int barColor) {
        Objects.requireNonNull(font);
        int lineHeight = 9;
        int labelWidth = font.m_92895_(label.getString());
        int barX = x + labelWidth + 6;
        int barWidth = Math.max(20, width - labelWidth - 6);
        int barY = y + (lineHeight - 6) / 2;
        graphics.m_280614_(font, label, x, y, 0xFFFFFF, false);
        graphics.m_280509_(barX, barY, barX + barWidth, barY + 6, -14671840);
        int filled = Mth.m_14045_((int)((int)((float)barWidth * progress)), (int)0, (int)barWidth);
        graphics.m_280509_(barX, barY, barX + filled, barY + 6, barColor);
        return y + lineHeight + 4;
    }

    private static void drawBorder(GuiGraphics graphics, int x, int y, int width, int height, int color) {
        graphics.m_280509_(x, y, x + width, y + 1, color);
        graphics.m_280509_(x, y + height - 1, x + width, y + height, color);
        graphics.m_280509_(x, y, x + 1, y + height, color);
        graphics.m_280509_(x + width - 1, y, x + width, y + height, color);
    }

    @SubscribeEvent
    public static void onRenderOverlay(RenderGuiOverlayEvent.Post event) {
        if (!((Boolean)ClientConfig.HUD_ENABLED.get()).booleanValue()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null || mc.f_91066_.f_92062_) {
            return;
        }
        LocalPlayer player = mc.f_91074_;
        RagnarCoreAPI.get((Player)player).ifPresent(arg_0 -> ExperienceHudOverlay.lambda$onRenderOverlay$0(mc, event, (Player)player, arg_0));
    }

    public static void renderPreview(GuiGraphics graphics, Font font, IPlayerStats stats, String playerName, int x, int y, int width) {
        ExperienceHudOverlay.renderOverlay(graphics, font, stats, playerName, x, y, width);
        int height = ExperienceHudOverlay.getOverlayHeight(font);
        graphics.m_280509_(x + width - 8, y + height - 8, x + width, y + height, -2130706433);
    }

    private static /* synthetic */ void lambda$onRenderOverlay$0(Minecraft mc, RenderGuiOverlayEvent.Post event, Player player, IPlayerStats stats) {
        int screenWidth = mc.m_91268_().m_85445_();
        int screenHeight = mc.m_91268_().m_85446_();
        Font font = mc.f_91062_;
        int overlayHeight = ExperienceHudOverlay.getOverlayHeight(font);
        int requestedWidth = (Integer)ClientConfig.HUD_WIDTH.get();
        int overlayWidth = Mth.m_14045_((int)requestedWidth, (int)120, (int)Math.max(120, screenWidth));
        double anchorX = Mth.m_14008_((double)((Double)ClientConfig.HUD_ANCHOR_X.get()), (double)0.0, (double)1.0);
        double anchorY = Mth.m_14008_((double)((Double)ClientConfig.HUD_ANCHOR_Y.get()), (double)0.0, (double)1.0);
        int maxX = Math.max(0, screenWidth - overlayWidth);
        int maxY = Math.max(0, screenHeight - overlayHeight);
        int x = (int)Math.round(anchorX * (double)maxX);
        int y = (int)Math.round(anchorY * (double)maxY);
        ExperienceHudOverlay.renderOverlay(event.getGuiGraphics(), font, stats, player.m_7755_().getString(), x, y, overlayWidth);
    }
}

