/*
 * Decompiled with CFR 0.152.
 */
package com.etema.ragnarstats.client.ui;

import com.etema.ragnarcore.api.RagnarCoreAPI;
import com.etema.ragnarstats.client.ui.ExperienceHudOverlay;
import com.etema.ragnarstats.config.ClientConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;

public class HudOverlayConfigScreen
extends Screen {
    private static final int MIN_WIDTH = 120;
    private static final int MAX_WIDTH = 400;
    private double anchorX;
    private double anchorY;
    private int hudWidth;
    private boolean dragging;
    private boolean resizing;
    private int dragOffsetX;
    private int dragOffsetY;

    public HudOverlayConfigScreen() {
        super((Component)Component.m_237115_((String)"screen.ragnarstats.overlay.title"));
    }

    protected void m_7856_() {
        super.m_7856_();
        this.anchorX = Mth.m_14008_((double)((Double)ClientConfig.HUD_ANCHOR_X.get()), (double)0.0, (double)1.0);
        this.anchorY = Mth.m_14008_((double)((Double)ClientConfig.HUD_ANCHOR_Y.get()), (double)0.0, (double)1.0);
        this.hudWidth = Mth.m_14045_((int)((Integer)ClientConfig.HUD_WIDTH.get()), (int)120, (int)400);
        int buttonWidth = 80;
        int buttonHeight = 20;
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"screen.ragnarstats.overlay.button.done"), btn -> this.m_7379_()).m_252987_(this.f_96543_ / 2 - buttonWidth / 2, this.f_96544_ - buttonHeight - 20, buttonWidth, buttonHeight).m_253136_());
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(graphics);
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        int overlayWidth = this.getOverlayWidth();
        int overlayHeight = ExperienceHudOverlay.getOverlayHeight(this.f_96547_);
        int overlayX = this.getOverlayX();
        int overlayY = this.getOverlayY();
        graphics.m_280653_(this.f_96547_, (Component)Component.m_237115_((String)"screen.ragnarstats.overlay.instructions.move"), this.f_96543_ / 2, 20, 0xFFFFFF);
        graphics.m_280653_(this.f_96547_, (Component)Component.m_237115_((String)"screen.ragnarstats.overlay.instructions.resize"), this.f_96543_ / 2, 32, 0xFFFFFF);
        if (player != null) {
            RagnarCoreAPI.get((Player)player).ifPresent(stats -> ExperienceHudOverlay.renderPreview(graphics, this.f_96547_, stats, player.m_7755_().getString(), overlayX, overlayY, overlayWidth));
        }
        graphics.m_280614_(this.f_96547_, (Component)Component.m_237110_((String)"screen.ragnarstats.overlay.width", (Object[])new Object[]{overlayWidth}), overlayX, overlayY + overlayHeight + 6, 0xAAAAAA, false);
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (button == 0) {
            int overlayX = this.getOverlayX();
            int overlayY = this.getOverlayY();
            int overlayWidth = this.getOverlayWidth();
            int overlayHeight = ExperienceHudOverlay.getOverlayHeight(this.f_96547_);
            int handleX = overlayX + overlayWidth - 8;
            int handleY = overlayY + overlayHeight - 8;
            if (mouseX >= (double)handleX && mouseX <= (double)(overlayX + overlayWidth) && mouseY >= (double)handleY && mouseY <= (double)(overlayY + overlayHeight)) {
                this.resizing = true;
                this.dragOffsetX = (int)(mouseX - (double)overlayX);
                this.dragOffsetY = (int)(mouseY - (double)overlayY);
                return true;
            }
            if (mouseX >= (double)overlayX && mouseX <= (double)(overlayX + overlayWidth) && mouseY >= (double)overlayY && mouseY <= (double)(overlayY + overlayHeight)) {
                this.dragging = true;
                this.dragOffsetX = (int)(mouseX - (double)overlayX);
                this.dragOffsetY = (int)(mouseY - (double)overlayY);
                return true;
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.dragging = false;
            this.resizing = false;
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (button == 0) {
            if (this.dragging) {
                int newX = (int)Math.round(mouseX) - this.dragOffsetX;
                int newY = (int)Math.round(mouseY) - this.dragOffsetY;
                this.updateAnchor(newX, newY);
                return true;
            }
            if (this.resizing) {
                int overlayX = this.getOverlayX();
                int newWidth = (int)Math.round(mouseX) - overlayX;
                this.setWidth(newWidth);
                return true;
            }
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    private void setWidth(int newWidth) {
        int clamped;
        this.hudWidth = clamped = Mth.m_14045_((int)newWidth, (int)120, (int)Math.min(400, this.f_96543_));
    }

    private void updateAnchor(int pixelX, int pixelY) {
        int overlayWidth = this.getOverlayWidth();
        int overlayHeight = ExperienceHudOverlay.getOverlayHeight(this.f_96547_);
        int maxX = Math.max(0, this.f_96543_ - overlayWidth);
        int maxY = Math.max(0, this.f_96544_ - overlayHeight);
        int clampedX = Mth.m_14045_((int)pixelX, (int)0, (int)maxX);
        int clampedY = Mth.m_14045_((int)pixelY, (int)0, (int)maxY);
        this.anchorX = maxX == 0 ? 0.0 : (double)clampedX / (double)maxX;
        this.anchorY = maxY == 0 ? 0.0 : (double)clampedY / (double)maxY;
    }

    private int getOverlayWidth() {
        return Mth.m_14045_((int)this.hudWidth, (int)120, (int)Math.min(400, this.f_96543_));
    }

    private int getOverlayX() {
        int overlayWidth = this.getOverlayWidth();
        int maxX = Math.max(0, this.f_96543_ - overlayWidth);
        return (int)Math.round(this.anchorX * (double)maxX);
    }

    private int getOverlayY() {
        int overlayHeight = ExperienceHudOverlay.getOverlayHeight(this.f_96547_);
        int maxY = Math.max(0, this.f_96544_ - overlayHeight);
        return (int)Math.round(this.anchorY * (double)maxY);
    }

    public void m_7379_() {
        ClientConfig.HUD_ANCHOR_X.set((Object)Mth.m_14008_((double)this.anchorX, (double)0.0, (double)1.0));
        ClientConfig.HUD_ANCHOR_Y.set((Object)Mth.m_14008_((double)this.anchorY, (double)0.0, (double)1.0));
        ClientConfig.HUD_WIDTH.set((Object)this.getOverlayWidth());
        super.m_7379_();
    }

    public boolean m_7043_() {
        return false;
    }
}

