/*
 * Decompiled with CFR 0.152.
 */
package com.etema.ragnarstats.client.ui;

import com.etema.ragnarcore.api.RagnarCoreAPI;
import com.etema.ragnarcore.api.compute.DerivedStats;
import com.etema.ragnarcore.api.stats.IPlayerStats;
import com.etema.ragnarcore.api.stats.StatKeys;
import com.etema.ragnarstats.config.BalanceConfig;
import com.etema.ragnarstats.core.compute.StatComputer;
import com.etema.ragnarstats.core.net.AllocateStatPacket;
import com.etema.ragnarstats.core.net.Network;
import com.etema.ragnarstats.core.progression.ExpTable;
import com.etema.ragnarstats.core.progression.StatCost;
import com.google.common.collect.Multimap;
import java.util.EnumMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;

public class StatsScreen
extends Screen {
    private final Map<StatKeys, Button> plus = new EnumMap<StatKeys, Button>(StatKeys.class);

    public StatsScreen() {
        super((Component)Component.m_237115_((String)"screen.ragnarstats.title"));
    }

    protected void m_7856_() {
        int botonSize = 12;
        StatKeys[] statKeysArray = StatKeys.values();
        int n = statKeysArray.length;
        for (int i = 0; i < n; ++i) {
            StatKeys k;
            StatKeys key = k = statKeysArray[i];
            Button b = Button.m_253074_((Component)Component.m_237113_((String)"+"), btn -> this.allocate(key)).m_252987_(0, 0, botonSize, botonSize).m_253136_();
            this.m_142416_((GuiEventListener)b);
            this.plus.put(k, b);
        }
    }

    private void allocate(StatKeys key) {
        Network.CH.sendToServer((Object)new AllocateStatPacket(key));
    }

    public void m_88315_(GuiGraphics g, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(g);
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer p = mc.f_91074_;
        if (p != null) {
            RagnarCoreAPI.get((Player)p).ifPresent(s -> {
                int value;
                double screenW = this.f_96543_;
                double screenH = this.f_96544_;
                int centerX = (int)(screenW / 2.0);
                int centerY = (int)(screenH / 2.0);
                int leftX = centerX - 140;
                int rightX = centerX + 60;
                int topY = (int)(screenH * 0.18);
                g.m_280653_(mc.f_91062_, (Component)Component.m_237110_((String)"screen.ragnarstats.stats.level", (Object[])new Object[]{s.getLevel(), s.getExp(), ExpTable.expToNext(s.getLevel())}), centerX, topY, 0xFFFFFF);
                g.m_280653_(mc.f_91062_, (Component)Component.m_237110_((String)"screen.ragnarstats.stats.job", (Object[])new Object[]{s.getJobLevel(), s.getJobExp(), ExpTable.jobExpToNext(s.getJobLevel())}), centerX, topY += 12, 0x99CCFF);
                MutableComponent jobName = Component.m_237115_((String)("job.ragnarstats." + (s.getJobId() == null || s.getJobId().isBlank() ? "novice" : s.getJobId().replace("ragnarstats:", ""))));
                g.m_280653_(mc.f_91062_, (Component)Component.m_237110_((String)"screen.ragnarstats.stats.job_name", (Object[])new Object[]{jobName}), centerX, topY += 12, 0x99CCFF);
                topY += 12;
                int statsY = centerY - 40;
                int lineHeight = 20;
                int maxStat = (Integer)BalanceConfig.MAX_STAT_VALUE.get();
                g.m_280614_(mc.f_91062_, (Component)Component.m_237110_((String)"screen.ragnarstats.stats.points", (Object[])new Object[]{s.getStatPoints(), s.getSkillPoints()}), leftX, statsY, 0xFFFF66, false);
                statsY += 18;
                int maxWidth = 0;
                for (StatKeys key : StatKeys.values()) {
                    value = StatsScreen.getStatValue(s, key);
                    MutableComponent costText = value >= maxStat ? Component.m_237115_((String)"screen.ragnarstats.stats.max") : Component.m_237110_((String)"screen.ragnarstats.stats.cost", (Object[])new Object[]{StatCost.costToIncrease(value)});
                    MutableComponent statLine = Component.m_237110_((String)"screen.ragnarstats.stats.line", (Object[])new Object[]{StatsScreen.getStatName(key), value, costText});
                    maxWidth = Math.max(maxWidth, mc.f_91062_.m_92852_((FormattedText)statLine));
                }
                for (StatKeys key : StatKeys.values()) {
                    value = StatsScreen.getStatValue(s, key);
                    int cost = value >= maxStat ? 0 : StatCost.costToIncrease(value);
                    boolean canSpend = value < maxStat && s.getStatPoints() >= cost;
                    MutableComponent costText = value >= maxStat ? Component.m_237115_((String)"screen.ragnarstats.stats.max") : Component.m_237110_((String)"screen.ragnarstats.stats.cost", (Object[])new Object[]{cost});
                    MutableComponent statLine = Component.m_237110_((String)"screen.ragnarstats.stats.line", (Object[])new Object[]{StatsScreen.getStatName(key), value, costText});
                    g.m_280614_(mc.f_91062_, (Component)statLine, leftX, statsY, 0xFFFFFF, false);
                    Button button = this.plus.get(key);
                    if (button != null) {
                        button.f_93623_ = canSpend;
                        button.m_257544_(canSpend ? null : StatsScreen.createTooltip(value, maxStat, cost));
                        int botonX = leftX + maxWidth + 10;
                        Objects.requireNonNull(mc.f_91062_);
                        int botonY = statsY + 9 / 2 - button.m_93694_() / 2;
                        button.m_252865_(botonX);
                        button.m_253211_(botonY);
                    }
                    statsY += lineHeight;
                }
                double armaBase = StatsScreen.getWeaponDamage((Player)p);
                double armorEff = StatsScreen.getArmorEff((Player)p);
                DerivedStats d = StatComputer.compute((Player)p, s, armaBase, 1.6, 0.0, armorEff, 1.0);
                int derivedY = centerY - 40;
                g.m_280614_(mc.f_91062_, (Component)Component.m_237115_((String)"screen.ragnarstats.derived.offense_title"), rightX, derivedY, 0xFFAA00, false);
                g.m_280614_(mc.f_91062_, (Component)Component.m_237110_((String)"screen.ragnarstats.derived.atk", (Object[])new Object[]{String.format(Locale.ROOT, "%.1f", d.physicalAttack)}), rightX, derivedY += 12, 0xFFFFFF, false);
                g.m_280614_(mc.f_91062_, (Component)Component.m_237110_((String)"screen.ragnarstats.derived.matk", (Object[])new Object[]{String.format(Locale.ROOT, "%.1f", d.magicAttack)}), rightX, derivedY += 10, 0xFFFFFF, false);
                g.m_280614_(mc.f_91062_, (Component)Component.m_237110_((String)"screen.ragnarstats.derived.hit", (Object[])new Object[]{String.format(Locale.ROOT, "%.1f%%", d.accuracy * 100.0)}), rightX, derivedY += 10, 0xFFFFFF, false);
                g.m_280614_(mc.f_91062_, (Component)Component.m_237110_((String)"screen.ragnarstats.derived.crit", (Object[])new Object[]{String.format(Locale.ROOT, "%.1f%%", d.criticalChance * 100.0)}), rightX, derivedY += 10, 0xFFFFFF, false);
                g.m_280614_(mc.f_91062_, (Component)Component.m_237110_((String)"screen.ragnarstats.derived.aspd", (Object[])new Object[]{String.format(Locale.ROOT, "%.2f", d.attackSpeed)}), rightX, derivedY += 10, 0xFFFFFF, false);
                g.m_280614_(mc.f_91062_, (Component)Component.m_237115_((String)"screen.ragnarstats.derived.defense_title"), rightX, derivedY += 14, 0x4488FF, false);
                g.m_280614_(mc.f_91062_, (Component)Component.m_237110_((String)"screen.ragnarstats.derived.def", (Object[])new Object[]{String.format(Locale.ROOT, "%.1f", d.defense)}), rightX, derivedY += 12, 0xFFFFFF, false);
                g.m_280614_(mc.f_91062_, (Component)Component.m_237110_((String)"screen.ragnarstats.derived.mdef", (Object[])new Object[]{String.format(Locale.ROOT, "%.1f", d.magicDefense)}), rightX, derivedY += 10, 0xFFFFFF, false);
                g.m_280614_(mc.f_91062_, (Component)Component.m_237110_((String)"screen.ragnarstats.derived.hp", (Object[])new Object[]{String.format(Locale.ROOT, "%.0f", d.maxHealth)}), rightX, derivedY += 10, 0xFFFFFF, false);
                g.m_280614_(mc.f_91062_, (Component)Component.m_237110_((String)"screen.ragnarstats.derived.mana", (Object[])new Object[]{String.format(Locale.ROOT, "%.0f", d.maxMana)}), rightX, derivedY += 10, 0xFFFFFF, false);
                g.m_280614_(mc.f_91062_, (Component)Component.m_237110_((String)"screen.ragnarstats.derived.flee", (Object[])new Object[]{String.format(Locale.ROOT, "%.1f%%", d.flee * 100.0)}), rightX, derivedY += 10, 0xFFFFFF, false);
            });
        }
        super.m_88315_(g, mouseX, mouseY, partialTicks);
    }

    public boolean m_7043_() {
        return false;
    }

    private static double getWeaponDamage(Player p) {
        double base = p.m_21172_(Attributes.f_22281_);
        ItemStack main = p.m_21120_(InteractionHand.MAIN_HAND);
        Multimap mods = main.m_41638_(EquipmentSlot.MAINHAND);
        double add = 0.0;
        double multBase = 0.0;
        double multTotal = 0.0;
        for (Map.Entry e : mods.entries()) {
            if (e.getKey() != Attributes.f_22281_) continue;
            AttributeModifier m = (AttributeModifier)e.getValue();
            switch (m.m_22217_()) {
                case ADDITION: {
                    add += m.m_22218_();
                    break;
                }
                case MULTIPLY_BASE: {
                    multBase += m.m_22218_();
                    break;
                }
                case MULTIPLY_TOTAL: {
                    multTotal += m.m_22218_();
                }
            }
        }
        double withItem = (base * (1.0 + multBase) + add) * (1.0 + multTotal);
        float ench = EnchantmentHelper.m_44833_((ItemStack)main, (MobType)MobType.f_21640_);
        return withItem + (double)ench;
    }

    private static double getArmorEff(Player p) {
        return p.m_21230_();
    }

    private static int getStatValue(IPlayerStats stats, StatKeys key) {
        return switch (key) {
            default -> throw new IncompatibleClassChangeError();
            case StatKeys.STR -> stats.getSTR();
            case StatKeys.AGI -> stats.getAGI();
            case StatKeys.VIT -> stats.getVIT();
            case StatKeys.INT -> stats.getINT();
            case StatKeys.DEX -> stats.getDEX();
            case StatKeys.LUK -> stats.getLUK();
        };
    }

    private static Tooltip createTooltip(int value, int maxStat, int cost) {
        if (value >= maxStat) {
            return Tooltip.m_257550_((Component)Component.m_237115_((String)"screen.ragnarstats.tooltip.max"));
        }
        return Tooltip.m_257550_((Component)Component.m_237110_((String)"screen.ragnarstats.tooltip.points", (Object[])new Object[]{cost}));
    }

    private static Component getStatName(StatKeys key) {
        return Component.m_237115_((String)("stat.ragnarstats." + key.id()));
    }
}

