/*
 * Decompiled with CFR 0.152.
 */
package com.etema.ragnarstats.commands;

import com.etema.ragnarcore.api.RagnarCoreAPI;
import com.etema.ragnarcore.api.stats.IPlayerStats;
import com.etema.ragnarstats.config.BalanceConfig;
import com.etema.ragnarstats.core.progression.ExpTable;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Locale;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public final class StatsCommands {
    public static void register(CommandDispatcher<CommandSourceStack> d) {
        d.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"ragnarstats").then(Commands.m_82127_((String)"get").executes(ctx -> {
            ServerPlayer sp = ((CommandSourceStack)ctx.getSource()).m_81375_();
            return RagnarCoreAPI.get((Player)sp).map(s -> StatsCommands.showStats((CommandSourceStack)ctx.getSource(), s)).orElse(0);
        }))).then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"stat", (ArgumentType)StringArgumentType.word()).then(Commands.m_82129_((String)"value", (ArgumentType)IntegerArgumentType.integer((int)0, (int)999)).executes(ctx -> {
            ServerPlayer sp = ((CommandSourceStack)ctx.getSource()).m_81375_();
            String key = StringArgumentType.getString((CommandContext)ctx, (String)"stat").toUpperCase();
            int v = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"value");
            return RagnarCoreAPI.get((Player)sp).map(s -> {
                if (StatsCommands.applySet(s, key, v)) {
                    s.markDirty();
                    ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237115_((String)"commands.ragnarstats.ok"), false);
                    return 1;
                }
                return 0;
            }).orElse(0);
        }))))).then(Commands.m_82127_((String)"addexp").then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1, (int)1000000)).executes(ctx -> {
            ServerPlayer sp = ((CommandSourceStack)ctx.getSource()).m_81375_();
            int amt = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"amount");
            return RagnarCoreAPI.get((Player)sp).map(s -> {
                int gained = s.addExpAndProcessLevelUps(amt, ((Integer)BalanceConfig.POINTS_PER_LEVEL.get()).intValue(), ExpTable::expToNext);
                int jobGained = s.addJobExpAndProcessLevelUps(amt, ExpTable::jobExpToNext);
                s.markDirty();
                ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237110_((String)"commands.ragnarstats.exp_add", (Object[])new Object[]{amt, gained, jobGained}), false);
                return 1;
            }).orElse(0);
        })))).then(Commands.m_82127_((String)"addjobexp").then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1, (int)1000000)).executes(ctx -> {
            ServerPlayer sp = ((CommandSourceStack)ctx.getSource()).m_81375_();
            int amt = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"amount");
            return RagnarCoreAPI.get((Player)sp).map(s -> {
                int jobGained = s.addJobExpAndProcessLevelUps(amt, ExpTable::jobExpToNext);
                s.markDirty();
                ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237110_((String)"commands.ragnarstats.job_exp_add", (Object[])new Object[]{amt, jobGained}), false);
                return 1;
            }).orElse(0);
        }))));
        d.register((LiteralArgumentBuilder)Commands.m_82127_((String)"stats").executes(ctx -> {
            ServerPlayer sp = ((CommandSourceStack)ctx.getSource()).m_81375_();
            return RagnarCoreAPI.get((Player)sp).map(s -> StatsCommands.showStats((CommandSourceStack)ctx.getSource(), s)).orElse(0);
        }));
        d.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"addstat").requires(src -> src.m_6761_(2))).then(Commands.m_82129_((String)"stat", (ArgumentType)StringArgumentType.word()).then(Commands.m_82129_((String)"value", (ArgumentType)IntegerArgumentType.integer((int)-999, (int)999)).executes(ctx -> {
            ServerPlayer sp = ((CommandSourceStack)ctx.getSource()).m_81375_();
            String statKey = StringArgumentType.getString((CommandContext)ctx, (String)"stat").toUpperCase();
            int delta = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"value");
            return RagnarCoreAPI.get((Player)sp).map(s -> {
                if (StatsCommands.applyAdd(s, statKey, delta)) {
                    s.markDirty();
                    ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237110_((String)"commands.ragnarstats.addstat", (Object[])new Object[]{statKey, delta}), false);
                    return 1;
                }
                return 0;
            }).orElse(0);
        }))));
    }

    private static int showStats(CommandSourceStack source, IPlayerStats stats) {
        String jobIdRaw = stats.getJobId();
        Object jobDisplay = jobIdRaw == null || jobIdRaw.isBlank() ? Component.m_237115_((String)"commands.ragnarstats.job.none") : jobIdRaw;
        source.m_288197_(() -> Component.m_237110_((String)"commands.ragnarstats.summary", (Object[])new Object[]{stats.getLevel(), stats.getExp(), stats.getStatPoints(), stats.getJobLevel(), stats.getJobExp(), stats.getSkillPoints(), jobDisplay, stats.getSTR(), stats.getAGI(), stats.getVIT(), stats.getINT(), stats.getDEX(), stats.getLUK(), String.format(Locale.ROOT, "%.1f", stats.getMana())}), false);
        return 1;
    }

    private static boolean applySet(IPlayerStats stats, String key, int value) {
        return switch (key) {
            case "STR" -> {
                stats.setSTR(value);
                yield true;
            }
            case "AGI" -> {
                stats.setAGI(value);
                yield true;
            }
            case "VIT" -> {
                stats.setVIT(value);
                yield true;
            }
            case "INT" -> {
                stats.setINT(value);
                yield true;
            }
            case "DEX" -> {
                stats.setDEX(value);
                yield true;
            }
            case "LUK" -> {
                stats.setLUK(value);
                yield true;
            }
            case "LEVEL" -> {
                stats.setLevel(value);
                yield true;
            }
            case "EXP" -> {
                stats.setExp(value);
                yield true;
            }
            case "SP", "STATPOINTS" -> {
                stats.setStatPoints(value);
                yield true;
            }
            case "JOBLEVEL" -> {
                stats.setJobLevel(value);
                yield true;
            }
            case "JOBEXP" -> {
                stats.setJobExp(value);
                yield true;
            }
            case "SKILLPOINTS" -> {
                stats.setSkillPoints(value);
                yield true;
            }
            default -> false;
        };
    }

    private static boolean applyAdd(IPlayerStats stats, String key, int delta) {
        return switch (key) {
            case "STR" -> {
                stats.setSTR(stats.getSTR() + delta);
                yield true;
            }
            case "AGI" -> {
                stats.setAGI(stats.getAGI() + delta);
                yield true;
            }
            case "VIT" -> {
                stats.setVIT(stats.getVIT() + delta);
                yield true;
            }
            case "INT" -> {
                stats.setINT(stats.getINT() + delta);
                yield true;
            }
            case "DEX" -> {
                stats.setDEX(stats.getDEX() + delta);
                yield true;
            }
            case "LUK" -> {
                stats.setLUK(stats.getLUK() + delta);
                yield true;
            }
            case "LEVEL" -> {
                stats.setLevel(stats.getLevel() + delta);
                yield true;
            }
            case "EXP" -> {
                stats.setExp(stats.getExp() + delta);
                yield true;
            }
            case "SP", "STATPOINTS" -> {
                stats.setStatPoints(stats.getStatPoints() + delta);
                yield true;
            }
            case "JOBLEVEL" -> {
                stats.setJobLevel(stats.getJobLevel() + delta);
                yield true;
            }
            case "JOBEXP" -> {
                stats.setJobExp(stats.getJobExp() + delta);
                yield true;
            }
            case "SKILLPOINTS" -> {
                stats.setSkillPoints(stats.getSkillPoints() + delta);
                yield true;
            }
            default -> false;
        };
    }
}

