/*
 * Decompiled with CFR 0.152.
 */
package com.etema.ragnarstats.compat;

import com.etema.ragnarcore.api.RagnarCoreAPI;
import com.etema.ragnarstats.config.BalanceConfig;
import com.etema.ragnarstats.core.compute.StatComputer;
import java.util.UUID;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="ragnarstats")
public class IronSpellsIntegration {
    private static final UUID MANA_MODIFIER_UUID = UUID.fromString("a1b2c3d4-e5f6-7890-abcd-ef1234567890");
    private static final UUID SPELL_POWER_UUID = UUID.fromString("b2c3d4e5-f6a7-8901-bcde-f12345678901");
    private static final UUID COOLDOWN_REDUCTION_UUID = UUID.fromString("c3d4e5f6-a7b8-9012-cdef-f23456789012");
    private static final UUID CAST_TIME_REDUCTION_UUID = UUID.fromString("d4e5f6a7-b8c9-0123-defa-f34567890123");
    private static final String MANA_ATTRIBUTE = "irons_spellbooks:max_mana";
    private static final String SPELL_POWER_ATTRIBUTE = "irons_spellbooks:spell_power";
    private static final String COOLDOWN_ATTRIBUTE = "irons_spellbooks:cooldown_reduction";
    private static final String CAST_TIME_ATTRIBUTE = "irons_spellbooks:cast_time_reduction";

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent e) {
        if (!((Boolean)BalanceConfig.ENABLE_IRON_INTEGRATION.get()).booleanValue()) {
            return;
        }
        if (e.phase != TickEvent.Phase.END || e.player.m_9236_().f_46443_) {
            return;
        }
        if (e.player.f_19797_ % 20 != 0) {
            return;
        }
        Player p = e.player;
        RagnarCoreAPI.get((Player)p).ifPresent(stats -> {
            int intel = stats.getINT();
            int dex = stats.getDEX();
            int luk = stats.getLUK();
            int level = stats.getLevel();
            IronSpellsIntegration.applyManaModifier(p, intel);
            IronSpellsIntegration.applySpellPowerModifier(p, intel, dex, luk, level);
            IronSpellsIntegration.applyCooldownReduction(p, dex);
            IronSpellsIntegration.applyCastTimeReduction(p, dex);
        });
    }

    private static void applyManaModifier(Player p, int intel) {
        try {
            AttributeInstance instance;
            Registry registry = p.m_9236_().m_9598_().m_175515_(Registries.f_256728_);
            Attribute manaAttr = (Attribute)registry.m_7745_(new ResourceLocation(MANA_ATTRIBUTE));
            if (manaAttr != null && (instance = p.m_21051_(manaAttr)) != null) {
                instance.m_22120_(MANA_MODIFIER_UUID);
                double manaBonus = (double)intel * (Double)BalanceConfig.INT_TO_IRON_MANA.get();
                if (manaBonus > 0.0) {
                    AttributeModifier modifier = new AttributeModifier(MANA_MODIFIER_UUID, "Ragnar Stats INT Mana Bonus", manaBonus, AttributeModifier.Operation.ADDITION);
                    instance.m_22125_(modifier);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void applySpellPowerModifier(Player p, int intel, int dex, int luk, int level) {
        try {
            AttributeInstance instance;
            Registry registry = p.m_9236_().m_9598_().m_175515_(Registries.f_256728_);
            Attribute spellPowerAttr = (Attribute)registry.m_7745_(new ResourceLocation(SPELL_POWER_ATTRIBUTE));
            if (spellPowerAttr != null && (instance = p.m_21051_(spellPowerAttr)) != null) {
                instance.m_22120_(SPELL_POWER_UUID);
                double spellPowerBonus = StatComputer.computeMagicalATK(intel, dex, luk, level);
                if (spellPowerBonus > 0.0) {
                    AttributeModifier modifier = new AttributeModifier(SPELL_POWER_UUID, "Ragnar Stats MATK Spell Power Bonus", spellPowerBonus, AttributeModifier.Operation.ADDITION);
                    instance.m_22125_(modifier);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void applyCooldownReduction(Player p, int dex) {
        try {
            AttributeInstance instance;
            Registry registry = p.m_9236_().m_9598_().m_175515_(Registries.f_256728_);
            Attribute cooldownAttr = (Attribute)registry.m_7745_(new ResourceLocation(COOLDOWN_ATTRIBUTE));
            if (cooldownAttr != null && (instance = p.m_21051_(cooldownAttr)) != null) {
                instance.m_22120_(COOLDOWN_REDUCTION_UUID);
                double cooldownReduction = (double)dex * 0.002;
                cooldownReduction = Math.min(0.5, cooldownReduction);
                if (cooldownReduction > 0.0) {
                    AttributeModifier modifier = new AttributeModifier(COOLDOWN_REDUCTION_UUID, "Ragnar Stats DEX Cooldown Reduction", cooldownReduction, AttributeModifier.Operation.MULTIPLY_BASE);
                    instance.m_22125_(modifier);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void applyCastTimeReduction(Player p, int dex) {
        try {
            AttributeInstance instance;
            Registry registry = p.m_9236_().m_9598_().m_175515_(Registries.f_256728_);
            Attribute castTimeAttr = (Attribute)registry.m_7745_(new ResourceLocation(CAST_TIME_ATTRIBUTE));
            if (castTimeAttr != null && (instance = p.m_21051_(castTimeAttr)) != null) {
                instance.m_22120_(CAST_TIME_REDUCTION_UUID);
                double castTimeReduction = (double)dex * 0.003;
                castTimeReduction = Math.min(0.7, castTimeReduction);
                if (castTimeReduction > 0.0) {
                    AttributeModifier modifier = new AttributeModifier(CAST_TIME_REDUCTION_UUID, "Ragnar Stats DEX Cast Time Reduction", castTimeReduction, AttributeModifier.Operation.MULTIPLY_BASE);
                    instance.m_22125_(modifier);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

