/*
 * Decompiled with CFR 0.152.
 */
package com.etema.ragnarstats.config;

import net.minecraftforge.common.ForgeConfigSpec;

public final class BalanceConfig {
    public static final ForgeConfigSpec SPEC;
    public static final ForgeConfigSpec.IntValue BASE_STAT_POINTS;
    public static final ForgeConfigSpec.IntValue POINTS_PER_LEVEL;
    public static final ForgeConfigSpec.DoubleValue EXP_BASE;
    public static final ForgeConfigSpec.DoubleValue EXP_GROWTH_RATE;
    public static final ForgeConfigSpec.IntValue EXP_MINIMUM;
    public static final ForgeConfigSpec.ConfigValue<String> EXP_CURVE_FORMULA;
    public static final ForgeConfigSpec.DoubleValue JOB_EXP_BASE;
    public static final ForgeConfigSpec.DoubleValue JOB_EXP_GROWTH_RATE;
    public static final ForgeConfigSpec.IntValue JOB_EXP_MINIMUM;
    public static final ForgeConfigSpec.ConfigValue<String> JOB_EXP_CURVE_FORMULA;
    public static final ForgeConfigSpec.DoubleValue MOB_EXP_HP_MULTIPLIER;
    public static final ForgeConfigSpec.DoubleValue MOB_EXP_ARMOR_BONUS;
    public static final ForgeConfigSpec.IntValue MOB_EXP_MINIMUM;
    public static final ForgeConfigSpec.IntValue MOB_EXP_MAXIMUM;
    public static final ForgeConfigSpec.BooleanValue MOB_EXP_SCALE_WITH_PLAYER_LEVEL;
    public static final ForgeConfigSpec.DoubleValue MOB_EXP_LEVEL_PENALTY_RANGE;
    public static final ForgeConfigSpec.DoubleValue MOB_EXP_LEVEL_PENALTY_MULT;
    public static final ForgeConfigSpec.DoubleValue APS_MAX;
    public static final ForgeConfigSpec.DoubleValue CRIT_MAX;
    public static final ForgeConfigSpec.DoubleValue FLEE_MAX;
    public static final ForgeConfigSpec.DoubleValue PERFECT_DODGE_MAX;
    public static final ForgeConfigSpec.DoubleValue DR_PHYS_MAX;
    public static final ForgeConfigSpec.DoubleValue DR_MAGIC_MAX;
    public static final ForgeConfigSpec.IntValue MAX_STAT_VALUE;
    public static final ForgeConfigSpec.IntValue MAX_LEVEL;
    public static final ForgeConfigSpec.DoubleValue STR_BASE_MULT;
    public static final ForgeConfigSpec.DoubleValue STR_SQUARED_MULT;
    public static final ForgeConfigSpec.IntValue STR_SQUARED_DIVISOR;
    public static final ForgeConfigSpec.DoubleValue DEX_TO_ATK_DIVISOR;
    public static final ForgeConfigSpec.DoubleValue LUK_TO_ATK_DIVISOR;
    public static final ForgeConfigSpec.DoubleValue LEVEL_TO_ATK_MULT;
    public static final ForgeConfigSpec.BooleanValue USE_STR_SQUARED;
    public static final ForgeConfigSpec.DoubleValue INT_BASE_MULT;
    public static final ForgeConfigSpec.DoubleValue INT_SQUARED_MULT;
    public static final ForgeConfigSpec.IntValue INT_SQUARED_DIVISOR;
    public static final ForgeConfigSpec.DoubleValue DEX_TO_MATK_DIVISOR;
    public static final ForgeConfigSpec.DoubleValue LUK_TO_MATK_DIVISOR;
    public static final ForgeConfigSpec.DoubleValue LEVEL_TO_MATK_MULT;
    public static final ForgeConfigSpec.BooleanValue USE_INT_SQUARED;
    public static final ForgeConfigSpec.DoubleValue HIT_BASE;
    public static final ForgeConfigSpec.DoubleValue DEX_TO_HIT_MULT;
    public static final ForgeConfigSpec.DoubleValue LUK_TO_HIT_DIVISOR;
    public static final ForgeConfigSpec.DoubleValue LEVEL_TO_HIT_MULT;
    public static final ForgeConfigSpec.DoubleValue FLEE_BASE;
    public static final ForgeConfigSpec.DoubleValue AGI_TO_FLEE_MULT;
    public static final ForgeConfigSpec.DoubleValue LUK_TO_FLEE_DIVISOR;
    public static final ForgeConfigSpec.DoubleValue LEVEL_TO_FLEE_MULT;
    public static final ForgeConfigSpec.DoubleValue HIT_FLEE_FORMULA_CONSTANT;
    public static final ForgeConfigSpec.DoubleValue LUK_TO_CRIT_DIVISOR;
    public static final ForgeConfigSpec.DoubleValue DEX_TO_CRIT_DIVISOR;
    public static final ForgeConfigSpec.DoubleValue CRIT_BASE_MULT;
    public static final ForgeConfigSpec.DoubleValue LUK_TO_CRIT_DMG_DIVISOR;
    public static final ForgeConfigSpec.DoubleValue STR_TO_CRIT_DMG_DIVISOR;
    public static final ForgeConfigSpec.DoubleValue PERFECT_DODGE_DIVISOR;
    public static final ForgeConfigSpec.DoubleValue BASE_ASPD;
    public static final ForgeConfigSpec.DoubleValue ASPD_MIN;
    public static final ForgeConfigSpec.DoubleValue AGI_TO_ASPD;
    public static final ForgeConfigSpec.DoubleValue DEX_TO_ASPD;
    public static final ForgeConfigSpec.IntValue ASPD_RO_MIN;
    public static final ForgeConfigSpec.IntValue ASPD_RO_MAX;
    public static final ForgeConfigSpec.DoubleValue CAST_FIXED_RATIO;
    public static final ForgeConfigSpec.DoubleValue CAST_MIN;
    public static final ForgeConfigSpec.DoubleValue CAST_REDUCTION_CAP;
    public static final ForgeConfigSpec.DoubleValue INT_TO_CAST_DIVISOR;
    public static final ForgeConfigSpec.DoubleValue DEX_TO_CAST_DIVISOR;
    public static final ForgeConfigSpec.DoubleValue VIT_SOFT_DEF_BASE;
    public static final ForgeConfigSpec.DoubleValue VIT_SOFT_DEF_SQUARED;
    public static final ForgeConfigSpec.IntValue VIT_SOFT_DEF_DIVISOR;
    public static final ForgeConfigSpec.DoubleValue VIT_HARD_DEF_MULT;
    public static final ForgeConfigSpec.DoubleValue ARMOR_HARD_DEF_MULT;
    public static final ForgeConfigSpec.DoubleValue HARD_DEF_CONSTANT;
    public static final ForgeConfigSpec.DoubleValue STR_TO_DEF_MULT;
    public static final ForgeConfigSpec.DoubleValue INT_MDEF_MULT;
    public static final ForgeConfigSpec.DoubleValue VIT_TO_MDEF_MULT;
    public static final ForgeConfigSpec.DoubleValue MDEF_SOFT_REDUCTION;
    public static final ForgeConfigSpec.DoubleValue MDEF_CONSTANT;
    public static final ForgeConfigSpec.DoubleValue HP_BASE;
    public static final ForgeConfigSpec.DoubleValue VIT_TO_HP_MULT;
    public static final ForgeConfigSpec.IntValue VIT_HP_BONUS_DIVISOR;
    public static final ForgeConfigSpec.DoubleValue STR_TO_HP_MULT;
    public static final ForgeConfigSpec.DoubleValue LEVEL_TO_HP_MULT;
    public static final ForgeConfigSpec.DoubleValue HP_REGEN_BASE;
    public static final ForgeConfigSpec.DoubleValue VIT_TO_HP_REGEN;
    public static final ForgeConfigSpec.DoubleValue HP_REGEN_MAX_PERCENT;
    public static final ForgeConfigSpec.DoubleValue MANA_BASE;
    public static final ForgeConfigSpec.DoubleValue INT_TO_MANA_MULT;
    public static final ForgeConfigSpec.IntValue INT_MANA_BONUS_DIVISOR;
    public static final ForgeConfigSpec.DoubleValue VIT_TO_MANA_MULT;
    public static final ForgeConfigSpec.DoubleValue LEVEL_TO_MANA_MULT;
    public static final ForgeConfigSpec.DoubleValue MANA_REGEN_BASE_PERCENT;
    public static final ForgeConfigSpec.DoubleValue INT_TO_MANA_REGEN;
    public static final ForgeConfigSpec.DoubleValue MANA_REGEN_MAX_PERCENT;
    public static final ForgeConfigSpec.DoubleValue MIN_DAMAGE_ROLL;
    public static final ForgeConfigSpec.DoubleValue DEX_VARIANCE_DIVISOR;
    public static final ForgeConfigSpec.DoubleValue LUK_VARIANCE_BONUS;
    public static final ForgeConfigSpec.DoubleValue INT_TO_IRON_MANA;
    public static final ForgeConfigSpec.DoubleValue INT_TO_IRON_SPELL_POWER;
    public static final ForgeConfigSpec.BooleanValue ENABLE_IRON_INTEGRATION;
    public static final ForgeConfigSpec.ConfigValue<String> CUSTOM_ATK_FORMULA;
    public static final ForgeConfigSpec.ConfigValue<String> CUSTOM_MATK_FORMULA;
    public static final ForgeConfigSpec.ConfigValue<String> CUSTOM_DEF_FORMULA;
    public static final ForgeConfigSpec.BooleanValue USE_CUSTOM_FORMULAS;

    static {
        ForgeConfigSpec.Builder b = new ForgeConfigSpec.Builder();
        b.push("progression");
        b.comment("Progression and experience system configuration");
        BASE_STAT_POINTS = b.comment("Base stat points granted to new characters").defineInRange("base_stat_points", 48, 0, 500);
        POINTS_PER_LEVEL = b.comment("Stat points gained per level up").defineInRange("points_per_level", 5, 0, 50);
        EXP_BASE = b.comment("Base experience required for level 2").defineInRange("exp_base", 100.0, 10.0, 10000.0);
        EXP_GROWTH_RATE = b.comment("Exponential growth multiplier per level (1.15 = 15% more per level)").defineInRange("exp_growth_rate", 1.15, 1.01, 3.0);
        EXP_MINIMUM = b.comment("Minimum experience required for any level").defineInRange("exp_minimum", 50, 1, 10000);
        EXP_CURVE_FORMULA = b.comment("Optional override hook identifier for EXP curve implementations").define("exp_curve", (Object)"default");
        JOB_EXP_BASE = b.comment("Base job experience required for job level 2").defineInRange("job_exp_base", 160.0, 10.0, 10000.0);
        JOB_EXP_GROWTH_RATE = b.comment("Growth multiplier per job level").defineInRange("job_exp_growth_rate", 1.22, 1.01, 3.0);
        JOB_EXP_MINIMUM = b.comment("Minimum job experience required for any level").defineInRange("job_exp_minimum", 120, 1, 10000);
        JOB_EXP_CURVE_FORMULA = b.comment("Optional override hook identifier for Job EXP curve implementations").define("job_exp_curve", (Object)"default");
        b.push("mob_experience");
        MOB_EXP_HP_MULTIPLIER = b.comment("Mob HP multiplier used to calculate experience").defineInRange("hp_multiplier", 5.0, 0.1, 100.0);
        MOB_EXP_ARMOR_BONUS = b.comment("Experience bonus per point of mob armor").defineInRange("armor_bonus", 2.0, 0.0, 50.0);
        MOB_EXP_MINIMUM = b.comment("Minimum experience per mob").defineInRange("minimum", 1, 0, 1000);
        MOB_EXP_MAXIMUM = b.comment("Maximum experience per mob").defineInRange("maximum", 50000, 1, 1000000);
        MOB_EXP_SCALE_WITH_PLAYER_LEVEL = b.comment("Apply level difference penalty?").define("scale_with_level", true);
        MOB_EXP_LEVEL_PENALTY_RANGE = b.comment("Level range without penalty").defineInRange("level_penalty_range", 5.0, 0.0, 50.0);
        MOB_EXP_LEVEL_PENALTY_MULT = b.comment("Penalty multiplier for levels outside the range").defineInRange("level_penalty_mult", 0.9, 0.0, 1.0);
        b.pop();
        b.pop();
        b.push("caps_and_limits");
        APS_MAX = b.comment("Maximum attacks per second").defineInRange("aps_max", 2.5, 0.5, 10.0);
        CRIT_MAX = b.comment("Maximum critical chance").defineInRange("crit_max", 0.6, 0.0, 1.0);
        FLEE_MAX = b.comment("Maximum flee value").defineInRange("flee_max", 0.6, 0.0, 1.0);
        PERFECT_DODGE_MAX = b.comment("Maximum perfect dodge").defineInRange("perfect_dodge_max", 0.6, 0.0, 1.0);
        DR_PHYS_MAX = b.comment("Maximum physical damage reduction").defineInRange("dr_phys_max", 0.9, 0.0, 1.0);
        DR_MAGIC_MAX = b.comment("Maximum magical damage reduction").defineInRange("dr_magic_max", 0.9, 0.0, 1.0);
        MAX_STAT_VALUE = b.comment("Maximum value for any stat").defineInRange("max_stat_value", 999, 99, 9999);
        MAX_LEVEL = b.comment("Maximum level").defineInRange("max_level", 100, 1, 9999);
        b.pop();
        b.push("physical_damage");
        b.comment("Formula: weaponATK + STR*mult + (STR/divisor)^2*squared_mult + DEX/dex_div + LUK/luk_div + LVL*lvl_mult");
        STR_BASE_MULT = b.defineInRange("str_base_multiplier", 1.0, 0.0, 10.0);
        USE_STR_SQUARED = b.comment("Use quadratic STR component?").define("use_str_squared", true);
        STR_SQUARED_MULT = b.defineInRange("str_squared_multiplier", 1.0, 0.0, 10.0);
        STR_SQUARED_DIVISOR = b.defineInRange("str_squared_divisor", 10, 1, 100);
        DEX_TO_ATK_DIVISOR = b.defineInRange("dex_divisor", 5.0, 1.0, 100.0);
        LUK_TO_ATK_DIVISOR = b.defineInRange("luk_divisor", 3.0, 1.0, 100.0);
        LEVEL_TO_ATK_MULT = b.defineInRange("level_multiplier", 0.0, 0.0, 10.0);
        b.pop();
        b.push("magic_damage");
        b.comment("Formula: spellBase + INT*mult + (INT/divisor)^2*squared_mult + DEX/dex_div + LUK/luk_div + LVL*lvl_mult");
        INT_BASE_MULT = b.defineInRange("int_base_multiplier", 2.0, 0.0, 10.0);
        USE_INT_SQUARED = b.comment("Use quadratic INT component?").define("use_int_squared", true);
        INT_SQUARED_MULT = b.defineInRange("int_squared_multiplier", 1.0, 0.0, 10.0);
        INT_SQUARED_DIVISOR = b.defineInRange("int_squared_divisor", 2, 1, 100);
        DEX_TO_MATK_DIVISOR = b.defineInRange("dex_divisor", 5.0, 1.0, 100.0);
        LUK_TO_MATK_DIVISOR = b.defineInRange("luk_divisor", 3.0, 1.0, 100.0);
        LEVEL_TO_MATK_MULT = b.defineInRange("level_multiplier", 0.0, 0.0, 10.0);
        b.pop();
        b.push("hit_and_flee");
        HIT_BASE = b.defineInRange("hit_base", 175.0, 0.0, 500.0);
        DEX_TO_HIT_MULT = b.defineInRange("dex_to_hit", 2.0, 0.0, 10.0);
        LUK_TO_HIT_DIVISOR = b.defineInRange("luk_to_hit_divisor", 3.0, 1.0, 100.0);
        LEVEL_TO_HIT_MULT = b.defineInRange("level_to_hit", 1.0, 0.0, 10.0);
        FLEE_BASE = b.defineInRange("flee_base", 100.0, 0.0, 500.0);
        AGI_TO_FLEE_MULT = b.defineInRange("agi_to_flee", 1.0, 0.0, 10.0);
        LUK_TO_FLEE_DIVISOR = b.defineInRange("luk_to_flee_divisor", 5.0, 1.0, 100.0);
        LEVEL_TO_FLEE_MULT = b.defineInRange("level_to_flee", 1.0, 0.0, 10.0);
        HIT_FLEE_FORMULA_CONSTANT = b.comment("Constant for the hit vs. flee formula").defineInRange("hit_flee_constant", 80.0, 0.0, 200.0);
        b.pop();
        b.push("critical");
        LUK_TO_CRIT_DIVISOR = b.defineInRange("luk_to_crit_divisor", 3.0, 1.0, 100.0);
        DEX_TO_CRIT_DIVISOR = b.comment("DEX contribution to critical chance").defineInRange("dex_to_crit_divisor", 0.0, 0.0, 100.0);
        CRIT_BASE_MULT = b.defineInRange("crit_damage_base", 1.5, 1.0, 10.0);
        LUK_TO_CRIT_DMG_DIVISOR = b.defineInRange("luk_to_crit_damage_divisor", 200.0, 1.0, 1000.0);
        STR_TO_CRIT_DMG_DIVISOR = b.comment("STR contribution to critical damage").defineInRange("str_to_crit_damage_divisor", 0.0, 0.0, 1000.0);
        PERFECT_DODGE_DIVISOR = b.defineInRange("luk_to_perfect_dodge_divisor", 10.0, 1.0, 100.0);
        b.pop();
        b.push("attack_speed_and_cast");
        BASE_ASPD = b.defineInRange("base_aspd", 1.2, 0.1, 5.0);
        ASPD_MIN = b.defineInRange("aspd_min", 0.5, 0.1, 2.0);
        AGI_TO_ASPD = b.defineInRange("agi_to_aspd", 0.4, 0.0, 2.0);
        DEX_TO_ASPD = b.defineInRange("dex_to_aspd", 0.2, 0.0, 2.0);
        ASPD_RO_MIN = b.defineInRange("aspd_ro_min", 144, 100, 200);
        ASPD_RO_MAX = b.defineInRange("aspd_ro_max", 190, 150, 250);
        CAST_FIXED_RATIO = b.defineInRange("cast_fixed_ratio", 0.2, 0.0, 1.0);
        CAST_MIN = b.defineInRange("cast_min", 0.05, 0.0, 1.0);
        CAST_REDUCTION_CAP = b.defineInRange("cast_reduction_cap", 1.0, 0.0, 1.0);
        INT_TO_CAST_DIVISOR = b.defineInRange("int_cast_divisor", 530.0, 1.0, 2000.0);
        DEX_TO_CAST_DIVISOR = b.defineInRange("dex_cast_divisor", 265.0, 1.0, 2000.0);
        b.pop();
        b.push("physical_defense");
        VIT_SOFT_DEF_BASE = b.defineInRange("vit_soft_def_base", 1.0, 0.0, 10.0);
        VIT_SOFT_DEF_SQUARED = b.defineInRange("vit_soft_def_squared", 0.2, 0.0, 5.0);
        VIT_SOFT_DEF_DIVISOR = b.defineInRange("vit_soft_def_divisor", 5, 1, 100);
        VIT_HARD_DEF_MULT = b.defineInRange("vit_hard_def_mult", 0.5, 0.0, 5.0);
        STR_TO_DEF_MULT = b.comment("STR contribution to physical defense").defineInRange("str_to_def_mult", 0.0, 0.0, 5.0);
        ARMOR_HARD_DEF_MULT = b.defineInRange("armor_hard_def_mult", 5.0, 0.0, 20.0);
        HARD_DEF_CONSTANT = b.defineInRange("hard_def_constant", 400.0, 1.0, 2000.0);
        b.pop();
        b.push("magic_defense");
        INT_MDEF_MULT = b.defineInRange("int_mdef_mult", 2.0, 0.0, 10.0);
        VIT_TO_MDEF_MULT = b.comment("VIT contribution to magical defense").defineInRange("vit_to_mdef_mult", 0.3, 0.0, 5.0);
        MDEF_SOFT_REDUCTION = b.defineInRange("int_soft_reduction", 0.3, 0.0, 5.0);
        MDEF_CONSTANT = b.defineInRange("mdef_constant", 400.0, 1.0, 2000.0);
        b.pop();
        b.push("hit_points");
        HP_BASE = b.defineInRange("hp_base", 20.0, 1.0, 1000.0);
        VIT_TO_HP_MULT = b.defineInRange("vit_to_hp", 0.6, 0.0, 10.0);
        VIT_HP_BONUS_DIVISOR = b.defineInRange("vit_hp_bonus_divisor", 5, 1, 100);
        STR_TO_HP_MULT = b.comment("STR contribution to HP").defineInRange("str_to_hp", 0.0, 0.0, 10.0);
        LEVEL_TO_HP_MULT = b.defineInRange("level_to_hp", 0.0, 0.0, 100.0);
        HP_REGEN_BASE = b.defineInRange("hp_regen_base_per_sec", 0.03, 0.0, 1.0);
        VIT_TO_HP_REGEN = b.defineInRange("vit_to_hp_regen_per_sec", 0.002, 0.0, 0.1);
        HP_REGEN_MAX_PERCENT = b.defineInRange("hp_regen_max_percent", 0.1, 0.0, 1.0);
        b.pop();
        b.push("mana_points");
        MANA_BASE = b.defineInRange("mana_base", 100.0, 0.0, 1000.0);
        INT_TO_MANA_MULT = b.defineInRange("int_to_mana", 3.0, 0.0, 20.0);
        INT_MANA_BONUS_DIVISOR = b.comment("Divisor for quadratic mana bonus").defineInRange("int_mana_bonus_divisor", 0, 0, 100);
        VIT_TO_MANA_MULT = b.defineInRange("vit_to_mana", 0.5, 0.0, 5.0);
        LEVEL_TO_MANA_MULT = b.defineInRange("level_to_mana", 0.0, 0.0, 100.0);
        MANA_REGEN_BASE_PERCENT = b.defineInRange("mana_regen_base_percent", 0.01, 0.0, 0.5);
        INT_TO_MANA_REGEN = b.defineInRange("int_to_mana_regen_bonus", 8.0E-4, 0.0, 0.01);
        MANA_REGEN_MAX_PERCENT = b.defineInRange("mana_regen_max_percent", 0.2, 0.0, 1.0);
        b.pop();
        b.push("damage_variance");
        MIN_DAMAGE_ROLL = b.defineInRange("min_damage_roll", 0.8, 0.0, 1.0);
        DEX_VARIANCE_DIVISOR = b.defineInRange("dex_variance_divisor", 200.0, 1.0, 1000.0);
        LUK_VARIANCE_BONUS = b.comment("LUK bonus to reduce variance").defineInRange("luk_variance_bonus", 0.0, 0.0, 1000.0);
        b.pop();
        b.push("irons_spells_integration");
        ENABLE_IRON_INTEGRATION = b.define("enable", true);
        INT_TO_IRON_MANA = b.comment("Additional Iron's Spells mana per point of INT").defineInRange("int_to_mana", 5.0, 0.0, 100.0);
        INT_TO_IRON_SPELL_POWER = b.comment("Percent spell power per point of INT").defineInRange("int_to_spell_power_percent", 0.005, 0.0, 0.1);
        b.pop();
        b.push("custom_formulas");
        USE_CUSTOM_FORMULAS = b.comment("Enable custom formulas (requires restart)").define("enable", false);
        CUSTOM_ATK_FORMULA = b.comment("Custom formula for ATK. Variables: STR, AGI, VIT, INT, DEX, LUK, LVL").define("atk_formula", (Object)"STR + Math.pow(STR/10, 2) + DEX/5 + LUK/3");
        CUSTOM_MATK_FORMULA = b.comment("Custom formula for MATK").define("matk_formula", (Object)"INT*2 + Math.pow(INT/2, 2) + DEX/5 + LUK/3");
        CUSTOM_DEF_FORMULA = b.comment("Custom formula for DEF").define("def_formula", (Object)"VIT + Math.pow(VIT/5, 2)*0.2");
        b.pop();
        SPEC = b.build();
    }
}

