/*
 * Decompiled with CFR 0.152.
 */
package com.etema.ragnarstats.core.capability;

import com.etema.ragnarcore.api.stats.IPlayerStats;
import com.etema.ragnarcore.api.stats.StatAttributes;
import com.etema.ragnarcore.api.stats.StatKeys;
import java.util.EnumMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.IntUnaryOperator;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.RangedAttribute;
import net.minecraft.world.entity.player.Player;

public class PlayerStats
implements IPlayerStats {
    private static final Map<StatKeys, UUID> BONUS_IDS = Map.of(StatKeys.STR, UUID.fromString("1ab0d08f-781c-43ea-9ad5-a78eb6231728"), StatKeys.AGI, UUID.fromString("b1c47f1d-8ea0-4e5f-a362-6c5c82cc0608"), StatKeys.VIT, UUID.fromString("4a8533de-5f6d-41c9-9f97-72b23aa5ce9d"), StatKeys.INT, UUID.fromString("8d35f17d-8e2b-4a9f-8b5d-90f40f6a28ab"), StatKeys.DEX, UUID.fromString("7630a31f-8df5-4f2d-92d5-7f84cbe9835d"), StatKeys.LUK, UUID.fromString("99167815-6883-4e4d-81b8-2d2e69366b9f"));
    private static final Map<StatKeys, String> BONUS_NAMES = new EnumMap<StatKeys, String>(StatKeys.class);
    private Player owner;
    private double mana = 0.0;
    private double manaMax = 100.0;
    private int level = 1;
    private int exp = 0;
    private int statPoints = 0;
    private int jobLevel = 1;
    private int jobExp = 0;
    private int skillPoints = 0;
    private String jobId = "ragnarstats:novice";
    private boolean baseStatPointsGranted = false;
    private boolean dirty = true;

    void bind(Player player) {
        this.owner = player;
    }

    public int getSTR() {
        return this.getBase(StatKeys.STR);
    }

    public void setSTR(int v) {
        this.setBase(StatKeys.STR, v);
    }

    public int getAGI() {
        return this.getBase(StatKeys.AGI);
    }

    public void setAGI(int v) {
        this.setBase(StatKeys.AGI, v);
    }

    public int getVIT() {
        return this.getBase(StatKeys.VIT);
    }

    public void setVIT(int v) {
        this.setBase(StatKeys.VIT, v);
    }

    public int getINT() {
        return this.getBase(StatKeys.INT);
    }

    public void setINT(int v) {
        this.setBase(StatKeys.INT, v);
    }

    public int getDEX() {
        return this.getBase(StatKeys.DEX);
    }

    public void setDEX(int v) {
        this.setBase(StatKeys.DEX, v);
    }

    public int getLUK() {
        return this.getBase(StatKeys.LUK);
    }

    public void setLUK(int v) {
        this.setBase(StatKeys.LUK, v);
    }

    public int getBonus(StatKeys key) {
        AttributeInstance inst = this.getInstance(key);
        if (inst == null) {
            return 0;
        }
        AttributeModifier mod = inst.m_22111_(BONUS_IDS.get(key));
        return mod == null ? 0 : (int)Math.round(mod.m_22218_());
    }

    public void addBonus(StatKeys key, int d) {
        this.setBonus(key, this.getBonus(key) + d);
    }

    public void setBonus(StatKeys key, int v) {
        AttributeInstance inst = this.getInstance(key);
        if (inst == null) {
            return;
        }
        UUID id = BONUS_IDS.get(key);
        AttributeModifier existing = inst.m_22111_(id);
        if (existing != null) {
            if (existing.m_22218_() == (double)v) {
                return;
            }
            inst.m_22130_(existing);
        }
        if (v != 0) {
            inst.m_22118_(new AttributeModifier(id, BONUS_NAMES.get(key), (double)v, AttributeModifier.Operation.ADDITION));
        }
        this.dirty = true;
    }

    public double getMana() {
        return this.mana;
    }

    public double getManaMax() {
        return this.manaMax;
    }

    public void setMana(double v) {
        this.mana = Math.max(0.0, Math.min(v, this.manaMax));
    }

    public void addMana(double dv) {
        this.setMana(this.mana + dv);
    }

    public void setManaMaxClient(double v) {
        this.manaMax = v;
        if (this.mana > this.manaMax) {
            this.mana = this.manaMax;
        }
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int lvl) {
        this.level = Math.max(1, lvl);
        this.dirty = true;
    }

    public int getExp() {
        return this.exp;
    }

    public void setExp(int e) {
        this.exp = Math.max(0, e);
        this.dirty = true;
    }

    public int getStatPoints() {
        return this.statPoints;
    }

    public void setStatPoints(int pts) {
        this.statPoints = Math.max(0, pts);
        this.dirty = true;
    }

    public int getJobLevel() {
        return this.jobLevel;
    }

    public void setJobLevel(int lvl) {
        this.jobLevel = Math.max(1, lvl);
        this.dirty = true;
    }

    public int getJobExp() {
        return this.jobExp;
    }

    public void setJobExp(int e) {
        this.jobExp = Math.max(0, e);
        this.dirty = true;
    }

    public int getSkillPoints() {
        return this.skillPoints;
    }

    public void setSkillPoints(int pts) {
        this.skillPoints = Math.max(0, pts);
        this.dirty = true;
    }

    public String getJobId() {
        return this.jobId;
    }

    public void setJobId(String jobId) {
        String normalized;
        String string = normalized = jobId == null ? "" : jobId;
        if (!normalized.equals(this.jobId)) {
            this.jobId = normalized;
            this.dirty = true;
        }
    }

    public int addExpAndProcessLevelUps(int add, int pointsPerLevel, IntUnaryOperator expToNext) {
        if (add <= 0) {
            return 0;
        }
        this.exp += add;
        int gained = 0;
        while (this.exp >= expToNext.applyAsInt(this.level)) {
            this.exp -= expToNext.applyAsInt(this.level);
            ++this.level;
            this.statPoints += Math.max(0, pointsPerLevel);
            ++gained;
        }
        this.dirty = true;
        return gained;
    }

    public int addJobExpAndProcessLevelUps(int add, IntUnaryOperator expToNext) {
        if (add <= 0) {
            return 0;
        }
        this.jobExp += add;
        int gained = 0;
        while (this.jobExp >= expToNext.applyAsInt(this.jobLevel)) {
            this.jobExp -= expToNext.applyAsInt(this.jobLevel);
            ++this.jobLevel;
            ++this.skillPoints;
            ++gained;
        }
        if (gained > 0 || add > 0) {
            this.dirty = true;
        }
        return gained;
    }

    public void markDirty() {
        this.dirty = true;
    }

    public boolean consumeDirty() {
        boolean d = this.dirty;
        this.dirty = false;
        return d;
    }

    public void ensureBaseStatBaseline(int basePoints) {
        if (!this.baseStatPointsGranted) {
            this.statPoints = Math.max(this.statPoints, Math.max(0, basePoints));
            this.baseStatPointsGranted = true;
            this.dirty = true;
        }
    }

    public boolean areBaseStatPointsGranted() {
        return this.baseStatPointsGranted;
    }

    public void setBaseStatPointsGranted(boolean granted) {
        this.baseStatPointsGranted = granted;
    }

    private int getBase(StatKeys key) {
        AttributeInstance inst = this.getInstance(key);
        if (inst == null) {
            return 0;
        }
        return (int)Math.round(inst.m_22115_());
    }

    private void setBase(StatKeys key, int value) {
        AttributeInstance inst = this.getInstance(key);
        if (inst == null) {
            return;
        }
        Attribute attribute = inst.m_22099_();
        double clamped = value;
        if (attribute instanceof RangedAttribute) {
            RangedAttribute ranged = (RangedAttribute)attribute;
            clamped = Mth.m_14008_((double)value, (double)ranged.m_147361_(), (double)ranged.m_147362_());
        }
        if (Double.compare(inst.m_22115_(), clamped) != 0) {
            inst.m_22100_(clamped);
            this.dirty = true;
        }
    }

    private AttributeInstance getInstance(StatKeys key) {
        if (this.owner == null) {
            return null;
        }
        Attribute attr = StatAttributes.getAttribute((StatKeys)key);
        return attr == null ? null : this.owner.m_21051_(attr);
    }

    static {
        for (StatKeys key : StatKeys.values()) {
            BONUS_NAMES.put(key, "ragnarstats_bonus_" + key.name().toLowerCase());
        }
    }
}

