/*
 * Decompiled with CFR 0.152.
 */
package com.etema.ragnarstats.core.capability;

import com.etema.ragnarcore.api.stats.IPlayerStats;
import com.etema.ragnarstats.core.capability.PlayerStats;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="ragnarstats")
public class PlayerStatsProvider
implements ICapabilityProvider,
INBTSerializable<CompoundTag> {
    public static final Capability<IPlayerStats> CAP = CapabilityManager.get((CapabilityToken)new CapabilityToken<IPlayerStats>(){});
    private final PlayerStats impl = new PlayerStats();
    private final LazyOptional<IPlayerStats> opt;

    public PlayerStatsProvider(Player owner) {
        this.impl.bind(owner);
        this.opt = LazyOptional.of(() -> this.impl);
    }

    @SubscribeEvent
    public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> evt) {
        Object object = evt.getObject();
        if (object instanceof Player) {
            Player player = (Player)object;
            evt.addCapability(new ResourceLocation("ragnarstats", "player_stats"), (ICapabilityProvider)new PlayerStatsProvider(player));
        }
    }

    @SubscribeEvent
    public static void onClone(PlayerEvent.Clone e) {
        e.getOriginal().getCapability(CAP).ifPresent(old -> e.getEntity().getCapability(CAP).ifPresent(cur -> {
            cur.setSTR(old.getSTR());
            cur.setAGI(old.getAGI());
            cur.setVIT(old.getVIT());
            cur.setINT(old.getINT());
            cur.setDEX(old.getDEX());
            cur.setLUK(old.getLUK());
            cur.setMana(old.getMana());
            cur.setLevel(old.getLevel());
            cur.setExp(old.getExp());
            cur.setStatPoints(old.getStatPoints());
            cur.setJobLevel(old.getJobLevel());
            cur.setJobExp(old.getJobExp());
            cur.setSkillPoints(old.getSkillPoints());
            cur.setJobId(old.getJobId());
            if (old instanceof PlayerStats) {
                PlayerStats oldImpl = (PlayerStats)old;
                if (cur instanceof PlayerStats) {
                    PlayerStats curImpl = (PlayerStats)cur;
                    curImpl.setBaseStatPointsGranted(oldImpl.areBaseStatPointsGranted());
                }
            }
            cur.markDirty();
        }));
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        return cap == CAP ? this.opt.cast() : LazyOptional.empty();
    }

    public CompoundTag serializeNBT() {
        CompoundTag n = new CompoundTag();
        n.m_128405_("STR", this.impl.getSTR());
        n.m_128405_("AGI", this.impl.getAGI());
        n.m_128405_("VIT", this.impl.getVIT());
        n.m_128405_("INT", this.impl.getINT());
        n.m_128405_("DEX", this.impl.getDEX());
        n.m_128405_("LUK", this.impl.getLUK());
        n.m_128347_("Mana", this.impl.getMana());
        n.m_128347_("ManaMax", this.impl.getManaMax());
        n.m_128405_("Level", this.impl.getLevel());
        n.m_128405_("Exp", this.impl.getExp());
        n.m_128405_("StatPoints", this.impl.getStatPoints());
        n.m_128405_("JobLevel", this.impl.getJobLevel());
        n.m_128405_("JobExp", this.impl.getJobExp());
        n.m_128405_("SkillPoints", this.impl.getSkillPoints());
        n.m_128359_("JobId", this.impl.getJobId());
        n.m_128379_("BaseStatPointsGranted", this.impl.areBaseStatPointsGranted());
        return n;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.impl.setSTR(nbt.m_128451_("STR"));
        this.impl.setAGI(nbt.m_128451_("AGI"));
        this.impl.setVIT(nbt.m_128451_("VIT"));
        this.impl.setINT(nbt.m_128451_("INT"));
        this.impl.setDEX(nbt.m_128451_("DEX"));
        this.impl.setLUK(nbt.m_128451_("LUK"));
        this.impl.setMana(nbt.m_128459_("Mana"));
        if (nbt.m_128441_("ManaMax")) {
            this.impl.setManaMaxClient(nbt.m_128459_("ManaMax"));
        }
        this.impl.setLevel(nbt.m_128441_("Level") ? nbt.m_128451_("Level") : 1);
        this.impl.setExp(nbt.m_128451_("Exp"));
        this.impl.setStatPoints(nbt.m_128451_("StatPoints"));
        this.impl.setJobLevel(nbt.m_128441_("JobLevel") ? nbt.m_128451_("JobLevel") : 1);
        this.impl.setJobExp(nbt.m_128451_("JobExp"));
        this.impl.setSkillPoints(nbt.m_128451_("SkillPoints"));
        this.impl.setJobId(nbt.m_128441_("JobId") ? nbt.m_128461_("JobId") : "");
        boolean granted = nbt.m_128441_("BaseStatPointsGranted") ? nbt.m_128471_("BaseStatPointsGranted") : !nbt.m_128456_();
        this.impl.setBaseStatPointsGranted(granted);
    }
}

