/*
 * Decompiled with CFR 0.152.
 */
package com.etema.ragnarstats.core.compute;

import com.etema.ragnarcore.api.compute.DerivedStats;
import com.etema.ragnarcore.api.events.StatComputeEvent;
import com.etema.ragnarcore.api.stats.IPlayerStats;
import com.etema.ragnarcore.api.stats.StatAttributes;
import com.etema.ragnarcore.api.stats.StatKeys;
import com.etema.ragnarstats.config.BalanceConfig;
import com.etema.ragnarstats.core.compute.CombatMath;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public final class StatComputer {
    private static ScriptEngine scriptEngine;

    public static DerivedStats compute(Player p, IPlayerStats s, double weaponATK, double apsArma, double spellBase, double armorEff, double baseCast) {
        int STR = (int)Math.round(StatAttributes.getTotal((Player)p, (StatKeys)StatKeys.STR));
        int AGI = (int)Math.round(StatAttributes.getTotal((Player)p, (StatKeys)StatKeys.AGI));
        int VIT = (int)Math.round(StatAttributes.getTotal((Player)p, (StatKeys)StatKeys.VIT));
        int INT = (int)Math.round(StatAttributes.getTotal((Player)p, (StatKeys)StatKeys.INT));
        int DEX = (int)Math.round(StatAttributes.getTotal((Player)p, (StatKeys)StatKeys.DEX));
        int LUK = (int)Math.round(StatAttributes.getTotal((Player)p, (StatKeys)StatKeys.LUK));
        int LVL = s.getLevel();
        double statusATK = StatComputer.computePhysicalATK(STR, DEX, LUK, LVL);
        double dmgPhysRaw = weaponATK + statusATK;
        double minRoll = (Double)BalanceConfig.MIN_DAMAGE_ROLL.get();
        double dexFactor = CombatMath.clamp(0.0, 1.0, (double)DEX / (Double)BalanceConfig.DEX_VARIANCE_DIVISOR.get());
        double lukBonus = (Double)BalanceConfig.LUK_VARIANCE_BONUS.get() > 0.0 ? (double)LUK / (Double)BalanceConfig.LUK_VARIANCE_BONUS.get() : 0.0;
        double dmgPhysFloor = dmgPhysRaw * (minRoll + (1.0 - minRoll) * (dexFactor + lukBonus));
        double statusMATK = StatComputer.computeMagicalATK(INT, DEX, LUK, LVL);
        double dmgMagic = spellBase + statusMATK;
        double hitA = (Double)BalanceConfig.HIT_BASE.get() + (double)DEX * (Double)BalanceConfig.DEX_TO_HIT_MULT.get() + (double)LUK / (Double)BalanceConfig.LUK_TO_HIT_DIVISOR.get() + (double)LVL * (Double)BalanceConfig.LEVEL_TO_HIT_MULT.get();
        double fleeD = (Double)BalanceConfig.FLEE_BASE.get() + (double)AGI * (Double)BalanceConfig.AGI_TO_FLEE_MULT.get() + (double)LUK / (Double)BalanceConfig.LUK_TO_FLEE_DIVISOR.get() + (double)LVL * (Double)BalanceConfig.LEVEL_TO_FLEE_MULT.get();
        double hitConstant = (Double)BalanceConfig.HIT_FLEE_FORMULA_CONSTANT.get();
        double pHit = CombatMath.clamp(0.05, 0.95, (hitConstant + (hitA - fleeD)) / 100.0);
        double pCrit = (double)LUK / (Double)BalanceConfig.LUK_TO_CRIT_DIVISOR.get() / 100.0;
        if ((Double)BalanceConfig.DEX_TO_CRIT_DIVISOR.get() > 0.0) {
            pCrit += (double)DEX / (Double)BalanceConfig.DEX_TO_CRIT_DIVISOR.get() / 100.0;
        }
        pCrit = CombatMath.clamp(0.0, (Double)BalanceConfig.CRIT_MAX.get(), pCrit);
        double perfectDodge = CombatMath.clamp(0.0, (Double)BalanceConfig.PERFECT_DODGE_MAX.get(), (double)LUK / (Double)BalanceConfig.PERFECT_DODGE_DIVISOR.get() / 100.0);
        double baseAspd = (Double)BalanceConfig.BASE_ASPD.get();
        double aspdMin = (Double)BalanceConfig.ASPD_MIN.get();
        double aspdMax = (Double)BalanceConfig.APS_MAX.get();
        int aspdRoMin = (Integer)BalanceConfig.ASPD_RO_MIN.get();
        int aspdRoMax = (Integer)BalanceConfig.ASPD_RO_MAX.get();
        double aspdRO = CombatMath.clamp(aspdRoMin, aspdRoMax, (double)aspdRoMin + (double)AGI * (Double)BalanceConfig.AGI_TO_ASPD.get() + (double)DEX * (Double)BalanceConfig.DEX_TO_ASPD.get());
        double aps = CombatMath.clamp(aspdMin, aspdMax, baseAspd + (aspdRO - (double)aspdRoMin) / (double)(aspdRoMax - aspdRoMin) * (aspdMax - baseAspd));
        double fixed = baseCast * (Double)BalanceConfig.CAST_FIXED_RATIO.get();
        double variable = baseCast * (1.0 - (Double)BalanceConfig.CAST_FIXED_RATIO.get());
        double castReduction = 0.0;
        if ((Double)BalanceConfig.DEX_TO_CAST_DIVISOR.get() > 0.0) {
            castReduction += (double)DEX / (Double)BalanceConfig.DEX_TO_CAST_DIVISOR.get();
        }
        if ((Double)BalanceConfig.INT_TO_CAST_DIVISOR.get() > 0.0) {
            castReduction += (double)INT / (Double)BalanceConfig.INT_TO_CAST_DIVISOR.get();
        }
        castReduction = CombatMath.clamp(0.0, (Double)BalanceConfig.CAST_REDUCTION_CAP.get(), castReduction);
        double castTime = Math.max((Double)BalanceConfig.CAST_MIN.get(), fixed + (variable *= 1.0 - castReduction));
        double softDEF = StatComputer.computeSoftDEF(VIT, STR);
        double hardDEF = armorEff * (Double)BalanceConfig.ARMOR_HARD_DEF_MULT.get() + (double)VIT * (Double)BalanceConfig.VIT_HARD_DEF_MULT.get() + (double)STR * (Double)BalanceConfig.STR_TO_DEF_MULT.get();
        double defConstant = (Double)BalanceConfig.HARD_DEF_CONSTANT.get();
        double drPhysHard = 1.0 - defConstant / (defConstant + hardDEF);
        double drPhys = CombatMath.clamp(0.0, (Double)BalanceConfig.DR_PHYS_MAX.get(), drPhysHard);
        double mdefBase = (double)INT * (Double)BalanceConfig.INT_MDEF_MULT.get() + (double)VIT * (Double)BalanceConfig.VIT_TO_MDEF_MULT.get();
        double mdefConstant = (Double)BalanceConfig.MDEF_CONSTANT.get();
        double drMagicHard = 1.0 - mdefConstant / (mdefConstant + mdefBase);
        double drMagic = CombatMath.clamp(0.0, (Double)BalanceConfig.DR_MAGIC_MAX.get(), drMagicHard);
        double hpMax = (Double)BalanceConfig.HP_BASE.get() + (double)VIT * (Double)BalanceConfig.VIT_TO_HP_MULT.get() + (double)STR * (Double)BalanceConfig.STR_TO_HP_MULT.get() + (double)LVL * (Double)BalanceConfig.LEVEL_TO_HP_MULT.get();
        if ((Integer)BalanceConfig.VIT_HP_BONUS_DIVISOR.get() > 0) {
            hpMax += Math.floor(VIT / (Integer)BalanceConfig.VIT_HP_BONUS_DIVISOR.get());
        }
        double hpRegenPerSec = (Double)BalanceConfig.HP_REGEN_BASE.get() + (double)VIT * (Double)BalanceConfig.VIT_TO_HP_REGEN.get();
        hpRegenPerSec = Math.min(hpRegenPerSec, hpMax * (Double)BalanceConfig.HP_REGEN_MAX_PERCENT.get());
        double manaMax = (Double)BalanceConfig.MANA_BASE.get() + (double)INT * (Double)BalanceConfig.INT_TO_MANA_MULT.get() + (double)VIT * (Double)BalanceConfig.VIT_TO_MANA_MULT.get() + (double)LVL * (Double)BalanceConfig.LEVEL_TO_MANA_MULT.get();
        if ((Integer)BalanceConfig.INT_MANA_BONUS_DIVISOR.get() > 0) {
            manaMax += Math.floor(INT / (Integer)BalanceConfig.INT_MANA_BONUS_DIVISOR.get());
        }
        double manaRegenPerSec = manaMax * ((Double)BalanceConfig.MANA_REGEN_BASE_PERCENT.get() + (double)INT * (Double)BalanceConfig.INT_TO_MANA_REGEN.get());
        manaRegenPerSec = Math.min(manaRegenPerSec, manaMax * (Double)BalanceConfig.MANA_REGEN_MAX_PERCENT.get());
        DerivedStats d = new DerivedStats();
        d.physicalAttack = dmgPhysRaw;
        d.physicalAttackMin = Math.max(0.0, dmgPhysFloor - softDEF);
        d.physicalAttackMax = dmgPhysRaw;
        d.magicAttack = Math.max(0.0, dmgMagic - (double)INT * (Double)BalanceConfig.MDEF_SOFT_REDUCTION.get());
        d.accuracy = pHit * (1.0 - perfectDodge);
        d.criticalChance = pCrit;
        d.criticalDamageMultiplier = (Double)BalanceConfig.CRIT_BASE_MULT.get() + (double)LUK / (Double)BalanceConfig.LUK_TO_CRIT_DMG_DIVISOR.get() + ((Double)BalanceConfig.STR_TO_CRIT_DMG_DIVISOR.get() > 0.0 ? (double)STR / (Double)BalanceConfig.STR_TO_CRIT_DMG_DIVISOR.get() : 0.0);
        d.flee = CombatMath.clamp(0.0, (Double)BalanceConfig.FLEE_MAX.get(), (fleeD - (Double)BalanceConfig.FLEE_BASE.get()) / 100.0);
        d.attackSpeed = aps;
        d.castTime = castTime;
        d.globalCooldown = aps > 0.0 ? 1.0 / aps : 0.0;
        d.physicalDamageReduction = drPhys;
        d.magicDamageReduction = drMagic;
        d.maxHealth = hpMax;
        d.healthRegenPerSecond = Math.max(0.0, hpRegenPerSec);
        d.maxMana = manaMax;
        d.manaRegenPerSecond = manaRegenPerSec;
        d.defense = hardDEF;
        d.magicDefense = mdefBase;
        MinecraftForge.EVENT_BUS.post((Event)new StatComputeEvent(p, s, d));
        return d;
    }

    private static double computePhysicalATK(int STR, int DEX, int LUK, int LVL) {
        if (((Boolean)BalanceConfig.USE_CUSTOM_FORMULAS.get()).booleanValue() && scriptEngine != null) {
            return StatComputer.evaluateCustomFormula((String)BalanceConfig.CUSTOM_ATK_FORMULA.get(), STR, 0, 0, 0, DEX, LUK, LVL);
        }
        double atk = (double)STR * (Double)BalanceConfig.STR_BASE_MULT.get();
        if (((Boolean)BalanceConfig.USE_STR_SQUARED.get()).booleanValue()) {
            double strDiv = (double)STR / (double)((Integer)BalanceConfig.STR_SQUARED_DIVISOR.get()).intValue();
            atk += strDiv * strDiv * (Double)BalanceConfig.STR_SQUARED_MULT.get();
        }
        atk += (double)DEX / (Double)BalanceConfig.DEX_TO_ATK_DIVISOR.get();
        atk += (double)LUK / (Double)BalanceConfig.LUK_TO_ATK_DIVISOR.get();
        return atk += (double)LVL * (Double)BalanceConfig.LEVEL_TO_ATK_MULT.get();
    }

    public static double computeMagicalATK(int INT, int DEX, int LUK, int LVL) {
        if (((Boolean)BalanceConfig.USE_CUSTOM_FORMULAS.get()).booleanValue() && scriptEngine != null) {
            return StatComputer.evaluateCustomFormula((String)BalanceConfig.CUSTOM_MATK_FORMULA.get(), 0, 0, 0, INT, DEX, LUK, LVL);
        }
        double matk = (double)INT * (Double)BalanceConfig.INT_BASE_MULT.get();
        if (((Boolean)BalanceConfig.USE_INT_SQUARED.get()).booleanValue()) {
            double intDiv = (double)INT / (double)((Integer)BalanceConfig.INT_SQUARED_DIVISOR.get()).intValue();
            matk += intDiv * intDiv * (Double)BalanceConfig.INT_SQUARED_MULT.get();
        }
        matk += (double)DEX / (Double)BalanceConfig.DEX_TO_MATK_DIVISOR.get();
        matk += (double)LUK / (Double)BalanceConfig.LUK_TO_MATK_DIVISOR.get();
        return matk += (double)LVL * (Double)BalanceConfig.LEVEL_TO_MATK_MULT.get();
    }

    private static double computeSoftDEF(int VIT, int STR) {
        if (((Boolean)BalanceConfig.USE_CUSTOM_FORMULAS.get()).booleanValue() && scriptEngine != null) {
            return StatComputer.evaluateCustomFormula((String)BalanceConfig.CUSTOM_DEF_FORMULA.get(), STR, 0, VIT, 0, 0, 0, 0);
        }
        double def = (double)VIT * (Double)BalanceConfig.VIT_SOFT_DEF_BASE.get();
        double vitDiv = (double)VIT / (double)((Integer)BalanceConfig.VIT_SOFT_DEF_DIVISOR.get()).intValue();
        return def += vitDiv * vitDiv * (Double)BalanceConfig.VIT_SOFT_DEF_SQUARED.get();
    }

    private static double evaluateCustomFormula(String formula, int STR, int AGI, int VIT, int INT, int DEX, int LUK, int LVL) {
        try {
            scriptEngine.put("STR", STR);
            scriptEngine.put("AGI", AGI);
            scriptEngine.put("VIT", VIT);
            scriptEngine.put("INT", INT);
            scriptEngine.put("DEX", DEX);
            scriptEngine.put("LUK", LUK);
            scriptEngine.put("LVL", LVL);
            scriptEngine.put("Math", Math.class);
            Object result = scriptEngine.eval(formula);
            if (result instanceof Number) {
                return ((Number)result).doubleValue();
            }
        }
        catch (ScriptException e) {
            e.printStackTrace();
        }
        return 0.0;
    }

    static {
        if (((Boolean)BalanceConfig.USE_CUSTOM_FORMULAS.get()).booleanValue()) {
            ScriptEngineManager manager = new ScriptEngineManager();
            scriptEngine = manager.getEngineByName("JavaScript");
        }
    }
}

