/*
 * Decompiled with CFR 0.152.
 */
package com.etema.ragnarstats.core.event;

import com.etema.ragnarcore.api.RagnarCoreAPI;
import com.etema.ragnarcore.api.compute.DerivedStats;
import com.etema.ragnarcore.api.stats.StatAttributes;
import com.etema.ragnarcore.api.stats.StatKeys;
import com.etema.ragnarstats.config.BalanceConfig;
import com.etema.ragnarstats.core.capability.PlayerStats;
import com.etema.ragnarstats.core.compute.StatComputer;
import com.etema.ragnarstats.core.net.Network;
import com.etema.ragnarstats.core.net.PlayerStatsSyncPacket;
import com.etema.ragnarstats.core.progression.ExpTable;
import com.google.common.collect.Multimap;
import java.util.Map;
import java.util.Random;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="ragnarstats")
public class CommonEvents {
    private static final Random RNG = new Random();
    private static final String RAGNAR_PLAYER_DAMAGE_TAG = "ragnar_player_damage_processed";
    private static final String RAGNAR_PLAYER_DAMAGE_TICK = "ragnar_player_damage_tick";

    @SubscribeEvent
    public static void onJoin(EntityJoinLevelEvent e) {
        Entity entity = e.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)entity;
            RagnarCoreAPI.get((Player)sp).ifPresent(s -> {
                double armaBase = CommonEvents.getWeaponDamage((Player)sp);
                DerivedStats derived = StatComputer.compute((Player)sp, s, armaBase, CommonEvents.getWeaponAPS((Player)sp), 0.0, CommonEvents.getArmorEff((LivingEntity)sp), 1.0);
                if (s instanceof PlayerStats) {
                    PlayerStats internal = (PlayerStats)s;
                    internal.ensureBaseStatBaseline((Integer)BalanceConfig.BASE_STAT_POINTS.get());
                }
                s.setManaMaxClient(derived.maxMana);
                Network.sendToPlayer(sp, new PlayerStatsSyncPacket(s.getMana(), s.getManaMax(), s.getLevel(), s.getExp(), s.getStatPoints(), s.getJobLevel(), s.getJobExp(), s.getSkillPoints(), s.getJobId()));
            });
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent e) {
        if (e.phase != TickEvent.Phase.END || e.player.m_9236_().f_46443_) {
            return;
        }
        ServerPlayer p = (ServerPlayer)e.player;
        RagnarCoreAPI.get((Player)p).ifPresent(stats -> {
            if (stats instanceof PlayerStats) {
                PlayerStats internal = (PlayerStats)stats;
                internal.ensureBaseStatBaseline((Integer)BalanceConfig.BASE_STAT_POINTS.get());
            }
            DerivedStats d = StatComputer.compute((Player)p, stats, 0.0, 1.0, 0.0, CommonEvents.getArmorEff((LivingEntity)p), 1.0);
            double previousManaMax = stats.getManaMax();
            if (Math.abs(previousManaMax - d.maxMana) > 1.0E-4) {
                stats.setManaMaxClient(d.maxMana);
                stats.markDirty();
            }
            stats.addMana(d.manaRegenPerSecond / 20.0);
            if (stats.consumeDirty()) {
                Network.sendToPlayer(p, new PlayerStatsSyncPacket(stats.getMana(), stats.getManaMax(), stats.getLevel(), stats.getExp(), stats.getStatPoints(), stats.getJobLevel(), stats.getJobExp(), stats.getSkillPoints(), stats.getJobId()));
            }
        });
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onHurt(LivingHurtEvent e) {
        Entity entity = e.getSource().m_7639_();
        if (!(entity instanceof Player)) {
            return;
        }
        Player p = (Player)entity;
        LivingEntity tgt = e.getEntity();
        if (tgt.m_9236_().m_5776_()) {
            return;
        }
        if (CommonEvents.isDamageAlreadyProcessedByPlayer(tgt, e.getSource())) {
            return;
        }
        RagnarCoreAPI.get((Player)p).ifPresent(stats -> {
            double dmg;
            double vit = StatAttributes.getTotal((Player)p, (StatKeys)StatKeys.VIT);
            double intel = StatAttributes.getTotal((Player)p, (StatKeys)StatKeys.INT);
            double armaBase = CommonEvents.getWeaponDamage(p);
            double aps = CommonEvents.getWeaponAPS(p);
            double spellBase = 0.0;
            double armorEff = CommonEvents.getArmorEff(tgt);
            double baseCast = 1.0;
            DerivedStats d = StatComputer.compute(p, stats, armaBase, aps, spellBase, armorEff, baseCast);
            if (RNG.nextDouble() > d.accuracy) {
                e.setCanceled(true);
                CommonEvents.spawnMissParticles(tgt);
                CommonEvents.markDamageAsProcessedByPlayer(tgt, e.getSource());
                return;
            }
            boolean isMagic = false;
            double d2 = dmg = isMagic ? d.magicAttack : d.physicalAttack;
            if (RNG.nextDouble() < d.criticalChance) {
                dmg *= d.criticalDamageMultiplier;
            }
            double afterSoft = isMagic ? Math.max(dmg - intel * 0.3, dmg * 0.1) : Math.max(dmg - (vit + Math.floor(vit / 5.0) * Math.floor(vit / 5.0) * 0.2), dmg * 0.1);
            double afterHard = afterSoft * (1.0 - (isMagic ? d.magicDamageReduction : d.physicalDamageReduction));
            if (!isMagic) {
                afterHard = Math.max(afterHard, d.physicalAttackMin);
            }
            e.setAmount((float)afterHard);
            CommonEvents.markDamageAsProcessedByPlayer(tgt, e.getSource());
        });
    }

    @SubscribeEvent
    public static void onDeath(LivingDeathEvent e) {
        Entity entity = e.getSource().m_7639_();
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer sp = (ServerPlayer)entity;
        if (!CommonEvents.isHostileMob(e.getEntity())) {
            return;
        }
        RagnarCoreAPI.get((Player)sp).ifPresent(s -> {
            int baseExp;
            int finalExp = baseExp = CommonEvents.computeKillExp(e.getEntity());
            if (((Boolean)BalanceConfig.MOB_EXP_SCALE_WITH_PLAYER_LEVEL.get()).booleanValue()) {
                finalExp = CommonEvents.applyLevelPenalty(baseExp, sp, e.getEntity(), s.getLevel());
            }
            if (s instanceof PlayerStats) {
                PlayerStats internal = (PlayerStats)s;
                internal.ensureBaseStatBaseline((Integer)BalanceConfig.BASE_STAT_POINTS.get());
            }
            int gained = s.addExpAndProcessLevelUps(finalExp, ((Integer)BalanceConfig.POINTS_PER_LEVEL.get()).intValue(), ExpTable::expToNext);
            int jobGained = s.addJobExpAndProcessLevelUps(finalExp, ExpTable::jobExpToNext);
            s.markDirty();
            sp.m_213846_((Component)Component.m_237110_((String)"message.ragnarstats.exp_gain", (Object[])new Object[]{finalExp, e.getEntity().m_5446_()}));
            if (jobGained > 0) {
                sp.m_213846_((Component)Component.m_237110_((String)"message.ragnarstats.job_level_up", (Object[])new Object[]{jobGained}));
            }
            Network.sendToPlayer(sp, new PlayerStatsSyncPacket(s.getMana(), s.getManaMax(), s.getLevel(), s.getExp(), s.getStatPoints(), s.getJobLevel(), s.getJobExp(), s.getSkillPoints(), s.getJobId()));
        });
    }

    private static boolean isHostileMob(LivingEntity entity) {
        return entity instanceof Monster || entity instanceof WitherBoss || entity instanceof EnderDragon;
    }

    private static int computeKillExp(LivingEntity ent) {
        double hp = ent.m_21233_();
        double baseExp = hp * (Double)BalanceConfig.MOB_EXP_HP_MULTIPLIER.get();
        double armor = ent.m_21230_();
        double armorBonus = armor * (Double)BalanceConfig.MOB_EXP_ARMOR_BONUS.get();
        int totalExp = (int)Math.round(baseExp + armorBonus);
        int minExp = (Integer)BalanceConfig.MOB_EXP_MINIMUM.get();
        int maxExp = (Integer)BalanceConfig.MOB_EXP_MAXIMUM.get();
        return Math.max(minExp, Math.min(maxExp, totalExp));
    }

    private static int applyLevelPenalty(int baseExp, ServerPlayer player, LivingEntity mob, int playerLevel) {
        double range;
        int mobLevel = CommonEvents.estimateMobLevel(mob);
        int levelDiff = Math.abs(playerLevel - mobLevel);
        if ((double)levelDiff <= (range = ((Double)BalanceConfig.MOB_EXP_LEVEL_PENALTY_RANGE.get()).doubleValue())) {
            return baseExp;
        }
        int levelsOutside = (int)((double)levelDiff - range);
        double penalty = Math.pow((Double)BalanceConfig.MOB_EXP_LEVEL_PENALTY_MULT.get(), levelsOutside);
        return Math.max(1, (int)Math.round((double)baseExp * penalty));
    }

    private static int estimateMobLevel(LivingEntity mob) {
        double hp = mob.m_21233_();
        return Math.max(1, (int)(hp / 10.0));
    }

    private static boolean isDamageAlreadyProcessedByPlayer(LivingEntity target, DamageSource source) {
        long currentTick;
        long lastTick;
        CompoundTag data = target.getPersistentData();
        return data.m_128441_(RAGNAR_PLAYER_DAMAGE_TAG) && data.m_128441_(RAGNAR_PLAYER_DAMAGE_TICK) && (lastTick = data.m_128454_(RAGNAR_PLAYER_DAMAGE_TICK)) == (currentTick = target.m_9236_().m_46467_());
    }

    private static void markDamageAsProcessedByPlayer(LivingEntity target, DamageSource source) {
        CompoundTag data = target.getPersistentData();
        data.m_128379_(RAGNAR_PLAYER_DAMAGE_TAG, true);
        data.m_128356_(RAGNAR_PLAYER_DAMAGE_TICK, target.m_9236_().m_46467_());
    }

    private static double getWeaponDamage(Player p) {
        double base = p.m_21172_(Attributes.f_22281_);
        ItemStack main = p.m_21120_(InteractionHand.MAIN_HAND);
        Multimap mods = main.m_41638_(EquipmentSlot.MAINHAND);
        double add = 0.0;
        double multBase = 0.0;
        double multTotal = 0.0;
        for (Map.Entry e : mods.entries()) {
            if (e.getKey() != Attributes.f_22281_) continue;
            AttributeModifier m = (AttributeModifier)e.getValue();
            switch (m.m_22217_()) {
                case ADDITION: {
                    add += m.m_22218_();
                    break;
                }
                case MULTIPLY_BASE: {
                    multBase += m.m_22218_();
                    break;
                }
                case MULTIPLY_TOTAL: {
                    multTotal += m.m_22218_();
                }
            }
        }
        double withItem = (base * (1.0 + multBase) + add) * (1.0 + multTotal);
        float ench = EnchantmentHelper.m_44833_((ItemStack)main, (MobType)MobType.f_21640_);
        return withItem + (double)ench;
    }

    private static double getWeaponAPS(Player p) {
        return 1.6;
    }

    private static double getArmorEff(LivingEntity ent) {
        return ent.m_21230_();
    }

    private static void spawnMissParticles(LivingEntity ent) {
        Vec3 pos = ent.m_20182_();
        ent.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, pos.f_82479_, pos.f_82480_ + (double)ent.m_20206_() * 0.8, pos.f_82481_, 0.0, 0.01, 0.0);
    }
}

