/*
 * Decompiled with CFR 0.152.
 */
package com.etema.ragnarstats.core.net;

import com.etema.ragnarcore.api.RagnarCoreAPI;
import com.etema.ragnarcore.api.stats.IPlayerStats;
import com.etema.ragnarcore.api.stats.StatKeys;
import com.etema.ragnarstats.config.BalanceConfig;
import com.etema.ragnarstats.core.progression.StatCost;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class AllocateStatPacket {
    public final StatKeys key;

    public AllocateStatPacket(StatKeys k) {
        this.key = k;
    }

    public static void encode(AllocateStatPacket m, FriendlyByteBuf buf) {
        buf.m_130068_((Enum)m.key);
    }

    public static AllocateStatPacket decode(FriendlyByteBuf buf) {
        return new AllocateStatPacket((StatKeys)buf.m_130066_(StatKeys.class));
    }

    public static void handle(AllocateStatPacket msg, Supplier<NetworkEvent.Context> ctxSup) {
        NetworkEvent.Context ctx = ctxSup.get();
        ServerPlayer sp = ctx.getSender();
        if (sp == null) {
            ctx.setPacketHandled(true);
            return;
        }
        ctx.enqueueWork(() -> RagnarCoreAPI.get((Player)sp).ifPresent(s -> {
            int maxValue = (Integer)BalanceConfig.MAX_STAT_VALUE.get();
            int currentValue = AllocateStatPacket.getStatValue(s, msg.key);
            if (currentValue >= maxValue) {
                return;
            }
            int cost = StatCost.costToIncrease(currentValue);
            if (s.getStatPoints() < cost) {
                return;
            }
            switch (msg.key) {
                case STR: {
                    s.setSTR(currentValue + 1);
                    break;
                }
                case AGI: {
                    s.setAGI(currentValue + 1);
                    break;
                }
                case VIT: {
                    s.setVIT(currentValue + 1);
                    break;
                }
                case INT: {
                    s.setINT(currentValue + 1);
                    break;
                }
                case DEX: {
                    s.setDEX(currentValue + 1);
                    break;
                }
                case LUK: {
                    s.setLUK(currentValue + 1);
                }
            }
            s.setStatPoints(s.getStatPoints() - cost);
            s.markDirty();
        }));
        ctx.setPacketHandled(true);
    }

    private static int getStatValue(IPlayerStats stats, StatKeys key) {
        return switch (key) {
            default -> throw new IncompatibleClassChangeError();
            case StatKeys.STR -> stats.getSTR();
            case StatKeys.AGI -> stats.getAGI();
            case StatKeys.VIT -> stats.getVIT();
            case StatKeys.INT -> stats.getINT();
            case StatKeys.DEX -> stats.getDEX();
            case StatKeys.LUK -> stats.getLUK();
        };
    }
}

