/*
 * Decompiled with CFR 0.152.
 */
package com.etema.ragnarstats.core.net;

import com.etema.ragnarcore.api.RagnarCoreAPI;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class PlayerStatsSyncPacket {
    public final double mana;
    public final double manaMax;
    public final int level;
    public final int exp;
    public final int statPoints;
    public final int jobLevel;
    public final int jobExp;
    public final int skillPoints;
    public final String jobId;

    public PlayerStatsSyncPacket(double mana, double manaMax, int level, int exp, int statPoints, int jobLevel, int jobExp, int skillPoints, String jobId) {
        this.mana = mana;
        this.manaMax = manaMax;
        this.level = level;
        this.exp = exp;
        this.statPoints = statPoints;
        this.jobLevel = jobLevel;
        this.jobExp = jobExp;
        this.skillPoints = skillPoints;
        this.jobId = jobId == null ? "" : jobId;
    }

    public static void encode(PlayerStatsSyncPacket m, FriendlyByteBuf buf) {
        buf.writeDouble(m.mana);
        buf.writeDouble(m.manaMax);
        buf.m_130130_(m.level);
        buf.m_130130_(m.exp);
        buf.m_130130_(m.statPoints);
        buf.m_130130_(m.jobLevel);
        buf.m_130130_(m.jobExp);
        buf.m_130130_(m.skillPoints);
        buf.m_130070_(m.jobId);
    }

    public static PlayerStatsSyncPacket decode(FriendlyByteBuf buf) {
        return new PlayerStatsSyncPacket(buf.readDouble(), buf.readDouble(), buf.m_130242_(), buf.m_130242_(), buf.m_130242_(), buf.m_130242_(), buf.m_130242_(), buf.m_130242_(), buf.m_130277_());
    }

    public static void handle(PlayerStatsSyncPacket msg, Supplier<NetworkEvent.Context> ctxSup) {
        NetworkEvent.Context ctx = ctxSup.get();
        ctx.enqueueWork(() -> {
            LocalPlayer p = Minecraft.m_91087_().f_91074_;
            if (p == null) {
                return;
            }
            RagnarCoreAPI.get((Player)p).ifPresent(s -> {
                s.setMana(msg.mana);
                s.setManaMaxClient(msg.manaMax);
                s.setLevel(msg.level);
                s.setExp(msg.exp);
                s.setStatPoints(msg.statPoints);
                s.setJobLevel(msg.jobLevel);
                s.setJobExp(msg.jobExp);
                s.setSkillPoints(msg.skillPoints);
                s.setJobId(msg.jobId);
            });
        });
        ctx.setPacketHandled(true);
    }
}

