/*
 * Decompiled with CFR 0.152.
 */
package com.etema.ragnarstats.core.progression;

import com.etema.ragnarstats.config.BalanceConfig;
import com.etema.ragnarstats.core.progression.ExperienceHooks;
import java.util.function.Function;
import java.util.function.IntUnaryOperator;

public final class ExpTable {
    public static int expToNext(int level) {
        int result = ExpTable.applyCustomCurve(level, (String)BalanceConfig.EXP_CURVE_FORMULA.get(), ExperienceHooks::getExpCurve);
        if (result > 0) {
            return result;
        }
        double base = (Double)BalanceConfig.EXP_BASE.get();
        double growth = (Double)BalanceConfig.EXP_GROWTH_RATE.get();
        int minimum = (Integer)BalanceConfig.EXP_MINIMUM.get();
        int expRequired = (int)Math.round(base * Math.pow(growth, Math.max(0, level - 1)));
        return Math.max(minimum, expRequired);
    }

    public static int jobExpToNext(int jobLevel) {
        int result = ExpTable.applyCustomCurve(jobLevel, (String)BalanceConfig.JOB_EXP_CURVE_FORMULA.get(), ExperienceHooks::getJobExpCurve);
        if (result > 0) {
            return result;
        }
        double base = (Double)BalanceConfig.JOB_EXP_BASE.get();
        double growth = (Double)BalanceConfig.JOB_EXP_GROWTH_RATE.get();
        int minimum = (Integer)BalanceConfig.JOB_EXP_MINIMUM.get();
        int expRequired = (int)Math.round(base * Math.pow(growth, Math.max(0, jobLevel - 1)));
        return Math.max(minimum, expRequired);
    }

    public static long getTotalExpForLevel(int targetLevel) {
        long total = 0L;
        for (int lvl = 1; lvl < targetLevel; ++lvl) {
            total += (long)ExpTable.expToNext(lvl);
        }
        return total;
    }

    public static int getLevelFromTotalExp(long totalExp) {
        int needed;
        int level = 1;
        for (long accumulated = 0L; accumulated < totalExp && level < (Integer)BalanceConfig.MAX_LEVEL.get() && accumulated + (long)(needed = ExpTable.expToNext(level)) <= totalExp; accumulated += (long)needed, ++level) {
        }
        return level;
    }

    public static float getProgressPercent(int currentExp, int level) {
        int needed = ExpTable.expToNext(level);
        if (needed <= 0) {
            return 1.0f;
        }
        return Math.min(1.0f, (float)currentExp / (float)needed);
    }

    public static float getJobProgressPercent(int currentExp, int jobLevel) {
        int needed = ExpTable.jobExpToNext(jobLevel);
        if (needed <= 0) {
            return 1.0f;
        }
        return Math.min(1.0f, (float)currentExp / (float)needed);
    }

    private static int applyCustomCurve(int level, String curveId, Function<String, IntUnaryOperator> resolver) {
        IntUnaryOperator operator;
        if (curveId != null && (operator = resolver.apply(curveId)) != null) {
            return Math.max(1, operator.applyAsInt(level));
        }
        return -1;
    }
}

