/*
 * Decompiled with CFR 0.152.
 */
package net.fneifnox.custommobattributes;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.fneifnox.custommobattributes.config.Config;
import net.fneifnox.custommobattributes.init.Vanilla;
import net.fneifnox.custommobattributes.init.compat.BetterEndCompat;
import net.fneifnox.custommobattributes.init.compat.BetterNetherCompat;
import net.fneifnox.custommobattributes.init.compat.DeeperAndDarkerCompat;
import net.fneifnox.custommobattributes.init.compat.FriendsAndFoesCompat;
import net.fneifnox.custommobattributes.init.compat.IllagerInvasionCompat;
import net.fneifnox.custommobattributes.init.compat.ItTakesAPillageContinuationCompat;
import net.fneifnox.custommobattributes.init.compat.MobVariantsCompat;
import net.fneifnox.custommobattributes.init.compat.VanillaBackportCompat;
import net.fneifnox.custommobattributes.init.compat.VariantsAndVenturesCompat;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber(modid="custom_mob_attributes", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class AttributeUpdater {
    private static final ResourceLocation HEALTH_MODIFIER_UUID = ResourceLocation.fromNamespaceAndPath((String)"custom_mob_attributes", (String)"health_modifier");
    private static final ResourceLocation DAMAGE_MODIFIER_UUID = ResourceLocation.fromNamespaceAndPath((String)"custom_mob_attributes", (String)"damage_modifier");
    private static final ResourceLocation SPEED_MODIFIER_UUID = ResourceLocation.fromNamespaceAndPath((String)"custom_mob_attributes", (String)"speed_modifier");
    private static final ResourceLocation SCALE_MODIFIER_UUID = ResourceLocation.fromNamespaceAndPath((String)"custom_mob_attributes", (String)"scale_modifier");
    public static final Map<EntityType<?>, Consumer<LivingEntity>> ATTRIBUTE_HANDLERS = new HashMap();
    private static final Map<LivingEntity, Integer> pendingEntities = new ConcurrentHashMap<LivingEntity, Integer>();

    public static void register() {
        Vanilla.initVanillaAttributeHandlers();
        if (ModList.get().isLoaded("vanillabackport")) {
            VanillaBackportCompat.initVanillaBackportAttributeHandlers();
        }
        if (ModList.get().isLoaded("frycmobvariants")) {
            MobVariantsCompat.initMobVariantsAttributeHandlers();
        }
        if (ModList.get().isLoaded("betterend")) {
            BetterEndCompat.initBetterEndAttributeHandlers();
        }
        if (ModList.get().isLoaded("betternether")) {
            BetterNetherCompat.initBetterNetherAttributeHandlers();
        }
        if (ModList.get().isLoaded("variantsandventures")) {
            VariantsAndVenturesCompat.initVariantsAndVenturesAttributeHandlers();
        }
        if (ModList.get().isLoaded("friendsandfoes")) {
            FriendsAndFoesCompat.initFriendsAndFoesAttributeHandlers();
        }
        if (ModList.get().isLoaded("takesapillage")) {
            ItTakesAPillageContinuationCompat.initItTakesAPillageContinuationAttributeHandlers();
        }
        if (ModList.get().isLoaded("deeperdarker")) {
            DeeperAndDarkerCompat.initDeeperAndDarkerAttributeHandlers();
        }
        if (ModList.get().isLoaded("illagerinvasion")) {
            IllagerInvasionCompat.initIllagerInvasionAttributeHandlers();
        }
    }

    @SubscribeEvent
    public static void onEntityJoinWorld(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        Level world = event.getLevel();
        if (entity instanceof LivingEntity) {
            Consumer<LivingEntity> handler;
            LivingEntity living = (LivingEntity)entity;
            if (!world.isClientSide() && (handler = ATTRIBUTE_HANDLERS.get(entity.getType())) != null) {
                pendingEntities.put(living, 0);
            }
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            Iterator<Map.Entry<LivingEntity, Integer>> it = pendingEntities.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<LivingEntity, Integer> entry = it.next();
                LivingEntity entity = entry.getKey();
                int ticks = entry.getValue() + 1;
                if (!entity.isAlive()) {
                    it.remove();
                    continue;
                }
                if (ticks >= 1) {
                    EntityType type = entity.getType();
                    Consumer<LivingEntity> handler = ATTRIBUTE_HANDLERS.get(type);
                    if (handler != null) {
                        handler.accept(entity);
                    }
                    it.remove();
                    continue;
                }
                entry.setValue(ticks);
            }
        }
    }

    public static <T extends LivingEntity> void configureEntityAttributes(Level world, EntityType<T> entityType, @Nullable Supplier<Double> healthMultiplier, @Nullable Supplier<Double> damageMultiplier, @Nullable Supplier<Double> speedMultiplier, @Nullable Supplier<Double> scaleMultiplier) {
        AABB box = new AABB(new Vec3(-1000000.0, -1000000.0, -1000000.0), new Vec3(1000000.0, 1000000.0, 1000000.0));
        Predicate<Entity> predicate = entityType == EntityType.ENDER_DRAGON ? e -> e instanceof EnderDragon : e -> e instanceof LivingEntity;
        for (LivingEntity entity : world.getEntities(entityType, box, predicate)) {
            AttributeInstance health = entity.getAttribute(Attributes.MAX_HEALTH);
            if (health != null) {
                double val = health.getBaseValue() * healthMultiplier.get() * (Double)Config.VANILLA.healthMultiplierForAll.get();
                if (health.getValue() != val) {
                    AttributeUpdater.updateModifier(entity, (Holder<Attribute>)Attributes.MAX_HEALTH, HEALTH_MODIFIER_UUID, healthMultiplier.get() * (Double)Config.VANILLA.healthMultiplierForAll.get());
                    entity.setHealth((float)val);
                }
            }
            if (damageMultiplier != null) {
                AttributeUpdater.updateModifier(entity, (Holder<Attribute>)Attributes.ATTACK_DAMAGE, DAMAGE_MODIFIER_UUID, damageMultiplier.get() * (Double)Config.VANILLA.damageMultiplierForAll.get());
            }
            if (speedMultiplier != null) {
                AttributeUpdater.updateModifier(entity, (Holder<Attribute>)Attributes.MOVEMENT_SPEED, SPEED_MODIFIER_UUID, speedMultiplier.get() * (Double)Config.VANILLA.speedMultiplierForAll.get());
                if (entity.getAttribute(Attributes.FLYING_SPEED) != null) {
                    AttributeUpdater.updateModifier(entity, (Holder<Attribute>)Attributes.FLYING_SPEED, SPEED_MODIFIER_UUID, speedMultiplier.get() * (Double)Config.VANILLA.speedMultiplierForAll.get());
                }
            }
            if (scaleMultiplier == null) continue;
            AttributeUpdater.updateModifier(entity, (Holder<Attribute>)Attributes.SCALE, SCALE_MODIFIER_UUID, scaleMultiplier.get() * (Double)Config.VANILLA.scaleMultiplierForAll.get());
        }
    }

    private static void updateModifier(LivingEntity entity, Holder<Attribute> entry, ResourceLocation id, double multiplier) {
        AttributeInstance attrInstance = entity.getAttribute(entry);
        if (attrInstance == null) {
            return;
        }
        AttributeModifier oldModifier = attrInstance.getModifier(id);
        if (oldModifier != null) {
            attrInstance.removeModifier(oldModifier);
        }
        if (multiplier == 1.0) {
            return;
        }
        double amount = attrInstance.getBaseValue() * (multiplier - 1.0);
        AttributeModifier modifier = new AttributeModifier(id, amount, AttributeModifier.Operation.ADD_VALUE);
        attrInstance.addPermanentModifier(modifier);
    }
}

