/*
 * Decompiled with CFR 0.152.
 */
package net.fneifnox.custommobattributes.mixin.damage;

import java.util.Objects;
import net.fneifnox.custommobattributes.config.Config;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.Bogged;
import net.minecraft.world.entity.monster.Pillager;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Stray;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.entity.projectile.SpectralArrow;
import net.minecraftforge.fml.ModList;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={AbstractArrow.class})
public class ArrowMixin {
    @Redirect(method={"onEntityHit"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/Entity;damage(Lnet/minecraft/entity/damage/DamageSource;F)Z"))
    private boolean redirectDamage(Entity entity, DamageSource source, float originalDamage) {
        AbstractArrow projectile = (AbstractArrow)this;
        if (projectile instanceof SpectralArrow || projectile instanceof Arrow) {
            double multiplier = 1.0;
            if (projectile.getOwner() instanceof Skeleton) {
                multiplier = (Double)Config.VANILLA.damageMultiplierForSkeleton.get() * (Double)Config.VANILLA.damageMultiplierForAll.get();
            } else if (projectile.getOwner() instanceof Stray) {
                multiplier = (Double)Config.VANILLA.damageMultiplierForStray.get() * (Double)Config.VANILLA.damageMultiplierForAll.get();
            } else if (projectile.getOwner() instanceof Bogged) {
                multiplier = (Double)Config.VANILLA.damageMultiplierForBogged.get() * (Double)Config.VANILLA.damageMultiplierForAll.get();
            } else if (projectile.getOwner() instanceof Piglin) {
                multiplier = (Double)Config.VANILLA.damageMultiplierForPiglin.get() * (Double)Config.VANILLA.damageMultiplierForAll.get();
            } else if (projectile.getOwner() instanceof Pillager) {
                multiplier = (Double)Config.VANILLA.damageMultiplierForPillager.get() * (Double)Config.VANILLA.damageMultiplierForAll.get();
            } else {
                if (ModList.get().isLoaded("frycmobvariants")) {
                    EntityType infectedPiglin = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(ResourceLocation.fromNamespaceAndPath((String)"frycmobvariants", (String)"infected_piglin"));
                    EntityType undeadWarrior = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(ResourceLocation.fromNamespaceAndPath((String)"frycmobvariants", (String)"undead_warrior"));
                    if (Objects.requireNonNull(projectile.getOwner()).getType() == infectedPiglin) {
                        multiplier = (Double)Config.MOB_VARIANTS.damageMultiplierForInfectedPiglin.get() * (Double)Config.VANILLA.damageMultiplierForAll.get();
                    } else if (Objects.requireNonNull(projectile.getOwner()).getType() == undeadWarrior) {
                        multiplier = (Double)Config.MOB_VARIANTS.damageMultiplierForUndeadWarrior.get() * (Double)Config.VANILLA.damageMultiplierForAll.get();
                    }
                }
                if (ModList.get().isLoaded("betternether")) {
                    EntityType jungleSkeleton = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(ResourceLocation.fromNamespaceAndPath((String)"betternether", (String)"jungle_skeleton"));
                    if (Objects.requireNonNull(projectile.getOwner()).getType() == jungleSkeleton) {
                        multiplier = (Double)Config.BETTER_NETHER.damageMultiplierForJungleSkeleton.get() * (Double)Config.VANILLA.damageMultiplierForAll.get();
                    }
                }
                if (ModList.get().isLoaded("variantsandventures")) {
                    EntityType murk = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(ResourceLocation.fromNamespaceAndPath((String)"variantsandventures", (String)"murk"));
                    EntityType verdant = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(ResourceLocation.fromNamespaceAndPath((String)"variantsandventures", (String)"verdant"));
                    if (Objects.requireNonNull(projectile.getOwner()).getType() == murk) {
                        multiplier = (Double)Config.VARIANTS_AND_VENTURES.damageMultiplierForMurk.get() * (Double)Config.VANILLA.damageMultiplierForAll.get();
                    } else if (Objects.requireNonNull(projectile.getOwner()).getType() == verdant) {
                        multiplier = (Double)Config.VARIANTS_AND_VENTURES.damageMultiplierForVerdant.get() * (Double)Config.VANILLA.damageMultiplierForAll.get();
                    }
                }
                if (ModList.get().isLoaded("takesapillage")) {
                    EntityType archer = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(ResourceLocation.fromNamespaceAndPath((String)"takesapillage", (String)"archer"));
                    if (Objects.requireNonNull(projectile.getOwner()).getType() == archer) {
                        multiplier = (Double)Config.IT_TAKES_A_PILLAGE_CONTINUATION.damageMultiplierForArcher.get() * (Double)Config.VANILLA.damageMultiplierForAll.get();
                    }
                }
                if (ModList.get().isLoaded("illagerinvasion")) {
                    EntityType alchemist = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(ResourceLocation.fromNamespaceAndPath((String)"illagerinvasion", (String)"alchemist"));
                    EntityType provoker = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(ResourceLocation.fromNamespaceAndPath((String)"illagerinvasion", (String)"provoker"));
                    if (Objects.requireNonNull(projectile.getOwner()).getType() == alchemist) {
                        multiplier = (Double)Config.ILLAGER_INVASION.damageMultiplierForAlchemist.get() * (Double)Config.VANILLA.damageMultiplierForAll.get();
                    } else if (Objects.requireNonNull(projectile.getOwner()).getType() == provoker) {
                        multiplier = (Double)Config.ILLAGER_INVASION.damageMultiplierForProvoker.get() * (Double)Config.VANILLA.damageMultiplierForAll.get();
                    }
                }
            }
            double finalDamage = (double)originalDamage * multiplier;
            return entity.hurt(source, (float)finalDamage);
        }
        return entity.hurt(source, originalDamage);
    }
}

