/*
 * Decompiled with CFR 0.152.
 */
package net.fneifnox.custommobattributes.mixin.movement;

import net.fneifnox.custommobattributes.config.Config;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.animal.Cod;
import net.minecraft.world.entity.animal.Pufferfish;
import net.minecraft.world.entity.animal.Salmon;
import net.minecraft.world.entity.animal.TropicalFish;
import net.minecraft.world.entity.animal.frog.Tadpole;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={AbstractFish.class})
public abstract class FishSpeedMixin {
    @Redirect(method={"travel"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/animal/AbstractFish;moveRelative(FLnet/minecraft/world/phys/Vec3;)V"))
    private void modifySpeed(AbstractFish instance, float speed, Vec3 movementInput) {
        double finalSpeed = speed;
        if (instance instanceof Cod) {
            finalSpeed = (double)speed * (Double)Config.VANILLA.speedMultiplierForCod.get() * (Double)Config.VANILLA.speedMultiplierForAll.get();
        } else if (instance instanceof TropicalFish) {
            finalSpeed = (double)speed * (Double)Config.VANILLA.speedMultiplierForTropicalFish.get() * (Double)Config.VANILLA.speedMultiplierForAll.get();
        } else if (instance instanceof Salmon) {
            finalSpeed = (double)speed * (Double)Config.VANILLA.speedMultiplierForSalmon.get() * (Double)Config.VANILLA.speedMultiplierForAll.get();
        } else if (instance instanceof Pufferfish) {
            finalSpeed = (double)speed * (Double)Config.VANILLA.speedMultiplierForPufferfish.get() * (Double)Config.VANILLA.speedMultiplierForAll.get();
        } else if (instance instanceof Tadpole) {
            finalSpeed = (double)speed * (Double)Config.VANILLA.speedMultiplierForTadpole.get() * (Double)Config.VANILLA.speedMultiplierForAll.get();
        }
        instance.moveRelative((float)finalSpeed, movementInput);
    }
}

