/*
 * Decompiled with CFR 0.152.
 */
package net.fneifnox.custommobattributes;

import io.wispforest.owo.config.Option;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerEntityEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.fneifnox.custommobattributes.CustomMobAttributes;
import net.fneifnox.custommobattributes.init.Vanilla;
import net.fneifnox.custommobattributes.init.compat.BetterEndCompat;
import net.fneifnox.custommobattributes.init.compat.BetterNetherCompat;
import net.fneifnox.custommobattributes.init.compat.DeeperAndDarkerCompat;
import net.fneifnox.custommobattributes.init.compat.FriendsAndFoesCompat;
import net.fneifnox.custommobattributes.init.compat.IllagerInvasionCompat;
import net.fneifnox.custommobattributes.init.compat.ItTakesAPillageContinuationCompat;
import net.fneifnox.custommobattributes.init.compat.MobVariantsCompat;
import net.fneifnox.custommobattributes.init.compat.RibbitsCompat;
import net.fneifnox.custommobattributes.init.compat.VanillaBackportCompat;
import net.fneifnox.custommobattributes.init.compat.VariantsAndVenturesCompat;
import net.fneifnox.custommobattributes.init.compat.ZombieVariantsCompat;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1510;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5134;
import net.minecraft.class_6880;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class AttributeUpdater {
    private static final class_2960 HEALTH_MODIFIER_UUID = class_2960.method_60655((String)"custom_mob_attributes", (String)"health_modifier");
    private static final class_2960 DAMAGE_MODIFIER_UUID = class_2960.method_60655((String)"custom_mob_attributes", (String)"damage_modifier");
    private static final class_2960 SPEED_MODIFIER_UUID = class_2960.method_60655((String)"custom_mob_attributes", (String)"speed_modifier");
    private static final class_2960 SCALE_MODIFIER_UUID = class_2960.method_60655((String)"custom_mob_attributes", (String)"scale_modifier");
    public static final Map<class_1299<?>, Consumer<class_1309>> ATTRIBUTE_HANDLERS = new HashMap();

    public static void register() {
        Vanilla.initVanillaAttributeHandlers();
        if (FabricLoader.getInstance().isModLoaded("vanillabackport")) {
            VanillaBackportCompat.initVanillaBackportAttributeHandlers();
        }
        if (FabricLoader.getInstance().isModLoaded("frycmobvariants")) {
            MobVariantsCompat.initMobVariantsAttributeHandlers();
        }
        if (FabricLoader.getInstance().isModLoaded("betterend")) {
            BetterEndCompat.initBetterEndAttributeHandlers();
        }
        if (FabricLoader.getInstance().isModLoaded("betternether")) {
            BetterNetherCompat.initBetterNetherAttributeHandlers();
        }
        if (FabricLoader.getInstance().isModLoaded("variantsandventures")) {
            VariantsAndVenturesCompat.initVariantsAndVenturesAttributeHandlers();
        }
        if (FabricLoader.getInstance().isModLoaded("friendsandfoes")) {
            FriendsAndFoesCompat.initFriendsAndFoesAttributeHandlers();
        }
        if (FabricLoader.getInstance().isModLoaded("takesapillage")) {
            ItTakesAPillageContinuationCompat.initItTakesAPillageContinuationAttributeHandlers();
        }
        if (FabricLoader.getInstance().isModLoaded("deeperdarker")) {
            DeeperAndDarkerCompat.initDeeperAndDarkerAttributeHandlers();
        }
        if (FabricLoader.getInstance().isModLoaded("illagerinvasion")) {
            IllagerInvasionCompat.initIllagerInvasionAttributeHandlers();
        }
        if (FabricLoader.getInstance().isModLoaded("zombie_variants")) {
            ZombieVariantsCompat.initZombieVariantsAttributeHandlers();
        }
        if (FabricLoader.getInstance().isModLoaded("ribbits")) {
            RibbitsCompat.initRibbitsAttributeHandlers();
        }
        ServerEntityEvents.ENTITY_LOAD.register((entity, world) -> {
            if (entity instanceof class_1309) {
                Consumer<class_1309> handler;
                class_1309 living = (class_1309)entity;
                if (!world.field_9236 && (handler = ATTRIBUTE_HANDLERS.get(entity.method_5864())) != null) {
                    handler.accept(living);
                }
            }
        });
    }

    public static void reloadConfig(MinecraftServer server) {
        for (class_3218 world : server.method_3738()) {
            for (class_1297 entity : world.method_27909()) {
                if (!(entity instanceof class_1309)) continue;
                class_1309 living = (class_1309)entity;
                Consumer<class_1309> handler = ATTRIBUTE_HANDLERS.get(entity.method_5864());
                if (handler == null) continue;
                handler.accept(living);
            }
        }
    }

    public static void observeAllConfigChanges(Runnable callback) {
        for (Field field : ((Object)((Object)CustomMobAttributes.CONFIG)).getClass().getDeclaredFields()) {
            if (!Option.class.isAssignableFrom(field.getType())) continue;
            field.setAccessible(true);
            try {
                Option option = (Option)field.get((Object)CustomMobAttributes.CONFIG);
                option.observe(val -> callback.run());
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    public static <T extends class_1309> void configureEntityAttributes(class_1937 world, class_1299<T> entityType, @Nullable Supplier<Double> healthMultiplier, @Nullable Supplier<Double> damageMultiplier, @Nullable Supplier<Double> speedMultiplier, @Nullable Supplier<Double> scaleMultiplier) {
        class_238 box = new class_238(new class_243(-1000000.0, -1000000.0, -1000000.0), new class_243(1000000.0, 1000000.0, 1000000.0));
        Predicate<class_1297> predicate = entityType == class_1299.field_6116 ? e -> e instanceof class_1510 : e -> e instanceof class_1309;
        for (class_1309 entity : world.method_18023(entityType, box, predicate)) {
            double val;
            class_1324 health;
            if (CustomMobAttributes.CONFIG.parentsAlsoAffectBabies() && entity.method_6109()) {
                health = entity.method_5996(class_5134.field_23716);
                if (health != null) {
                    val = health.method_6201() * healthMultiplier.get() * CustomMobAttributes.CONFIG.healthMultiplierForBabyAll() * CustomMobAttributes.CONFIG.healthMultiplierForAll();
                    if (health.method_6194() != val) {
                        AttributeUpdater.updateModifier(entity, (class_6880<class_1320>)class_5134.field_23716, HEALTH_MODIFIER_UUID, healthMultiplier.get() * CustomMobAttributes.CONFIG.healthMultiplierForBabyAll() * CustomMobAttributes.CONFIG.healthMultiplierForAll());
                        entity.method_6033((float)val);
                    }
                }
                if (damageMultiplier != null) {
                    AttributeUpdater.updateModifier(entity, (class_6880<class_1320>)class_5134.field_23721, DAMAGE_MODIFIER_UUID, damageMultiplier.get() * CustomMobAttributes.CONFIG.damageMultiplierForBabyAll() * CustomMobAttributes.CONFIG.damageMultiplierForAll());
                }
                if (speedMultiplier != null) {
                    AttributeUpdater.updateModifier(entity, (class_6880<class_1320>)class_5134.field_23719, SPEED_MODIFIER_UUID, speedMultiplier.get() * CustomMobAttributes.CONFIG.speedMultiplierForBabyAll() * CustomMobAttributes.CONFIG.speedMultiplierForAll());
                    if (entity.method_5996(class_5134.field_23720) != null) {
                        AttributeUpdater.updateModifier(entity, (class_6880<class_1320>)class_5134.field_23720, SPEED_MODIFIER_UUID, speedMultiplier.get() * CustomMobAttributes.CONFIG.speedMultiplierForBabyAll() * CustomMobAttributes.CONFIG.speedMultiplierForAll());
                    }
                }
                if (scaleMultiplier == null) continue;
                AttributeUpdater.updateModifier(entity, (class_6880<class_1320>)class_5134.field_47760, SCALE_MODIFIER_UUID, scaleMultiplier.get() * CustomMobAttributes.CONFIG.scaleMultiplierForBabyAll() * CustomMobAttributes.CONFIG.scaleMultiplierForAll());
                continue;
            }
            health = entity.method_5996(class_5134.field_23716);
            if (health != null) {
                val = health.method_6201() * healthMultiplier.get() * (entity.method_6109() ? CustomMobAttributes.CONFIG.healthMultiplierForBabyAll() : CustomMobAttributes.CONFIG.healthMultiplierForAll());
                if (health.method_6194() != val) {
                    AttributeUpdater.updateModifier(entity, (class_6880<class_1320>)class_5134.field_23716, HEALTH_MODIFIER_UUID, healthMultiplier.get() * (entity.method_6109() ? CustomMobAttributes.CONFIG.healthMultiplierForBabyAll() : CustomMobAttributes.CONFIG.healthMultiplierForAll()));
                    entity.method_6033((float)val);
                }
            }
            if (damageMultiplier != null) {
                AttributeUpdater.updateModifier(entity, (class_6880<class_1320>)class_5134.field_23721, DAMAGE_MODIFIER_UUID, damageMultiplier.get() * (entity.method_6109() ? CustomMobAttributes.CONFIG.damageMultiplierForBabyAll() : CustomMobAttributes.CONFIG.damageMultiplierForAll()));
            }
            if (speedMultiplier != null) {
                AttributeUpdater.updateModifier(entity, (class_6880<class_1320>)class_5134.field_23719, SPEED_MODIFIER_UUID, speedMultiplier.get() * (entity.method_6109() ? CustomMobAttributes.CONFIG.speedMultiplierForBabyAll() : CustomMobAttributes.CONFIG.speedMultiplierForAll()));
                if (entity.method_5996(class_5134.field_23720) != null) {
                    AttributeUpdater.updateModifier(entity, (class_6880<class_1320>)class_5134.field_23720, SPEED_MODIFIER_UUID, speedMultiplier.get() * (entity.method_6109() ? CustomMobAttributes.CONFIG.speedMultiplierForBabyAll() : CustomMobAttributes.CONFIG.speedMultiplierForAll()));
                }
            }
            if (scaleMultiplier == null) continue;
            AttributeUpdater.updateModifier(entity, (class_6880<class_1320>)class_5134.field_47760, SCALE_MODIFIER_UUID, scaleMultiplier.get() * (entity.method_6109() ? CustomMobAttributes.CONFIG.scaleMultiplierForBabyAll() : CustomMobAttributes.CONFIG.scaleMultiplierForAll()));
        }
    }

    private static void updateModifier(class_1309 entity, class_6880<class_1320> entry, class_2960 id, double multiplier) {
        class_1324 attrInstance = entity.method_5996(entry);
        if (attrInstance == null) {
            return;
        }
        class_1322 oldModifier = attrInstance.method_6199(id);
        if (oldModifier != null) {
            attrInstance.method_6202(oldModifier);
        }
        if (multiplier == 1.0) {
            return;
        }
        double amount = attrInstance.method_6201() * (multiplier - 1.0);
        class_1322 modifier = new class_1322(id, amount, class_1322.class_1323.field_6328);
        attrInstance.method_26837(modifier);
    }
}

